/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.camel.camel42;

import io.quarkus.updates.camel.AbstractCamelQuarkusJavaVisitor;
import io.quarkus.updates.camel.RecipesUtil;
import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public final class CamelSagaRecipe
extends Recipe {
    private static final String M_NEW_SAGA = "org.apache.camel.saga.InMemorySagaService newSaga()";
    private static final String M_SAGA_COORDINATOR_COMPENSATE = "org.apache.camel.saga.CamelSagaCoordinator compensate()";
    private static final String M_SAGA_COORDINATOR_COMPLETE = "org.apache.camel.saga.CamelSagaCoordinator complete()";

    public String getDisplayName() {
        return "Camel Core changes";
    }

    public String getDescription() {
        return "Apache Camel Core migration from version 4.0 to 4.1.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return RecipesUtil.newVisitor(new AbstractCamelQuarkusJavaVisitor(){

            @Override
            protected J.MethodInvocation doVisitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation mi = super.doVisitMethodInvocation(method, context);
                if ((this.getMethodMatcher(CamelSagaRecipe.M_NEW_SAGA).matches(mi, false) || this.getMethodMatcher(CamelSagaRecipe.M_SAGA_COORDINATOR_COMPENSATE).matches(mi, false) || this.getMethodMatcher(CamelSagaRecipe.M_SAGA_COORDINATOR_COMPLETE).matches(mi, false)) && RecipesUtil.methodInvocationAreArgumentEmpty(mi)) {
                    J.Identifier type = RecipesUtil.createIdentifier(Space.EMPTY, "Exchange", "import org.apache.camel.Exchange");
                    J.TypeCast cp = (J.TypeCast)RecipesUtil.createTypeCast(type, RecipesUtil.createNullExpression());
                    mi = mi.withArguments(Collections.singletonList((Expression)cp.withComments(Collections.singletonList(RecipesUtil.createMultinlineComment("Exchange parameter was added.")))));
                }
                return mi;
            }
        });
    }

    @NonNull
    public String toString() {
        return "CamelSagaRecipe()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelSagaRecipe)) {
            return false;
        }
        CamelSagaRecipe other = (CamelSagaRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CamelSagaRecipe;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

