/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class EqualityRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with (in)equalities";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.EqualityRules`. [Source](https://error-prone.picnic.tech/refasterrules/EqualityRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new DoubleNegationRecipe(), new NegationRecipe(), new IndirectDoubleNegationRecipe()});
    }

    @NonNullApi
    public static class DoubleNegationRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Avoid double negations; this is not Javascript";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleNegation {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S2761\")\n    boolean before(boolean b) {\n        return !!b;\n    }\n    \n    @AfterTemplate\n    @CanIgnoreReturnValue\n    boolean after(boolean b) {\n        return b;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"!!#{b:any(boolean)}").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{b:any(boolean)}").build();

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
            return javaVisitor;
        }
    }

    @NonNullApi
    public static class NegationRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Don't negate an equality test or use the ternary operator to compare two booleans; directly test for inequality instead";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"java:S1940\")\nstatic final class Negation {\n    \n    @BeforeTemplate\n    boolean before(boolean a, boolean b) {\n        return Refaster.anyOf(!(a == b), a ? !b : b);\n    }\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S1244\")\n    boolean before(double a, double b) {\n        return !(a == b);\n    }\n    \n    @BeforeTemplate\n    boolean before(Object a, Object b) {\n        return !(a == b);\n    }\n    \n    @AfterTemplate\n    boolean after(boolean a, boolean b) {\n        return a != b;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"!(#{a:any(boolean)} == #{b:any(boolean)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{a:any(boolean)} ? !#{b:any(boolean)} : #{b}").build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"!(#{a:any(double)} == #{b:any(double)})").build();
                final JavaTemplate before1 = JavaTemplate.builder((String)"!(#{a:any(java.lang.Object)} == #{b:any(java.lang.Object)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{a:any(boolean)} != #{b:any(boolean)}").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return javaVisitor;
        }
    }

    @NonNullApi
    public static class IndirectDoubleNegationRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Don't negate an inequality test or use the ternary operator to compare two booleans; directly test for equality instead";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"java:S1940\")\nstatic final class IndirectDoubleNegation {\n    \n    @BeforeTemplate\n    boolean before(boolean a, boolean b) {\n        return Refaster.anyOf(!(a != b), a ? b : !b);\n    }\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S1244\")\n    boolean before(double a, double b) {\n        return !(a != b);\n    }\n    \n    @BeforeTemplate\n    boolean before(Object a, Object b) {\n        return !(a != b);\n    }\n    \n    @AfterTemplate\n    boolean after(boolean a, boolean b) {\n        return a == b;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"!(#{a:any(boolean)} != #{b:any(boolean)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{a:any(boolean)} ? #{b:any(boolean)} : !#{b}").build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"!(#{a:any(double)} != #{b:any(double)})").build();
                final JavaTemplate before1 = JavaTemplate.builder((String)"!(#{a:any(java.lang.Object)} != #{b:any(java.lang.Object)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{a:any(boolean)} == #{b:any(boolean)}").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return javaVisitor;
        }
    }
}

