/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class LongStreamRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `LongStream`s";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.LongStreamRules`. [Source](https://error-prone.picnic.tech/refasterrules/LongStreamRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new LongStreamClosedOpenRangeRecipe(), new ConcatOneLongStreamRecipe(), new ConcatTwoLongStreamsRecipe(), new LongStreamFilterSortedRecipe(), new LongStreamIsEmptyRecipe(), new LongStreamIsNotEmptyRecipe(), new LongStreamMinRecipe(), new LongStreamNoneMatchRecipe(), new LongStreamAnyMatchRecipe(), new LongStreamAllMatchRecipe(), new LongStreamTakeWhileRecipe()});
    }

    @NonNullApi
    public static class LongStreamClosedOpenRangeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LongStream#range(long, long)` over the more contrived alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamClosedOpenRange {\n    \n    @BeforeTemplate\n    LongStream before(long from, long to) {\n        return LongStream.rangeClosed(from, to - 1);\n    }\n    \n    @AfterTemplate\n    LongStream after(long from, long to) {\n        return LongStream.range(from, to);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"java.util.stream.LongStream.rangeClosed(#{from:any(long)}, #{to:any(long)} - 1)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.LongStream.range(#{from:any(long)}, #{to:any(long)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream rangeClosed(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ConcatOneLongStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Don't unnecessarily call `Streams#concat(LongStream...)`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ConcatOneLongStream {\n    \n    @BeforeTemplate\n    LongStream before(LongStream stream) {\n        return Streams.concat(stream);\n    }\n    \n    @AfterTemplate\n    @CanIgnoreReturnValue\n    LongStream after(LongStream stream) {\n        return stream;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Streams.concat(#{stream:any(java.util.stream.LongStream)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"guava"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ConcatTwoLongStreamsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LongStream#concat(LongStream, LongStream)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ConcatTwoLongStreams {\n    \n    @BeforeTemplate\n    LongStream before(LongStream s1, LongStream s2) {\n        return Streams.concat(s1, s2);\n    }\n    \n    @AfterTemplate\n    LongStream after(LongStream s1, LongStream s2) {\n        return LongStream.concat(s1, s2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Streams.concat(#{s1:any(java.util.stream.LongStream)}, #{s2:any(java.util.stream.LongStream)})").javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"guava"})).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.LongStream.concat(#{s1:any(java.util.stream.LongStream)}, #{s2:any(java.util.stream.LongStream)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongStreamFilterSortedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Apply `LongStream#filter(LongPredicate)` before `LongStream#sorted()` to reduce the number of elements to sort";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamFilterSorted {\n    \n    @BeforeTemplate\n    LongStream before(LongStream stream, LongPredicate predicate) {\n        return stream.sorted().filter(predicate);\n    }\n    \n    @AfterTemplate\n    LongStream after(LongStream stream, LongPredicate predicate) {\n        return stream.filter(predicate).sorted();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.sorted().filter(#{predicate:any(java.util.function.LongPredicate)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.filter(#{predicate:any(java.util.function.LongPredicate)}).sorted()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream filter(..)"), new UsesMethod("java.util.stream.LongStream sorted(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongStreamIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "In order to test whether a stream has any element, simply try to find one";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamIsEmpty {\n    \n    @BeforeTemplate\n    boolean before(LongStream stream) {\n        return Refaster.anyOf(stream.count() == 0, stream.count() <= 0, stream.count() < 1, stream.findFirst().isEmpty());\n    }\n    \n    @AfterTemplate\n    boolean after(LongStream stream) {\n        return stream.findAny().isEmpty();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.count() == 0").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.count() <= 0").build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.count() < 1").build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.findFirst().isEmpty()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.findAny().isEmpty()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.LongStream count(..)"), new UsesMethod("java.util.stream.LongStream count(..)"), new UsesMethod("java.util.stream.LongStream count(..)"), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalLong isEmpty(..)"), new UsesMethod("java.util.stream.LongStream findFirst(..)")})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongStreamIsNotEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "In order to test whether a stream has any element, simply try to find one";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamIsNotEmpty {\n    \n    @BeforeTemplate\n    boolean before(LongStream stream) {\n        return Refaster.anyOf(stream.count() != 0, stream.count() > 0, stream.count() >= 1, stream.findFirst().isPresent());\n    }\n    \n    @AfterTemplate\n    boolean after(LongStream stream) {\n        return stream.findAny().isPresent();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.count() != 0").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.count() > 0").build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.count() >= 1").build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.findFirst().isPresent()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.findAny().isPresent()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.LongStream count(..)"), new UsesMethod("java.util.stream.LongStream count(..)"), new UsesMethod("java.util.stream.LongStream count(..)"), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalLong isPresent(..)"), new UsesMethod("java.util.stream.LongStream findFirst(..)")})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongStreamMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamMin`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamMin {\n    \n    @BeforeTemplate\n    OptionalLong before(LongStream stream) {\n        return stream.sorted().findFirst();\n    }\n    \n    @AfterTemplate\n    OptionalLong after(LongStream stream) {\n        return stream.min();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.sorted().findFirst()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.min()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalLong", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream findFirst(..)"), new UsesMethod("java.util.stream.LongStream sorted(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongStreamNoneMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LongStream#noneMatch(LongPredicate)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamNoneMatch {\n    \n    @BeforeTemplate\n    boolean before(LongStream stream, LongPredicate predicate) {\n        return Refaster.anyOf(!stream.anyMatch(predicate), stream.allMatch(predicate.negate()), stream.filter(predicate).findAny().isEmpty());\n    }\n    \n    @AfterTemplate\n    boolean after(LongStream stream, LongPredicate predicate) {\n        return stream.noneMatch(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"!#{stream:any(java.util.stream.LongStream)}.anyMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.allMatch(#{predicate:any(java.util.function.LongPredicate)}.negate())").build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.filter(#{predicate:any(java.util.function.LongPredicate)}).findAny().isEmpty()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.LongStream anyMatch(..)"), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.LongStream allMatch(..)"), new UsesMethod("java.util.function.LongPredicate negate(..)")}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalLong isEmpty(..)"), new UsesMethod("java.util.stream.LongStream findAny(..)"), new UsesMethod("java.util.stream.LongStream filter(..)")})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongStreamAnyMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `LongStream#anyMatch(LongPredicate)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamAnyMatch {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S4034\")\n    boolean before(LongStream stream, LongPredicate predicate) {\n        return Refaster.anyOf(!stream.noneMatch(predicate), stream.filter(predicate).findAny().isPresent());\n    }\n    \n    @AfterTemplate\n    boolean after(LongStream stream, LongPredicate predicate) {\n        return stream.anyMatch(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"!#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.filter(#{predicate:any(java.util.function.LongPredicate)}).findAny().isPresent()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.anyMatch(#{predicate:any(java.util.function.LongPredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.LongStream noneMatch(..)"), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalLong isPresent(..)"), new UsesMethod("java.util.stream.LongStream findAny(..)"), new UsesMethod("java.util.stream.LongStream filter(..)")})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongStreamAllMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamAllMatch`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamAllMatch {\n    \n    @BeforeTemplate\n    boolean before(LongStream stream, LongPredicate predicate) {\n        return stream.noneMatch(predicate.negate());\n    }\n    \n    @AfterTemplate\n    boolean after(LongStream stream, LongPredicate predicate) {\n        return stream.allMatch(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)}.negate())").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.allMatch(#{predicate:any(java.util.function.LongPredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream noneMatch(..)"), new UsesMethod("java.util.function.LongPredicate negate(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongStreamTakeWhileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamTakeWhile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamTakeWhile {\n    \n    @BeforeTemplate\n    LongStream before(LongStream stream, LongPredicate predicate) {\n        return stream.takeWhile(predicate).filter(predicate);\n    }\n    \n    @AfterTemplate\n    LongStream after(LongStream stream, LongPredicate predicate) {\n        return stream.takeWhile(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.takeWhile(#{predicate:any(java.util.function.LongPredicate)}).filter(#{predicate})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.takeWhile(#{predicate:any(java.util.function.LongPredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream filter(..)"), new UsesMethod("java.util.stream.LongStream takeWhile(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

