/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.camel.customRecipes;

import io.quarkus.updates.camel.AbstractCamelQuarkusJavaVisitor;
import io.quarkus.updates.camel.RecipesUtil;
import java.beans.ConstructorProperties;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;

public final class MoveGetterToPluginHelper
extends Recipe {
    private static final String MATCHER_GET_NAME_RESOLVER = "org.apache.camel.ExtendedCamelContext getComponentNameResolver()";
    private static final String MATCHER_GET_MODEL_JAXB_CONTEXT_FACTORY = "org.apache.camel.ExtendedCamelContext getModelJAXBContextFactory()";
    private static final String MATCHER_GET_MODEL_TO_XML_DUMPER = "org.apache.camel.ExtendedCamelContext getModelToXMLDumper()";
    private static final Pattern EXTERNAL_CONTEXT_TYPE = Pattern.compile("org.apache.camel.ExtendedCamelContext");
    private static final String MATCHER_CONTEXT_GET_EXT = "org.apache.camel.CamelContext getExtension(java.lang.Class)";
    @Option(displayName="Method name", description="Name of the method on external camel context.")
    private final String oldMethodName;

    public String getDisplayName() {
        return "Move getter from context to PluginHelper.";
    }

    public String getDescription() {
        return "Move getter from context to PluginHelper";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return RecipesUtil.newVisitor(new AbstractCamelQuarkusJavaVisitor(){

            @Override
            protected J.MethodInvocation doVisitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation mi = super.doVisitMethodInvocation(method, context);
                if (this.getMethodMatcher(this.getOldMethodMatcher()).matches(mi, false)) {
                    if (mi.getSelect() instanceof J.MethodInvocation && this.getMethodMatcher(MoveGetterToPluginHelper.MATCHER_CONTEXT_GET_EXT).matches(((J.MethodInvocation)mi.getSelect()).getMethodType())) {
                        J.MethodInvocation innerInvocation = (J.MethodInvocation)mi.getSelect();
                        mi = (J.MethodInvocation)JavaTemplate.builder((String)this.getNewMethodFromContext()).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{innerInvocation.getSelect()});
                        this.doAfterVisit((TreeVisitor)new AddImport("org.apache.camel.support.PluginHelper", null, false));
                    } else if (mi.getSelect().getType().isAssignableFrom(EXTERNAL_CONTEXT_TYPE)) {
                        mi = (J.MethodInvocation)JavaTemplate.builder((String)this.getNewMethodFromExternalContextContext()).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
                        this.doAfterVisit((TreeVisitor)new AddImport("org.apache.camel.support.PluginHelper", null, false));
                    }
                }
                return mi;
            }

            private String getOldMethodMatcher() {
                return "org.apache.camel.ExtendedCamelContext " + MoveGetterToPluginHelper.this.oldMethodName + "()";
            }

            private String getNewMethodFromContext() {
                return "PluginHelper." + MoveGetterToPluginHelper.this.oldMethodName + "(#{any(org.apache.camel.CamelContext)})";
            }

            private String getNewMethodFromExternalContextContext() {
                return "PluginHelper." + MoveGetterToPluginHelper.this.oldMethodName + "(#{any(org.apache.camel.ExtendedCamelContext)})";
            }
        });
    }

    @ConstructorProperties(value={"oldMethodName"})
    @Generated
    public MoveGetterToPluginHelper(String oldMethodName) {
        this.oldMethodName = oldMethodName;
    }

    @Generated
    public String getOldMethodName() {
        return this.oldMethodName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MoveGetterToPluginHelper(oldMethodName=" + this.getOldMethodName() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoveGetterToPluginHelper)) {
            return false;
        }
        MoveGetterToPluginHelper other = (MoveGetterToPluginHelper)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldMethodName = this.getOldMethodName();
        String other$oldMethodName = other.getOldMethodName();
        return !(this$oldMethodName == null ? other$oldMethodName != null : !this$oldMethodName.equals(other$oldMethodName));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MoveGetterToPluginHelper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldMethodName = this.getOldMethodName();
        result = result * 59 + ($oldMethodName == null ? 43 : $oldMethodName.hashCode());
        return result;
    }
}

