/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.updates.camel41;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.camel.updates.AbstractCamelYamlVisitor;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.tree.Yaml;
import org.openrewrite.yaml.tree.YamlKey;

public final class YamlDslRecipe
extends Recipe {
    private static JsonPathMatcher MATCHER_WITHOUT_ROUTE = new JsonPathMatcher("$.beans");

    public String getDisplayName() {
        return "Changes for creation of inlined beans.";
    }

    public String getDescription() {
        return "If inlined bean is created, parameters `type` and `beanType` has bean changed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AbstractCamelYamlVisitor(){

            @Override
            protected void clearLocalCache() {
            }

            @Override
            public Yaml.Mapping.Entry doVisitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry e = super.doVisitMappingEntry(entry, ctx);
                Cursor parent4 = this.getCursor().getParent(4);
                if (parent4 != null && parent4.getParent() != null && MATCHER_WITHOUT_ROUTE.matches(parent4) && this.getCursor().getParent().getValue() instanceof Yaml.Mapping) {
                    Yaml.Mapping m = (Yaml.Mapping)this.getCursor().getParent().getValue();
                    List entries = m.getEntries();
                    Optional<Yaml.Mapping.Entry> typeEntry = entries.stream().filter(me -> "type".equals(me.getKey().getValue())).findAny();
                    Optional<Yaml.Mapping.Entry> beanTypeEntry = entries.stream().filter(me -> "beanType".equals(me.getKey().getValue())).findAny();
                    if (typeEntry.isPresent() && typeEntry.get().getValue() instanceof Yaml.Scalar && !((Yaml.Scalar)typeEntry.get().getValue()).getValue().isEmpty() && beanTypeEntry.isPresent() && beanTypeEntry.get().getValue() instanceof Yaml.Scalar && !((Yaml.Scalar)beanTypeEntry.get().getValue()).getValue().isEmpty()) {
                        if ("type".equals(e.getKey().getValue())) {
                            return e.withKey((YamlKey)((Yaml.Scalar)entry.getKey().copyPaste()).withValue("scriptLanguage"));
                        }
                        if ("beanType".equals(e.getKey().getValue())) {
                            return e.withKey((YamlKey)((Yaml.Scalar)entry.getKey().copyPaste()).withValue("type"));
                        }
                    }
                }
                return e;
            }
        };
    }

    @Generated
    public YamlDslRecipe() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "YamlDslRecipe()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YamlDslRecipe)) {
            return false;
        }
        YamlDslRecipe other = (YamlDslRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof YamlDslRecipe;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

