/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class PrimitiveRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with primitives";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.PrimitiveRules`. [Source](https://error-prone.picnic.tech/refasterrules/PrimitiveRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new LessThanRecipe(), new LessThanOrEqualToRecipe(), new GreaterThanRecipe(), new GreaterThanOrEqualToRecipe(), new LongToIntExactRecipe(), new BooleanHashCodeRecipe(), new ByteHashCodeRecipe(), new CharacterHashCodeRecipe(), new ShortHashCodeRecipe(), new IntegerHashCodeRecipe(), new LongHashCodeRecipe(), new FloatHashCodeRecipe(), new DoubleHashCodeRecipe(), new BooleanCompareRecipe(), new CharacterCompareRecipe(), new ShortCompareRecipe(), new IntegerCompareRecipe(), new LongCompareRecipe(), new FloatCompareRecipe(), new DoubleCompareRecipe(), new CharacterBytesRecipe(), new ShortBytesRecipe(), new IntegerBytesRecipe(), new LongBytesRecipe(), new FloatBytesRecipe(), new DoubleBytesRecipe(), new FloatIsFiniteRecipe(), new DoubleIsFiniteRecipe(), new IntegerSignumIsPositiveRecipe(), new IntegerSignumIsNegativeRecipe(), new LongSignumIsPositiveRecipe(), new LongSignumIsNegativeRecipe()});
    }

    @NonNullApi
    public static class LessThanRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Avoid contrived ways of expressing the \"less than\" relationship";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LessThan {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S1940\")\n    boolean before(double a, double b) {\n        return !(a >= b);\n    }\n    \n    @AfterTemplate\n    boolean after(double a, double b) {\n        return a < b;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"!(#{a:any(double)} >= #{b:any(double)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{a:any(double)} < #{b:any(double)}").build();

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
            return javaVisitor;
        }
    }

    @NonNullApi
    public static class LessThanOrEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Avoid contrived ways of expressing the \"less than or equal to\" relationship";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LessThanOrEqualTo {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S1940\")\n    boolean before(double a, double b) {\n        return !(a > b);\n    }\n    \n    @AfterTemplate\n    boolean after(double a, double b) {\n        return a <= b;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"!(#{a:any(double)} > #{b:any(double)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{a:any(double)} <= #{b:any(double)}").build();

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
            return javaVisitor;
        }
    }

    @NonNullApi
    public static class GreaterThanRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Avoid contrived ways of expressing the \"greater than\" relationship";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class GreaterThan {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S1940\")\n    boolean before(double a, double b) {\n        return !(a <= b);\n    }\n    \n    @AfterTemplate\n    boolean after(double a, double b) {\n        return a > b;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"!(#{a:any(double)} <= #{b:any(double)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{a:any(double)} > #{b:any(double)}").build();

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
            return javaVisitor;
        }
    }

    @NonNullApi
    public static class GreaterThanOrEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Avoid contrived ways of expressing the \"greater than or equal to\" relationship";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class GreaterThanOrEqualTo {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S1940\")\n    boolean before(double a, double b) {\n        return !(a < b);\n    }\n    \n    @AfterTemplate\n    boolean after(double a, double b) {\n        return a >= b;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"!(#{a:any(double)} < #{b:any(double)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{a:any(double)} >= #{b:any(double)}").build();

                public J visitUnary(J.Unary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitUnary(elem, (Object)ctx);
                }
            };
            return javaVisitor;
        }
    }

    @NonNullApi
    public static class LongToIntExactRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Math#toIntExact(long)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongToIntExact {\n    \n    @BeforeTemplate\n    int before(long l) {\n        return Ints.checkedCast(l);\n    }\n    \n    @AfterTemplate\n    int after(long l) {\n        return Math.toIntExact(l);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Ints.checkedCast(#{l:any(long)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Math.toIntExact(#{l:any(long)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Ints");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Ints", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Ints checkedCast(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class BooleanHashCodeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Boolean#hashCode(boolean)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class BooleanHashCode {\n    \n    @BeforeTemplate\n    int before(boolean b) {\n        return Booleans.hashCode(b);\n    }\n    \n    @AfterTemplate\n    int after(boolean b) {\n        return Boolean.hashCode(b);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Booleans.hashCode(#{b:any(boolean)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Boolean.hashCode(#{b:any(boolean)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Booleans");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Booleans", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Booleans hashCode(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ByteHashCodeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Byte#hashCode(byte)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ByteHashCode {\n    \n    @BeforeTemplate\n    int before(byte b) {\n        return Bytes.hashCode(b);\n    }\n    \n    @AfterTemplate\n    int after(byte b) {\n        return Byte.hashCode(b);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Bytes.hashCode(#{b:any(byte)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Byte.hashCode(#{b:any(byte)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Bytes");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Bytes", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Bytes hashCode(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class CharacterHashCodeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Character#hashCode(char)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class CharacterHashCode {\n    \n    @BeforeTemplate\n    int before(char c) {\n        return Chars.hashCode(c);\n    }\n    \n    @AfterTemplate\n    int after(char c) {\n        return Character.hashCode(c);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Chars.hashCode(#{c:any(char)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Character.hashCode(#{c:any(char)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Chars");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Chars", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Chars hashCode(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ShortHashCodeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Short#hashCode(short)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ShortHashCode {\n    \n    @BeforeTemplate\n    int before(short s) {\n        return Shorts.hashCode(s);\n    }\n    \n    @AfterTemplate\n    int after(short s) {\n        return Short.hashCode(s);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Shorts.hashCode(#{s:any(short)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Short.hashCode(#{s:any(short)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Shorts");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Shorts", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Shorts hashCode(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class IntegerHashCodeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Integer#hashCode(int)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerHashCode {\n    \n    @BeforeTemplate\n    int before(int i) {\n        return Ints.hashCode(i);\n    }\n    \n    @AfterTemplate\n    int after(int i) {\n        return Integer.hashCode(i);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Ints.hashCode(#{i:any(int)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Integer.hashCode(#{i:any(int)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Ints");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Ints", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Ints hashCode(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongHashCodeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Long#hashCode(long)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongHashCode {\n    \n    @BeforeTemplate\n    int before(long l) {\n        return Longs.hashCode(l);\n    }\n    \n    @AfterTemplate\n    int after(long l) {\n        return Long.hashCode(l);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Longs.hashCode(#{l:any(long)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Long.hashCode(#{l:any(long)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Longs");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Longs", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Longs hashCode(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class FloatHashCodeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Float#hashCode(float)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FloatHashCode {\n    \n    @BeforeTemplate\n    int before(float f) {\n        return Floats.hashCode(f);\n    }\n    \n    @AfterTemplate\n    int after(float f) {\n        return Float.hashCode(f);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Floats.hashCode(#{f:any(float)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Float.hashCode(#{f:any(float)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Floats");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Floats", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Floats hashCode(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DoubleHashCodeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Double#hashCode(double)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleHashCode {\n    \n    @BeforeTemplate\n    int before(double d) {\n        return Doubles.hashCode(d);\n    }\n    \n    @AfterTemplate\n    int after(double d) {\n        return Double.hashCode(d);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Doubles.hashCode(#{d:any(double)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Double.hashCode(#{d:any(double)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Doubles");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Doubles", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Doubles hashCode(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class BooleanCompareRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Boolean#compare(boolean, boolean)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class BooleanCompare {\n    \n    @BeforeTemplate\n    int before(boolean a, boolean b) {\n        return Booleans.compare(a, b);\n    }\n    \n    @AfterTemplate\n    int after(boolean a, boolean b) {\n        return Boolean.compare(a, b);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Booleans.compare(#{a:any(boolean)}, #{b:any(boolean)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Boolean.compare(#{a:any(boolean)}, #{b:any(boolean)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Booleans");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Booleans", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Booleans compare(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class CharacterCompareRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Character#compare(char, char)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class CharacterCompare {\n    \n    @BeforeTemplate\n    int before(char a, char b) {\n        return Chars.compare(a, b);\n    }\n    \n    @AfterTemplate\n    int after(char a, char b) {\n        return Character.compare(a, b);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Chars.compare(#{a:any(char)}, #{b:any(char)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Character.compare(#{a:any(char)}, #{b:any(char)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Chars");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Chars", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Chars compare(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ShortCompareRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Short#compare(short, short)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ShortCompare {\n    \n    @BeforeTemplate\n    int before(short a, short b) {\n        return Shorts.compare(a, b);\n    }\n    \n    @AfterTemplate\n    int after(short a, short b) {\n        return Short.compare(a, b);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Shorts.compare(#{a:any(short)}, #{b:any(short)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Short.compare(#{a:any(short)}, #{b:any(short)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Shorts");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Shorts", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Shorts compare(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class IntegerCompareRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Integer#compare(int, int)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerCompare {\n    \n    @BeforeTemplate\n    int before(int a, int b) {\n        return Ints.compare(a, b);\n    }\n    \n    @AfterTemplate\n    int after(int a, int b) {\n        return Integer.compare(a, b);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Ints.compare(#{a:any(int)}, #{b:any(int)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Integer.compare(#{a:any(int)}, #{b:any(int)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Ints");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Ints", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Ints compare(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongCompareRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Long#compare(long, long)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongCompare {\n    \n    @BeforeTemplate\n    int before(long a, long b) {\n        return Longs.compare(a, b);\n    }\n    \n    @AfterTemplate\n    int after(long a, long b) {\n        return Long.compare(a, b);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Longs.compare(#{a:any(long)}, #{b:any(long)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Long.compare(#{a:any(long)}, #{b:any(long)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Longs");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Longs", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Longs compare(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class FloatCompareRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Float#compare(float, float)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FloatCompare {\n    \n    @BeforeTemplate\n    int before(float a, float b) {\n        return Floats.compare(a, b);\n    }\n    \n    @AfterTemplate\n    int after(float a, float b) {\n        return Float.compare(a, b);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Floats.compare(#{a:any(float)}, #{b:any(float)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Float.compare(#{a:any(float)}, #{b:any(float)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Floats");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Floats", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Floats compare(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DoubleCompareRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Double#compare(double, double)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleCompare {\n    \n    @BeforeTemplate\n    int before(double a, double b) {\n        return Doubles.compare(a, b);\n    }\n    \n    @AfterTemplate\n    int after(double a, double b) {\n        return Double.compare(a, b);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Doubles.compare(#{a:any(double)}, #{b:any(double)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Double.compare(#{a:any(double)}, #{b:any(double)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Doubles");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Doubles", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Doubles compare(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class CharacterBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Character#BYTES` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class CharacterBytes {\n    \n    @BeforeTemplate\n    int before() {\n        return Chars.BYTES;\n    }\n    \n    @AfterTemplate\n    int after() {\n        return Character.BYTES;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Chars.BYTES").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Character.BYTES").build();

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Chars");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Chars");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("com.google.common.primitives.Chars", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ShortBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Short#BYTES` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ShortBytes {\n    \n    @BeforeTemplate\n    int before() {\n        return Shorts.BYTES;\n    }\n    \n    @AfterTemplate\n    int after() {\n        return Short.BYTES;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Shorts.BYTES").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Short.BYTES").build();

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Shorts");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Shorts");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("com.google.common.primitives.Shorts", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class IntegerBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Integer#BYTES` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerBytes {\n    \n    @BeforeTemplate\n    int before() {\n        return Ints.BYTES;\n    }\n    \n    @AfterTemplate\n    int after() {\n        return Integer.BYTES;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Ints.BYTES").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Integer.BYTES").build();

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Ints");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Ints");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("com.google.common.primitives.Ints", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Long#BYTES` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongBytes {\n    \n    @BeforeTemplate\n    int before() {\n        return Longs.BYTES;\n    }\n    \n    @AfterTemplate\n    int after() {\n        return Long.BYTES;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Longs.BYTES").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Long.BYTES").build();

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Longs");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Longs");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("com.google.common.primitives.Longs", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class FloatBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Float#BYTES` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FloatBytes {\n    \n    @BeforeTemplate\n    int before() {\n        return Floats.BYTES;\n    }\n    \n    @AfterTemplate\n    int after() {\n        return Float.BYTES;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Floats.BYTES").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Float.BYTES").build();

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Floats");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Floats");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("com.google.common.primitives.Floats", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DoubleBytesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Double#BYTES` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleBytes {\n    \n    @BeforeTemplate\n    int before() {\n        return Doubles.BYTES;\n    }\n    \n    @AfterTemplate\n    int after() {\n        return Double.BYTES;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Doubles.BYTES").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Double.BYTES").build();

                public J visitFieldAccess(J.FieldAccess elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Doubles");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitFieldAccess(elem, (Object)ctx);
                }

                public J visitIdentifier(J.Identifier elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Doubles");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitIdentifier(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("com.google.common.primitives.Doubles", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class FloatIsFiniteRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Float#isFinite(float)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FloatIsFinite {\n    \n    @BeforeTemplate\n    boolean before(float f) {\n        return Floats.isFinite(f);\n    }\n    \n    @AfterTemplate\n    boolean after(float f) {\n        return Float.isFinite(f);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Floats.isFinite(#{f:any(float)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Float.isFinite(#{f:any(float)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Floats");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Floats", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Floats isFinite(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class DoubleIsFiniteRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Double#isFinite(double)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class DoubleIsFinite {\n    \n    @BeforeTemplate\n    boolean before(double d) {\n        return Doubles.isFinite(d);\n    }\n    \n    @AfterTemplate\n    boolean after(double d) {\n        return Double.isFinite(d);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.primitives.Doubles.isFinite(#{d:any(double)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"Double.isFinite(#{d:any(double)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.primitives.Doubles");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.primitives.Doubles", Boolean.valueOf(true)), new UsesMethod("com.google.common.primitives.Doubles isFinite(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class IntegerSignumIsPositiveRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer an `Integer#signum(int)` comparison to 1 over less clear alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerSignumIsPositive {\n    \n    @BeforeTemplate\n    boolean before(int i) {\n        return Refaster.anyOf(Integer.signum(i) > 0, Integer.signum(i) >= 1);\n    }\n    \n    @AfterTemplate\n    @AlsoNegation\n    boolean after(int i) {\n        return Integer.signum(i) == 1;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) > 0").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) >= 1").build();
                final JavaTemplate after = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) == 1").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.Integer signum(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class IntegerSignumIsNegativeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer an `Integer#signum(int)` comparison to -1 over less clear alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntegerSignumIsNegative {\n    \n    @BeforeTemplate\n    boolean before(int i) {\n        return Refaster.anyOf(Integer.signum(i) < 0, Integer.signum(i) <= -1);\n    }\n    \n    @AfterTemplate\n    @AlsoNegation\n    boolean after(int i) {\n        return Integer.signum(i) == -1;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) < 0").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) <= -1").build();
                final JavaTemplate after = JavaTemplate.builder((String)"Integer.signum(#{i:any(int)}) == -1").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.Integer signum(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongSignumIsPositiveRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer an `Long#signum(long)` comparison to 1 over less clear alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongSignumIsPositive {\n    \n    @BeforeTemplate\n    boolean before(long l) {\n        return Refaster.anyOf(Long.signum(l) > 0, Long.signum(l) >= 1);\n    }\n    \n    @AfterTemplate\n    @AlsoNegation\n    boolean after(long l) {\n        return Long.signum(l) == 1;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) > 0").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) >= 1").build();
                final JavaTemplate after = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) == 1").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.Long signum(..)"), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class LongSignumIsNegativeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer an `Long#signum(long)` comparison to -1 over less clear alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongSignumIsNegative {\n    \n    @BeforeTemplate\n    boolean before(long l) {\n        return Refaster.anyOf(Long.signum(l) < 0, Long.signum(l) <= -1);\n    }\n    \n    @AfterTemplate\n    @AlsoNegation\n    boolean after(long l) {\n        return Long.signum(l) == -1;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) < 0").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) <= -1").build();
                final JavaTemplate after = JavaTemplate.builder((String)"Long.signum(#{l:any(long)}) == -1").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.Long signum(..)"), (TreeVisitor)javaVisitor);
        }
    }
}

