/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.updates.camel43;

import java.util.Collections;
import lombok.Generated;
import org.apache.camel.updates.AbstractCamelJavaVisitor;
import org.apache.camel.updates.RecipesUtil;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;

public final class CamelThrottleEIPRecipe
extends Recipe {
    private static final String M_THROTTLE_PRIMITIVE = "org.apache.camel.model.ProcessorDefinition throttle(long)";
    private static final String M_THROTTLE_TIME_PERIOD_MILLIS_PRIMITIVE = "org.apache.camel.model.ThrottleDefinition timePeriodMillis(long)";
    private static String WARNING_COMMENT = " Throttle now uses the number of concurrent requests as the throttling measure instead of the number of requests per period.";

    public String getDisplayName() {
        return "Camel Core changes";
    }

    public String getDescription() {
        return "Apache Camel Core migration from version 4.0 to 4.1.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return RecipesUtil.newVisitor(new AbstractCamelJavaVisitor(){

            @Override
            protected J.MethodInvocation doVisitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation mi = super.doVisitMethodInvocation(method, context);
                if (this.getMethodMatcher(CamelThrottleEIPRecipe.M_THROTTLE_PRIMITIVE).matches(mi, false) && !RecipesUtil.isCommentBeforeElement((J)mi, WARNING_COMMENT)) {
                    mi = (J.MethodInvocation)mi.withComments(Collections.singletonList(RecipesUtil.createMultinlineComment(WARNING_COMMENT)));
                    this.getCursor().putMessage("throttle-migrated", (Object)true);
                } else if (this.getMethodMatcher(CamelThrottleEIPRecipe.M_THROTTLE_TIME_PERIOD_MILLIS_PRIMITIVE).matches(mi, false)) {
                    if (mi.getSelect() instanceof J.MethodInvocation) {
                        return (J.MethodInvocation)mi.getSelect();
                    }
                    return null;
                }
                return mi;
            }
        });
    }

    @Generated
    public CamelThrottleEIPRecipe() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "CamelThrottleEIPRecipe()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelThrottleEIPRecipe)) {
            return false;
        }
        CamelThrottleEIPRecipe other = (CamelThrottleEIPRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CamelThrottleEIPRecipe;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

