/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.regex.Matcher;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.VersionComparator;

public class LatestRelease
implements VersionComparator {
    @Nullable
    private final String metadataPattern;

    public LatestRelease(@Nullable String metadataPattern) {
        this.metadataPattern = metadataPattern;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        Matcher matcher = VersionComparator.RELEASE_PATTERN.matcher(version);
        if (!matcher.matches() || PRE_RELEASE_ENDING.matcher(version).find()) {
            return false;
        }
        boolean requireMeta = !StringUtils.isNullOrEmpty(this.metadataPattern);
        String versionMeta = matcher.group(6);
        if (requireMeta) {
            return versionMeta != null && versionMeta.matches(this.metadataPattern);
        }
        if (versionMeta == null) {
            return true;
        }
        String lowercaseVersionMeta = versionMeta.toLowerCase();
        for (String suffix : RELEASE_SUFFIXES) {
            if (!suffix.equals(lowercaseVersionMeta)) continue;
            return true;
        }
        return false;
    }

    static String normalizeVersion(String version) {
        int versionParts;
        int lastDotIdx = version.lastIndexOf(46);
        for (String suffix : RELEASE_SUFFIXES) {
            if (!version.regionMatches(true, lastDotIdx, suffix, 0, suffix.length())) continue;
            version = version.substring(0, lastDotIdx);
            break;
        }
        if ((versionParts = LatestRelease.countVersionParts(version)) <= 2) {
            String[] versionAndMetadata = version.split("(?=[-+])");
            while (versionParts <= 2) {
                versionAndMetadata[0] = versionAndMetadata[0] + ".0";
                ++versionParts;
            }
            version = versionAndMetadata.length > 1 ? versionAndMetadata[0] + versionAndMetadata[1] : versionAndMetadata[0];
        }
        return version;
    }

    static int countVersionParts(String version) {
        int count = 0;
        int len = version.length();
        int lastSepIdx = -1;
        for (int i = 0; i < len; ++i) {
            char c = version.charAt(i);
            if (c == '.' || c == '-' || c == '$') {
                if (lastSepIdx == i - 1) {
                    return count;
                }
                lastSepIdx = i;
                continue;
            }
            if (lastSepIdx != i - 1) continue;
            if (!Character.isDigit(c)) break;
            ++count;
        }
        return count;
    }

    @Override
    public int compare(@Nullable String currentVersion, String v1, String v2) {
        int i;
        int vp2;
        if (v1.equalsIgnoreCase(v2)) {
            return 0;
        }
        if (v1.equalsIgnoreCase("RELEASE")) {
            return v2.equalsIgnoreCase("LATEST") ? -1 : 1;
        }
        if (v1.equalsIgnoreCase("LATEST")) {
            return 1;
        }
        String nv1 = LatestRelease.normalizeVersion(v1);
        String nv2 = LatestRelease.normalizeVersion(v2);
        int vp1 = LatestRelease.countVersionParts(nv1);
        if (vp1 > (vp2 = LatestRelease.countVersionParts(nv2))) {
            StringBuilder nv2Builder = new StringBuilder(nv2);
            for (i = vp2; i < vp1; ++i) {
                nv2Builder.append(".0");
            }
            nv2 = nv2Builder.toString();
        } else if (vp2 > vp1) {
            StringBuilder nv1Builder = new StringBuilder(nv1);
            for (i = vp1; i < vp2; ++i) {
                nv1Builder.append(".0");
            }
            nv1 = nv1Builder.toString();
        }
        Matcher v1Gav = VersionComparator.RELEASE_PATTERN.matcher(nv1);
        Matcher v2Gav = VersionComparator.RELEASE_PATTERN.matcher(nv2);
        v1Gav.matches();
        v2Gav.matches();
        String normalized1 = this.metadataPattern == null ? nv1 : nv1.replace(this.metadataPattern, "");
        String normalized2 = this.metadataPattern == null ? nv2 : nv1.replace(this.metadataPattern, "");
        try {
            for (int i2 = 1; i2 <= Math.max(vp1, vp2); ++i2) {
                String v1Part = v1Gav.group(i2);
                String v2Part = v2Gav.group(i2);
                if (v1Part == null) {
                    return v2Part == null ? normalized1.compareTo(normalized2) : -1;
                }
                if (v2Part == null) {
                    return 1;
                }
                long diff = Long.parseLong(v1Part) - Long.parseLong(v2Part);
                if (diff == 0L) continue;
                return (int)(diff / Math.abs(diff));
            }
        }
        catch (IllegalStateException exception) {
            throw new IllegalStateException("Illegal state while comparing versions : [" + nv1 + "] and [" + nv2 + "]. Metadata = [" + this.metadataPattern + "]", exception);
        }
        return normalized1.compareTo(normalized2);
    }

    public static Validated<LatestRelease> buildLatestRelease(String toVersion, @Nullable String metadataPattern) {
        return "latest.release".equalsIgnoreCase(toVersion) ? Validated.valid("latestRelease", new LatestRelease(metadataPattern)) : Validated.invalid("latestRelease", toVersion, "not latest release");
    }
}

