/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.LatestRelease;

public class SetRange
extends LatestRelease {
    private static final Pattern SET_RANGE_PATTERN = Pattern.compile("([\\[(])(\\d+(\\.\\d+)?(\\.\\d+)?(\\.\\d+)?)?\\s*,\\s*(\\d+(\\.\\d+)?(\\.\\d+)?(\\.\\d+)?)?([\\])])");
    private final String upper;
    private final boolean upperClosed;
    private final String lower;
    private final boolean lowerClosed;

    private SetRange(String lower, boolean lowerClosed, String upper, boolean upperClosed, @Nullable String metadataPattern) {
        super(metadataPattern);
        this.lower = lower;
        this.lowerClosed = lowerClosed;
        this.upper = upper;
        this.upperClosed = upperClosed;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return !(!super.isValid(currentVersion, version) || (!this.upperClosed || this.upper != null && super.compare(currentVersion, version, this.upper) > 0) && this.upper != null && super.compare(currentVersion, version, this.upper) >= 0 || (!this.lowerClosed || this.lower != null && super.compare(currentVersion, version, this.lower) < 0) && this.lower != null && super.compare(currentVersion, version, this.lower) <= 0);
    }

    public static Validated<SetRange> build(String pattern, @Nullable String metadataPattern) {
        Matcher matcher = SET_RANGE_PATTERN.matcher(pattern);
        if (!matcher.matches()) {
            return Validated.invalid("setRange", pattern, "not a set range");
        }
        return Validated.valid("setRange", new SetRange(matcher.group(2), "[".equals(matcher.group(1)), matcher.group(6), "]".equals(matcher.group(10)), metadataPattern));
    }
}

