/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shell.exec;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.scheduling.WorkingDirectoryExecutionContextView;

@Incubating(since="8.30.0")
public interface ShellExecutor {
    default public void init() {
    }

    default public Path exec(List<String> command, Path workingDirectory, Map<String, String> environment, ExecutionContext ctx) {
        return this.exec(command, workingDirectory, environment, Duration.ofMinutes(5L), ctx);
    }

    default public Path exec(List<String> command, Path workingDirectory, Map<String, String> environment, Duration timeout, ExecutionContext ctx) {
        Path stdOut = null;
        Path stdErr = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(command);
            builder.directory(workingDirectory.toFile());
            builder.environment().putAll(environment);
            stdOut = Files.createTempFile(WorkingDirectoryExecutionContextView.view(ctx).getWorkingDirectory(), "shell", null, new FileAttribute[0]);
            stdErr = Files.createTempFile(WorkingDirectoryExecutionContextView.view(ctx).getWorkingDirectory(), "shell", null, new FileAttribute[0]);
            builder.redirectOutput(ProcessBuilder.Redirect.to(stdOut.toFile()));
            builder.redirectError(ProcessBuilder.Redirect.to(stdErr.toFile()));
            Process process = builder.start();
            process.waitFor(timeout.getSeconds(), TimeUnit.SECONDS);
            if (process.exitValue() != 0) {
                String error = "Command failed:" + String.join((CharSequence)" ", command);
                if (Files.exists(stdErr, new LinkOption[0])) {
                    error = error + "\n" + new String(Files.readAllBytes(stdErr));
                }
                throw new RuntimeException(error);
            }
            Path path = stdOut;
            return path;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stdOut != null) {
                stdOut.toFile().delete();
            }
            if (stdErr != null) {
                stdErr.toFile().delete();
            }
        }
    }

    default public void postExec() {
    }
}

