/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class CollidingSourceFiles
extends DataTable<Row> {
    public CollidingSourceFiles(Recipe recipe) {
        super(recipe, "Colliding source files", "Source files that have the same relative path.");
    }

    public static final class Row {
        @Column(displayName="Relative path", description="The relative path of the source file within its repository.")
        private final String relativePath;
        @Column(displayName="Source file type", description="The type of the source file.")
        private final String sourceFileType;

        @Generated
        public Row(String relativePath, String sourceFileType) {
            this.relativePath = relativePath;
            this.sourceFileType = sourceFileType;
        }

        @Generated
        public String getRelativePath() {
            return this.relativePath;
        }

        @Generated
        public String getSourceFileType() {
            return this.sourceFileType;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$relativePath = this.getRelativePath();
            String other$relativePath = other.getRelativePath();
            if (this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath)) {
                return false;
            }
            String this$sourceFileType = this.getSourceFileType();
            String other$sourceFileType = other.getSourceFileType();
            return !(this$sourceFileType == null ? other$sourceFileType != null : !this$sourceFileType.equals(other$sourceFileType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $relativePath = this.getRelativePath();
            result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
            String $sourceFileType = this.getSourceFileType();
            result = result * 59 + ($sourceFileType == null ? 43 : $sourceFileType.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "CollidingSourceFiles.Row(relativePath=" + this.getRelativePath() + ", sourceFileType=" + this.getSourceFileType() + ")";
        }
    }
}

