/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.groovy.format.OmitParenthesesForLastArgumentLambdaVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.groovy.tree.GContainer;
import org.openrewrite.groovy.tree.GLeftPadded;
import org.openrewrite.groovy.tree.GRightPadded;
import org.openrewrite.groovy.tree.GSpace;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class GroovyVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof G.CompilationUnit;
    }

    public String getLanguage() {
        return "groovy";
    }

    public J visitJavaSourceFile(JavaSourceFile cu, P p) {
        return cu instanceof G.CompilationUnit ? this.visitCompilationUnit((G.CompilationUnit)cu, p) : cu;
    }

    public J visitCompilationUnit(G.CompilationUnit cu, P p) {
        G.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withStatements(ListUtils.map(c.getStatements(), e -> (Statement)this.visitAndCast((Tree)e, p)));
        c = c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        throw new UnsupportedOperationException("Groovy has a different structure for its compilation unit. See G.CompilationUnit.");
    }

    public J visitGString(G.GString gString, P p) {
        G.GString g = gString;
        g = g.withPrefix(this.visitSpace(g.getPrefix(), GSpace.Location.GSTRING, p));
        Expression temp = (Expression)this.visitExpression(g = g.withMarkers(this.visitMarkers(g.getMarkers(), p)), p);
        if (!(temp instanceof G.GString)) {
            return temp;
        }
        g = (G.GString)temp;
        g = g.withStrings(ListUtils.map(g.getStrings(), s -> (J)this.visit((Tree)s, p)));
        g = g.withType(this.visitType(gString.getType(), p));
        return g;
    }

    public J visitGStringValue(G.GString.Value value, P p) {
        G.GString.Value v = value;
        v = v.withMarkers(this.visitMarkers(v.getMarkers(), p));
        v = v.withTree((J)this.visit((Tree)v.getTree(), p));
        return v;
    }

    public J visitListLiteral(G.ListLiteral listLiteral, P p) {
        G.ListLiteral l = listLiteral;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), GSpace.Location.LIST_LITERAL, p));
        Expression temp = (Expression)this.visitExpression(l = l.withMarkers(this.visitMarkers(l.getMarkers(), p)), p);
        if (!(temp instanceof G.ListLiteral)) {
            return temp;
        }
        l = (G.ListLiteral)temp;
        l = l.getPadding().withElements(this.visitContainer(l.getPadding().getElements(), GContainer.Location.LIST_LITERAL_ELEMENTS, p));
        l = l.withType(this.visitType(l.getType(), p));
        return l;
    }

    public J visitMapEntry(G.MapEntry mapEntry, P p) {
        G.MapEntry m = mapEntry;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), GSpace.Location.MAP_ENTRY, p));
        Expression temp = (Expression)this.visitExpression(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof G.MapEntry)) {
            return temp;
        }
        m = (G.MapEntry)temp;
        m = m.getPadding().withKey(this.visitRightPadded(m.getPadding().getKey(), GRightPadded.Location.MAP_ENTRY_KEY, p));
        m = m.withValue((Expression)this.visit((Tree)m.getValue(), p));
        m = m.withType(this.visitType(m.getType(), p));
        return m;
    }

    public J visitMapLiteral(G.MapLiteral mapLiteral, P p) {
        G.MapLiteral m = mapLiteral;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), GSpace.Location.MAP_LITERAL, p));
        Expression temp = (Expression)this.visitExpression(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof G.MapLiteral)) {
            return temp;
        }
        m = (G.MapLiteral)temp;
        m = m.getPadding().withElements(this.visitContainer(m.getPadding().getElements(), GContainer.Location.MAP_LITERAL_ELEMENTS, p));
        m = m.withType(this.visitType(m.getType(), p));
        return m;
    }

    public J visitBinary(G.Binary binary, P p) {
        G.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), GSpace.Location.BINARY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof G.Binary)) {
            return temp;
        }
        b = (G.Binary)temp;
        b = b.withLeft((Expression)this.visitAndCast((Tree)b.getLeft(), p));
        b = b.getPadding().withOperator(this.visitLeftPadded(b.getPadding().getOperator(), GLeftPadded.Location.BINARY_OPERATOR, p));
        b = b.withRight((Expression)this.visitAndCast((Tree)b.getRight(), p));
        b = b.withType(this.visitType(b.getType(), p));
        return b;
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, GRightPadded.Location loc, P p) {
        return super.visitRightPadded(right, JRightPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, GLeftPadded.Location loc, P p) {
        return super.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, GSpace.Location loc, P p) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, GContainer.Location loc, P p) {
        return super.visitContainer(container, JContainer.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> J2 autoFormat(J2 j, @Nullable J stopAfter, P p, Cursor cursor) {
        J after = super.autoFormat(j, stopAfter, p, cursor.fork());
        after = (J)new OmitParenthesesForLastArgumentLambdaVisitor((Tree)stopAfter).visitNonNull((Tree)after, p, cursor.fork());
        return (J2)after;
    }
}

