/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.openrewrite.groovy.GroovyAstTypeSignatureBuilder;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTypeMapping;
import org.openrewrite.java.internal.JavaReflectionTypeMapping;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

class GroovyTypeMapping
implements JavaTypeMapping<ASTNode> {
    private final GroovyAstTypeSignatureBuilder signatureBuilder = new GroovyAstTypeSignatureBuilder();
    private final JavaTypeCache typeCache;
    private final JavaReflectionTypeMapping reflectionTypeMapping;

    GroovyTypeMapping(JavaTypeCache typeCache) {
        this.typeCache = typeCache;
        this.reflectionTypeMapping = new JavaReflectionTypeMapping(typeCache);
    }

    public JavaType type(@Nullable ASTNode type) {
        if (type == null) {
            return JavaType.Unknown.getInstance();
        }
        String signature = this.signatureBuilder.signature(type);
        JavaType existing = (JavaType)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        try {
            if (type instanceof ClassNode) {
                ClassNode clazz = (ClassNode)type;
                if (clazz.isArray()) {
                    return this.arrayType(clazz, signature);
                }
                if (ClassHelper.isPrimitiveType((ClassNode)clazz)) {
                    return JavaType.Primitive.fromKeyword((String)clazz.getName());
                }
                if (clazz.isUsingGenerics() && clazz.getGenericsTypes() != null) {
                    return this.parameterizedType(clazz, signature);
                }
                return this.classType((ClassNode)type, signature);
            }
            if (type instanceof GenericsType) {
                return this.genericType((GenericsType)type, signature);
            }
            if (type instanceof MethodNode) {
                return this.methodType((MethodNode)type);
            }
            if (type instanceof FieldNode) {
                return this.variableType((FieldNode)type);
            }
        }
        catch (NoClassDefFoundError e) {
            return JavaType.ShallowClass.build((String)e.getMessage());
        }
        throw new UnsupportedOperationException("Unknown type " + type.getClass().getName());
    }

    private JavaType.Class classType(ClassNode node, String signature) {
        JavaType.Class clazz;
        try {
            JavaType type = this.reflectionTypeMapping.type((Type)node.getTypeClass());
            clazz = (JavaType.Class)(type instanceof JavaType.Parameterized ? ((JavaType.Parameterized)type).getType() : type);
        }
        catch (NoClassDefFoundError | GroovyBugError ignored1) {
            clazz = new JavaType.Class(null, Flag.Public.getBitMask(), node.getName(), JavaType.FullyQualified.Kind.Class, null, null, null, null, null, null, null);
            this.typeCache.put(signature, (Object)clazz);
            JavaType.FullyQualified supertype = TypeUtils.asFullyQualified((JavaType)this.type((ASTNode)node.getSuperClass()));
            JavaType.FullyQualified owner = TypeUtils.asFullyQualified((JavaType)this.type((ASTNode)node.getOuterClass()));
            ArrayList<JavaType.Variable> fields = null;
            if (node.getFields().size() > 0) {
                fields = new ArrayList<JavaType.Variable>(node.getFields().size());
                for (FieldNode field : node.getFields()) {
                    if (field.isSynthetic()) continue;
                    fields.add(this.variableType(field));
                }
            }
            ArrayList<JavaType.Method> methods = null;
            if (node.getAllDeclaredMethods().size() > 0) {
                methods = new ArrayList<JavaType.Method>(node.getAllDeclaredMethods().size());
                for (MethodNode method : node.getAllDeclaredMethods()) {
                    if (method.isSynthetic()) continue;
                    methods.add(this.methodType(method));
                }
            }
            ArrayList<JavaType.FullyQualified> interfaces = null;
            if (node.getInterfaces().length > 0) {
                interfaces = new ArrayList<JavaType.FullyQualified>(node.getInterfaces().length);
                for (MethodNode iParam : node.getInterfaces()) {
                    JavaType.FullyQualified javaType = TypeUtils.asFullyQualified((JavaType)this.type((ASTNode)iParam));
                    if (javaType == null) continue;
                    interfaces.add(javaType);
                }
            }
            List<JavaType.FullyQualified> annotations = this.getAnnotations((AnnotatedNode)node);
            clazz.unsafeSet(null, supertype, owner, annotations, interfaces, fields, methods);
        }
        return clazz;
    }

    private JavaType parameterizedType(ClassNode type, String signature) {
        JavaType.Parameterized pt = new JavaType.Parameterized(null, null, null);
        this.typeCache.put(signature, (Object)pt);
        JavaType.Class clazz = this.classType(type, type.getPlainNodeReference().getName());
        List typeParameters = Collections.emptyList();
        if (type.getGenericsTypes() != null && type.getGenericsTypes().length > 0) {
            typeParameters = new ArrayList(type.getGenericsTypes().length);
            for (GenericsType g : type.getGenericsTypes()) {
                typeParameters.add(this.type((ASTNode)g));
            }
        }
        pt.unsafeSet((JavaType.FullyQualified)clazz, typeParameters);
        return pt;
    }

    private JavaType.Array arrayType(ClassNode array, String signature) {
        JavaType.Array arr = new JavaType.Array(null, null);
        this.typeCache.put(signature, (Object)arr);
        if (array.getComponentType().isUsingGenerics()) {
            arr.unsafeSet(this.type((ASTNode)array.getComponentType().getGenericsTypes()[0]));
        } else {
            arr.unsafeSet(this.type((ASTNode)array.getComponentType()));
        }
        return arr;
    }

    private JavaType genericType(GenericsType g, String signature) {
        JavaType.FullyQualified mappedBound;
        if (!g.isPlaceholder() && !g.isWildcard()) {
            return this.type((ASTNode)g.getType());
        }
        JavaType.GenericTypeVariable.Variance variance = JavaType.GenericTypeVariable.Variance.INVARIANT;
        JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, g.getName(), variance, null);
        this.typeCache.put(signature, (Object)gtv);
        List<JavaType.FullyQualified> bounds = null;
        if (g.getUpperBounds() != null) {
            for (ClassNode bound : g.getUpperBounds()) {
                JavaType.FullyQualified mappedBound2 = TypeUtils.asFullyQualified((JavaType)this.type((ASTNode)bound));
                if (mappedBound2 == null || "java.lang.Object".equals(mappedBound2.getFullyQualifiedName())) continue;
                if (bounds == null) {
                    bounds = new ArrayList<JavaType.FullyQualified>(g.getUpperBounds().length);
                }
                bounds.add(mappedBound2);
                variance = JavaType.GenericTypeVariable.Variance.COVARIANT;
            }
        } else if (g.getLowerBound() != null && (mappedBound = TypeUtils.asFullyQualified((JavaType)this.type((ASTNode)g.getLowerBound()))) != null && !"java.lang.Object".equals(mappedBound.getFullyQualifiedName())) {
            bounds = Collections.singletonList(mappedBound);
            variance = JavaType.GenericTypeVariable.Variance.CONTRAVARIANT;
        }
        gtv.unsafeSet(gtv.getName(), variance, bounds);
        return gtv;
    }

    @Nullable
    public JavaType.Method methodType(@Nullable MethodNode node) {
        if (node == null) {
            return null;
        }
        String signature = this.signatureBuilder.methodSignature(node);
        JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        ArrayList<String> paramNames = null;
        if (node.getParameters().length > 0) {
            paramNames = new ArrayList<String>(node.getParameters().length);
            for (Parameter parameter : node.getParameters()) {
                paramNames.add(parameter.getName());
            }
        }
        JavaType.Method method = new JavaType.Method(null, (long)node.getModifiers(), null, node instanceof ConstructorNode ? "<constructor>" : node.getName(), null, paramNames, null, null, null, null);
        this.typeCache.put(signature, (Object)method);
        ArrayList<JavaType> parameterTypes = null;
        if (node.getParameters().length > 0) {
            parameterTypes = new ArrayList<JavaType>(node.getParameters().length);
            for (Parameter parameter : node.getParameters()) {
                parameterTypes.add(this.type((ASTNode)parameter.getOriginType()));
            }
        }
        ArrayList<JavaType.FullyQualified> thrownExceptions = null;
        if (node.getExceptions() != null) {
            for (ClassNode e : node.getExceptions()) {
                thrownExceptions = new ArrayList<JavaType.FullyQualified>(node.getExceptions().length);
                JavaType.FullyQualified qualified = TypeUtils.asFullyQualified((JavaType)this.type((ASTNode)e));
                thrownExceptions.add(qualified);
            }
        }
        List<JavaType.FullyQualified> annotations = this.getAnnotations((AnnotatedNode)node);
        method.unsafeSet(TypeUtils.asFullyQualified((JavaType)this.type((ASTNode)node.getDeclaringClass())), this.type((ASTNode)node.getReturnType()), parameterTypes, thrownExceptions, annotations);
        return method;
    }

    @Nullable
    public JavaType.Variable variableType(@Nullable FieldNode node) {
        if (node == null) {
            return null;
        }
        String signature = this.signatureBuilder.variableSignature(node);
        JavaType.Variable existing = (JavaType.Variable)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        JavaType.Variable variable = new JavaType.Variable(null, (long)node.getModifiers(), node.getName(), null, null, null);
        this.typeCache.put(signature, (Object)variable);
        List<JavaType.FullyQualified> annotations = this.getAnnotations((AnnotatedNode)node);
        variable.unsafeSet(this.type((ASTNode)node.getOwner()), this.type((ASTNode)node.getType()), annotations);
        return variable;
    }

    @Nullable
    public JavaType.Variable variableType(String name, @Nullable ASTNode type) {
        return this.variableType(name, this.type(type));
    }

    @Nullable
    public JavaType.Variable variableType(String name, @Nullable JavaType type) {
        if (type == null) {
            return null;
        }
        String signature = this.signatureBuilder.variableSignature(name);
        JavaType.Variable existing = (JavaType.Variable)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        JavaType.Variable variable = new JavaType.Variable(null, 0L, name, null, null, null);
        this.typeCache.put(signature, (Object)variable);
        variable.unsafeSet((JavaType)JavaType.Unknown.getInstance(), type, null);
        return variable;
    }

    @Nullable
    private List<JavaType.FullyQualified> getAnnotations(AnnotatedNode node) {
        ArrayList<JavaType.FullyQualified> annotations = null;
        for (AnnotationNode a : node.getAnnotations()) {
            annotations = new ArrayList<JavaType.FullyQualified>(node.getAnnotations().size());
            JavaType.FullyQualified fullyQualified = (JavaType.FullyQualified)this.type((ASTNode)a.getClassNode());
            annotations.add(fullyQualified);
        }
        return annotations;
    }
}

