/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import java.util.concurrent.atomic.AtomicInteger;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class CountLinesVisitor
extends GroovyVisitor<AtomicInteger> {
    @Override
    public J visitJavaSourceFile(JavaSourceFile cu, AtomicInteger count) {
        if (cu instanceof G.CompilationUnit) {
            return super.visitJavaSourceFile(cu, count);
        }
        return cu;
    }

    public G visitCompilationUnit(G.CompilationUnit cu, AtomicInteger count) {
        if (cu.getPackageDeclaration() != null) {
            count.incrementAndGet();
        }
        count.getAndAdd(cu.getImports().size());
        for (J.ClassDeclaration c : cu.getClasses()) {
            this.visit((Tree)c, count);
        }
        return cu;
    }

    public J visitBlock(J.Block block, AtomicInteger count) {
        for (Statement s : block.getStatements()) {
            this.visit((Tree)s, count);
        }
        return block;
    }

    public Space visitSpace(Space space, Space.Location loc, AtomicInteger count) {
        if (space.getWhitespace().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitSpace(space, loc, (Object)count);
    }

    public static int countLines(Tree tree) {
        return ((AtomicInteger)new CountLinesVisitor().reduce(tree, new AtomicInteger())).get();
    }
}

