/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.openrewrite.ParseWarning;
import org.openrewrite.Parser;
import org.openrewrite.groovy.GroovyParser;

public class ParseWarningCollector
extends ErrorCollector {
    private final List<ParseWarning> warningMarkers = new ArrayList<ParseWarning>();
    private final GroovyParser parser;

    public ParseWarningCollector(CompilerConfiguration configuration, GroovyParser parser) {
        super(configuration);
        this.parser = parser;
    }

    public void addErrorAndContinue(Message message) throws CompilationFailedException {
        super.addErrorAndContinue(message);
        if (message instanceof SyntaxErrorMessage) {
            this.warningMarkers.add(ParseWarning.build((Parser)this.parser, (Throwable)((SyntaxErrorMessage)message).getCause()));
        } else if (message instanceof ExceptionMessage) {
            this.warningMarkers.add(ParseWarning.build((Parser)this.parser, (Throwable)((ExceptionMessage)message).getCause()));
        }
    }

    protected void failIfErrors() throws CompilationFailedException {
    }

    public List<ParseWarning> getWarningMarkers() {
        return this.warningMarkers;
    }
}

