/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import lombok.Generated;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.BinaryExpression;

public class FindBinaryOperationVisitor
extends CodeVisitorSupport {
    private final int[] sourceLineNumberOffsets;
    private final int index;
    private final String tokenToFind;
    private boolean found = false;

    public FindBinaryOperationVisitor(String tokenToFind, int index, int[] sourceLineNumberOffsets) {
        this.index = index;
        this.tokenToFind = tokenToFind;
        this.sourceLineNumberOffsets = sourceLineNumberOffsets;
    }

    public void visitBinaryExpression(BinaryExpression be) {
        if (this.toSourceIndex(be.getRightExpression().getLineNumber(), be.getRightExpression().getColumnNumber()) <= this.index) {
            be.getRightExpression().visit((GroovyCodeVisitor)this);
        } else if (this.toSourceIndex(be.getLeftExpression().getLastLineNumber(), be.getLeftExpression().getLastColumnNumber()) > this.index) {
            be.getLeftExpression().visit((GroovyCodeVisitor)this);
        } else if (this.tokenToFind.equals(be.getOperation().getText())) {
            this.found = true;
        }
    }

    private int toSourceIndex(int lineNumber, int columnNumber) {
        return this.sourceLineNumberOffsets[lineNumber - 1] + columnNumber - 1;
    }

    @Generated
    public boolean isFound() {
        return this.found;
    }
}

