/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy.tree;

import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyPrinter;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.internal.GroovyWhitespaceValidationService;
import org.openrewrite.groovy.service.GroovyAutoFormatService;
import org.openrewrite.internal.WhitespaceValidationService;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.service.AutoFormatService;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.CoordinateBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

public interface G
extends J {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptGroovy((GroovyVisitor)v.adapt(GroovyVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(GroovyVisitor.class);
    }

    default public <P> @Nullable J acceptGroovy(GroovyVisitor<P> v, P p) {
        return (J)v.defaultValue((Tree)this, p);
    }

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    public static final class Unary
    implements G,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Type> operator;
        private final Expression expression;
        private final @Nullable JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public Unary withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitUnary(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unary)) {
                return false;
            }
            Unary other = (Unary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Unary(UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type;
        }

        @Generated
        private Unary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expression, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public String toString() {
            return "G.Unary(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", operator=" + (Object)((Object)this.getOperator()) + ", expression=" + this.getExpression() + ", type=" + this.getType() + ")";
        }

        @NonNull
        @Generated
        public Unary withId(UUID id) {
            return this.id == id ? this : new Unary(this.padding, id, this.prefix, this.markers, this.operator, this.expression, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Unary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Unary(this.padding, this.id, prefix, this.markers, this.operator, this.expression, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Unary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Unary(this.padding, this.id, this.prefix, markers, this.operator, this.expression, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Unary withExpression(Expression expression) {
            return this.expression == expression ? this : new Unary(this.padding, this.id, this.prefix, this.markers, this.operator, expression, this.type);
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        @Generated
        public Unary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Unary(this.padding, this.id, this.prefix, this.markers, this.operator, this.expression, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static enum Type {
            Spread;

        }

        public static class Padding {
            private final Unary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Unary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Unary(this.t.id, this.t.prefix, this.t.markers, operator, this.t.expression, this.t.type);
            }

            @Generated
            public Padding(Unary t) {
                this.t = t;
            }
        }
    }

    public static final class Range
    implements G,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression from;
        private final JLeftPadded<Boolean> inclusive;
        private final Expression to;

        public boolean getInclusive() {
            return (Boolean)this.inclusive.getElement();
        }

        public Range withInclusive(boolean inclusive) {
            return this.getPadding().withInclusive((JLeftPadded<Boolean>)this.inclusive.withElement((Object)inclusive));
        }

        public JavaType getType() {
            return this.from.getType();
        }

        public Range withType(@Nullable JavaType type) {
            boolean fromIsMethod = this.from instanceof J.MethodInvocation;
            boolean toIsMethod = this.to instanceof J.MethodInvocation;
            if (fromIsMethod || toIsMethod) {
                if (!(type instanceof JavaType.Method)) {
                    return this;
                }
                JavaType.Method m = (JavaType.Method)type;
                Range r = this;
                if (fromIsMethod) {
                    r = r.withFrom((Expression)((J.MethodInvocation)r.getFrom()).withMethodType(m));
                }
                if (toIsMethod) {
                    r = r.withTo((Expression)((J.MethodInvocation)r.getTo()).withMethodType(m));
                }
                return r;
            }
            return this.withFrom((Expression)this.from.withType(type)).withTo((Expression)this.to.withType(type));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitRange(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Range(UUID id, Space prefix, Markers markers, Expression from, JLeftPadded<Boolean> inclusive, Expression to) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.inclusive = inclusive;
            this.to = to;
        }

        @Generated
        private Range(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression from, JLeftPadded<Boolean> inclusive, Expression to) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.inclusive = inclusive;
            this.to = to;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getFrom() {
            return this.from;
        }

        @Generated
        public Expression getTo() {
            return this.to;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public String toString() {
            return "G.Range(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", from=" + this.getFrom() + ", inclusive=" + this.getInclusive() + ", to=" + this.getTo() + ")";
        }

        @NonNull
        @Generated
        public Range withId(UUID id) {
            return this.id == id ? this : new Range(this.padding, id, this.prefix, this.markers, this.from, this.inclusive, this.to);
        }

        @NonNull
        @Generated
        public Range withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Range(this.padding, this.id, prefix, this.markers, this.from, this.inclusive, this.to);
        }

        @NonNull
        @Generated
        public Range withMarkers(Markers markers) {
            return this.markers == markers ? this : new Range(this.padding, this.id, this.prefix, markers, this.from, this.inclusive, this.to);
        }

        @NonNull
        @Generated
        public Range withFrom(Expression from) {
            return this.from == from ? this : new Range(this.padding, this.id, this.prefix, this.markers, from, this.inclusive, this.to);
        }

        @NonNull
        @Generated
        public Range withTo(Expression to) {
            return this.to == to ? this : new Range(this.padding, this.id, this.prefix, this.markers, this.from, this.inclusive, to);
        }

        public static class Padding {
            private final Range t;

            public JLeftPadded<Boolean> getInclusive() {
                return this.t.inclusive;
            }

            public Range withInclusive(JLeftPadded<Boolean> inclusive) {
                return this.t.inclusive == inclusive ? this.t : new Range(this.t.id, this.t.prefix, this.t.markers, this.t.from, inclusive, this.t.to);
            }

            @Generated
            public Padding(Range t) {
                this.t = t;
            }
        }
    }

    public static final class Binary
    implements G,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        private final Space after;
        private final @Nullable JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public Binary withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitBinary(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Binary(UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, Space after, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.after = after;
            this.type = type;
        }

        @Generated
        private Binary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, Space after, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.after = after;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getLeft() {
            return this.left;
        }

        @Generated
        public Expression getRight() {
            return this.right;
        }

        @Generated
        public Space getAfter() {
            return this.after;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public String toString() {
            return "G.Binary(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", left=" + this.getLeft() + ", operator=" + (Object)((Object)this.getOperator()) + ", right=" + this.getRight() + ", after=" + this.getAfter() + ", type=" + this.getType() + ")";
        }

        @NonNull
        @Generated
        public Binary withId(UUID id) {
            return this.id == id ? this : new Binary(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.right, this.after, this.type);
        }

        @NonNull
        @Generated
        public Binary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Binary(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right, this.after, this.type);
        }

        @NonNull
        @Generated
        public Binary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Binary(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right, this.after, this.type);
        }

        @NonNull
        @Generated
        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right, this.after, this.type);
        }

        @NonNull
        @Generated
        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right, this.after, this.type);
        }

        @NonNull
        @Generated
        public Binary withAfter(Space after) {
            return this.after == after ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, after, this.type);
        }

        @NonNull
        @Generated
        public Binary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, this.after, type);
        }

        public static enum Type {
            Find,
            Match,
            In,
            NotIn,
            Access,
            Spaceship;

        }

        public static class Padding {
            private final Binary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Binary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Binary(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right, this.t.after, this.t.type);
            }

            @Generated
            public Padding(Binary t) {
                this.t = t;
            }
        }
    }

    public static final class GString
    implements G,
    Statement,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String delimiter;
        private final List<J> strings;
        private final @Nullable JavaType type;

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitGString(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof GString;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public GString(UUID id, Space prefix, Markers markers, String delimiter, List<J> strings, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.delimiter = delimiter;
            this.strings = strings;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getDelimiter() {
            return this.delimiter;
        }

        @Generated
        public List<J> getStrings() {
            return this.strings;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public String toString() {
            return "G.GString(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", delimiter=" + this.getDelimiter() + ", strings=" + this.getStrings() + ", type=" + this.getType() + ")";
        }

        @NonNull
        @Generated
        public GString withId(UUID id) {
            return this.id == id ? this : new GString(id, this.prefix, this.markers, this.delimiter, this.strings, this.type);
        }

        @NonNull
        @Generated
        public GString withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new GString(this.id, prefix, this.markers, this.delimiter, this.strings, this.type);
        }

        @NonNull
        @Generated
        public GString withMarkers(Markers markers) {
            return this.markers == markers ? this : new GString(this.id, this.prefix, markers, this.delimiter, this.strings, this.type);
        }

        @NonNull
        @Generated
        public GString withDelimiter(String delimiter) {
            return this.delimiter == delimiter ? this : new GString(this.id, this.prefix, this.markers, delimiter, this.strings, this.type);
        }

        @NonNull
        @Generated
        public GString withStrings(List<J> strings) {
            return this.strings == strings ? this : new GString(this.id, this.prefix, this.markers, this.delimiter, strings, this.type);
        }

        @NonNull
        @Generated
        public GString withType(@Nullable JavaType type) {
            return this.type == type ? this : new GString(this.id, this.prefix, this.markers, this.delimiter, this.strings, type);
        }

        public static final class Value
        implements G {
            private final UUID id;
            private final Markers markers;
            private final J tree;
            private final Space after;
            private final boolean enclosedInBraces;

            public <J2 extends J> J2 withPrefix(Space space) {
                return (J2)this;
            }

            @Override
            public Space getPrefix() {
                return Space.EMPTY;
            }

            public Space getAfter() {
                return this.after == null ? Space.EMPTY : this.after;
            }

            @Override
            public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
                return v.visitGStringValue(this, p);
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof Value;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }

            @Generated
            public Value(UUID id, Markers markers, J tree, Space after, boolean enclosedInBraces) {
                this.id = id;
                this.markers = markers;
                this.tree = tree;
                this.after = after;
                this.enclosedInBraces = enclosedInBraces;
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public J getTree() {
                return this.tree;
            }

            @Generated
            public boolean isEnclosedInBraces() {
                return this.enclosedInBraces;
            }

            @NonNull
            @Generated
            public String toString() {
                return "G.GString.Value(id=" + this.getId() + ", markers=" + this.getMarkers() + ", tree=" + this.getTree() + ", after=" + this.getAfter() + ", enclosedInBraces=" + this.isEnclosedInBraces() + ")";
            }

            @NonNull
            @Generated
            public Value withId(UUID id) {
                return this.id == id ? this : new Value(id, this.markers, this.tree, this.after, this.enclosedInBraces);
            }

            @NonNull
            @Generated
            public Value withMarkers(Markers markers) {
                return this.markers == markers ? this : new Value(this.id, markers, this.tree, this.after, this.enclosedInBraces);
            }

            @NonNull
            @Generated
            public Value withTree(J tree) {
                return this.tree == tree ? this : new Value(this.id, this.markers, tree, this.after, this.enclosedInBraces);
            }

            @NonNull
            @Generated
            public Value withAfter(Space after) {
                return this.after == after ? this : new Value(this.id, this.markers, this.tree, after, this.enclosedInBraces);
            }

            @NonNull
            @Generated
            public Value withEnclosedInBraces(boolean enclosedInBraces) {
                return this.enclosedInBraces == enclosedInBraces ? this : new Value(this.id, this.markers, this.tree, this.after, enclosedInBraces);
            }
        }
    }

    public static final class ListLiteral
    implements G,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<Expression> elements;
        private final @Nullable JavaType type;

        public List<Expression> getElements() {
            return this.elements.getElements();
        }

        public ListLiteral withElements(List<Expression> elements) {
            return this.getPadding().withElements((JContainer<Expression>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitListLiteral(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListLiteral)) {
                return false;
            }
            ListLiteral other = (ListLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ListLiteral(UUID id, Space prefix, Markers markers, JContainer<Expression> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        private ListLiteral(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<Expression> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ListLiteral withId(UUID id) {
            return this.id == id ? this : new ListLiteral(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ListLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ListLiteral(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ListLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new ListLiteral(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public ListLiteral withType(@Nullable JavaType type) {
            return this.type == type ? this : new ListLiteral(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        public static class Padding {
            private final ListLiteral t;

            public JContainer<Expression> getElements() {
                return this.t.elements;
            }

            public ListLiteral withElements(JContainer<Expression> elements) {
                return this.t.elements == elements ? this.t : new ListLiteral(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            @Generated
            public Padding(ListLiteral t) {
                this.t = t;
            }
        }
    }

    public static final class MapLiteral
    implements G,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<MapEntry> elements;
        private final @Nullable JavaType type;

        public List<MapEntry> getElements() {
            return this.elements.getElements();
        }

        public MapLiteral withElements(List<MapEntry> elements) {
            return this.getPadding().withElements((JContainer<MapEntry>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitMapLiteral(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapLiteral)) {
                return false;
            }
            MapLiteral other = (MapLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public MapLiteral(UUID id, Space prefix, Markers markers, JContainer<MapEntry> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        private MapLiteral(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<MapEntry> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public MapLiteral withId(UUID id) {
            return this.id == id ? this : new MapLiteral(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public MapLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MapLiteral(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public MapLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new MapLiteral(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public MapLiteral withType(@Nullable JavaType type) {
            return this.type == type ? this : new MapLiteral(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        public static class Padding {
            private final MapLiteral t;

            public JContainer<MapEntry> getElements() {
                return this.t.elements;
            }

            public MapLiteral withElements(JContainer<MapEntry> elements) {
                return this.t.elements == elements ? this.t : new MapLiteral(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            @Generated
            public Padding(MapLiteral t) {
                this.t = t;
            }
        }
    }

    public static final class MapEntry
    implements G,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> key;
        private final Expression value;
        private final @Nullable JavaType type;

        public Expression getKey() {
            return (Expression)this.key.getElement();
        }

        public MapEntry withKey(Expression key) {
            return this.getPadding().withKey((JRightPadded<Expression>)JRightPadded.withElement(this.key, (Object)key));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitMapEntry(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapEntry)) {
                return false;
            }
            MapEntry other = (MapEntry)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public MapEntry(UUID id, Space prefix, Markers markers, JRightPadded<Expression> key, Expression value, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
            this.type = type;
        }

        @Generated
        private MapEntry(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> key, Expression value, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public MapEntry withId(UUID id) {
            return this.id == id ? this : new MapEntry(this.padding, id, this.prefix, this.markers, this.key, this.value, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public MapEntry withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MapEntry(this.padding, this.id, prefix, this.markers, this.key, this.value, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public MapEntry withMarkers(Markers markers) {
            return this.markers == markers ? this : new MapEntry(this.padding, this.id, this.prefix, markers, this.key, this.value, this.type);
        }

        @Generated
        public Expression getValue() {
            return this.value;
        }

        @NonNull
        @Generated
        public MapEntry withValue(Expression value) {
            return this.value == value ? this : new MapEntry(this.padding, this.id, this.prefix, this.markers, this.key, value, this.type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public MapEntry withType(@Nullable JavaType type) {
            return this.type == type ? this : new MapEntry(this.padding, this.id, this.prefix, this.markers, this.key, this.value, type);
        }

        public static class Padding {
            private final MapEntry t;

            public @Nullable JRightPadded<Expression> getKey() {
                return this.t.key;
            }

            public MapEntry withKey(JRightPadded<Expression> key) {
                return this.t.key == key ? this.t : new MapEntry(this.t.id, this.t.prefix, this.t.markers, key, this.t.value, this.t.type);
            }

            @Generated
            public Padding(MapEntry t) {
                this.t = t;
            }
        }
    }

    public static final class ExpressionStatement
    implements G,
    Expression,
    Statement {
        private final UUID id;
        private final Expression expression;

        public ExpressionStatement(Expression expression) {
            this.id = Tree.randomId();
            this.expression = expression;
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            J j = (J)v.visit((Tree)this.getExpression(), p);
            if (j instanceof ExpressionStatement) {
                return j;
            }
            if (j instanceof Expression) {
                return this.withExpression((Expression)j);
            }
            return j;
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withExpression((Expression)this.expression.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.expression.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withExpression((Expression)this.expression.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.expression.getMarkers();
        }

        public @Nullable JavaType getType() {
            return this.expression.getType();
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            if (this.expression instanceof J.MethodInvocation) {
                if (!(type instanceof JavaType.Method)) {
                    return (T)this;
                }
                JavaType.Method m = (JavaType.Method)type;
                return (T)this.withExpression((Expression)((J.MethodInvocation)this.expression).withMethodType(m));
            }
            return (T)this.withExpression((Expression)this.expression.withType(type));
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @NonNull
        @Generated
        public String toString() {
            return "G.ExpressionStatement(id=" + this.getId() + ", expression=" + this.getExpression() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof ExpressionStatement;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public ExpressionStatement(UUID id, Expression expression) {
            this.id = id;
            this.expression = expression;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        @Generated
        public ExpressionStatement withId(UUID id) {
            return this.id == id ? this : new ExpressionStatement(id, this.expression);
        }

        @NonNull
        @Generated
        public ExpressionStatement withExpression(Expression expression) {
            return this.expression == expression ? this : new ExpressionStatement(this.id, expression);
        }
    }

    public static final class CompilationUnit
    implements G,
    JavaSourceFile,
    SourceFile {
        private transient @Nullable SoftReference<TypesInUse> typesInUse;
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final @Nullable String shebang;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        private final @Nullable FileAttributes fileAttributes;
        private final @Nullable String charsetName;
        private final boolean charsetBomMarked;
        private final @Nullable Checksum checksum;
        private final @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Package> packageDeclaration;
        private final List<JRightPadded<Statement>> statements;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Package getPackageDeclaration() {
            return this.packageDeclaration == null ? null : (J.Package)this.packageDeclaration.getElement();
        }

        public CompilationUnit withPackageDeclaration(J.Package packageDeclaration) {
            return this.getPadding().withPackageDeclaration((JRightPadded<J.Package>)JRightPadded.withElement(this.packageDeclaration, (Object)packageDeclaration));
        }

        public <S, T extends S> T service(Class<S> service) {
            String serviceName = service.getName();
            try {
                Class<Object> serviceClass;
                if (GroovyAutoFormatService.class.getName().equals(serviceName)) {
                    serviceClass = service;
                } else if (AutoFormatService.class.getName().equals(serviceName)) {
                    serviceClass = service.getClassLoader().loadClass(GroovyAutoFormatService.class.getName());
                } else if (WhitespaceValidationService.class.getName().equals(serviceName)) {
                    serviceClass = service.getClassLoader().loadClass(GroovyWhitespaceValidationService.class.getName());
                } else {
                    return (T)super.service(service);
                }
                return (T)serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public CompilationUnit withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        @Transient
        public List<J.Import> getImports() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.Import.class::isInstance).map(J.Import.class::cast).collect(Collectors.toList());
        }

        public CompilationUnit withImports(List<J.Import> imports) {
            return this.getPadding().withImports(JRightPadded.withElements(this.getPadding().getImports(), imports));
        }

        @Transient
        public List<J.ClassDeclaration> getClasses() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.ClassDeclaration.class::isInstance).map(J.ClassDeclaration.class::cast).collect(Collectors.toList());
        }

        public JavaSourceFile withClasses(List<J.ClassDeclaration> classes) {
            return this.getPadding().withClasses(JRightPadded.withElements(this.getPadding().getClasses(), classes));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new GroovyPrinter();
        }

        @Transient
        public TypesInUse getTypesInUse() {
            TypesInUse cache;
            if (this.typesInUse == null) {
                cache = TypesInUse.build((JavaSourceFile)this);
                this.typesInUse = new SoftReference<TypesInUse>(cache);
            } else {
                cache = this.typesInUse.get();
                if (cache == null || cache.getCu() != this) {
                    cache = TypesInUse.build((JavaSourceFile)this);
                    this.typesInUse = new SoftReference<TypesInUse>(cache);
                }
            }
            return cache;
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        @Generated
        public String toString() {
            return "G.CompilationUnit(typesInUse=" + this.getTypesInUse() + ", padding=" + this.getPadding() + ", id=" + this.getId() + ", shebang=" + this.getShebang() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.charsetName + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", packageDeclaration=" + this.getPackageDeclaration() + ", statements=" + this.getStatements() + ", eof=" + this.getEof() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public CompilationUnit(UUID id, @Nullable String shebang, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Package> packageDeclaration, List<JRightPadded<Statement>> statements, Space eof) {
            this.id = id;
            this.shebang = shebang;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.packageDeclaration = packageDeclaration;
            this.statements = statements;
            this.eof = eof;
        }

        @Generated
        private CompilationUnit(@Nullable SoftReference<TypesInUse> typesInUse, @Nullable WeakReference<Padding> padding, UUID id, @Nullable String shebang, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Package> packageDeclaration, List<JRightPadded<Statement>> statements, Space eof) {
            this.typesInUse = typesInUse;
            this.padding = padding;
            this.id = id;
            this.shebang = shebang;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.packageDeclaration = packageDeclaration;
            this.statements = statements;
            this.eof = eof;
        }

        @NonNull
        @Generated
        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(this.typesInUse, this.padding, id, this.shebang, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public CompilationUnit withShebang(@Nullable String shebang) {
            return this.shebang == shebang ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, shebang, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @Generated
        public @Nullable String getShebang() {
            return this.shebang;
        }

        @NonNull
        @Generated
        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @Generated
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @NonNull
        @Generated
        public CompilationUnit withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @Generated
        public @Nullable FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @NonNull
        @Generated
        private CompilationUnit withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @NonNull
        @Generated
        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @Generated
        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @NonNull
        @Generated
        public CompilationUnit withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @Generated
        public @Nullable Checksum getChecksum() {
            return this.checksum;
        }

        @NonNull
        @Generated
        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, eof);
        }

        @Generated
        public Space getEof() {
            return this.eof;
        }

        public static class Padding
        implements JavaSourceFile.Padding {
            private final CompilationUnit t;

            public @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Package> getPackageDeclaration() {
                return this.t.packageDeclaration;
            }

            public CompilationUnit withPackageDeclaration(@Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Package> packageDeclaration) {
                return this.t.packageDeclaration == packageDeclaration ? this.t : new CompilationUnit(this.t.id, this.t.shebang, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, packageDeclaration, this.t.statements, this.t.eof);
            }

            @Transient
            public List<JRightPadded<J.ClassDeclaration>> getClasses() {
                return this.t.statements.stream().filter(s -> s.getElement() instanceof J.ClassDeclaration).map(s -> s).collect(Collectors.toList());
            }

            public CompilationUnit withClasses(List<JRightPadded<J.ClassDeclaration>> classes) {
                JRightPadded statement;
                List<JRightPadded<Statement>> statements = this.t.statements.stream().filter(s -> !(s.getElement() instanceof J.ClassDeclaration)).collect(Collectors.toList());
                int insertionIdx = 0;
                Iterator iterator = statements.iterator();
                while (iterator.hasNext() && (statement = (JRightPadded)iterator.next()).getElement() instanceof J.Import) {
                    ++insertionIdx;
                }
                statements.addAll(insertionIdx, classes.stream().map(i -> i).collect(Collectors.toList()));
                List<JRightPadded<J.ClassDeclaration>> originalClasses = this.t.getPadding().getClasses();
                if (originalClasses.size() != classes.size()) {
                    return new CompilationUnit(this.t.id, this.t.shebang, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, (JRightPadded<J.Package>)this.t.packageDeclaration, statements, this.t.eof);
                }
                boolean hasChanges = false;
                for (int i2 = 0; i2 < originalClasses.size(); ++i2) {
                    if (originalClasses.get(i2) == classes.get(i2)) continue;
                    hasChanges = true;
                    break;
                }
                return !hasChanges ? this.t : new CompilationUnit(this.t.id, this.t.shebang, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, (JRightPadded<J.Package>)this.t.packageDeclaration, statements, this.t.eof);
            }

            @Transient
            public List<JRightPadded<J.Import>> getImports() {
                return this.t.statements.stream().filter(s -> s.getElement() instanceof J.Import).map(s -> s).collect(Collectors.toList());
            }

            public CompilationUnit withImports(List<JRightPadded<J.Import>> imports) {
                List<JRightPadded<Statement>> statements = this.t.statements.stream().filter(s -> !(s.getElement() instanceof J.Import)).collect(Collectors.toList());
                statements.addAll(0, imports.stream().map(i -> i).collect(Collectors.toList()));
                List<JRightPadded<J.Import>> originalImports = this.t.getPadding().getImports();
                if (originalImports.size() != imports.size()) {
                    return new CompilationUnit(this.t.id, this.t.shebang, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, (JRightPadded<J.Package>)this.t.packageDeclaration, statements, this.t.eof);
                }
                boolean hasChanges = false;
                for (int i2 = 0; i2 < originalImports.size(); ++i2) {
                    if (originalImports.get(i2) == imports.get(i2)) continue;
                    hasChanges = true;
                    break;
                }
                return !hasChanges ? this.t : new CompilationUnit(this.t.id, this.t.shebang, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, (JRightPadded<J.Package>)this.t.packageDeclaration, statements, this.t.eof);
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public CompilationUnit withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new CompilationUnit(this.t.id, this.t.shebang, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, (JRightPadded<J.Package>)this.t.packageDeclaration, statements, this.t.eof);
            }

            @Generated
            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }
}

