/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.JavaTypeSignatureBuilder;

class GroovyAstTypeSignatureBuilder
implements JavaTypeSignatureBuilder {
    private @Nullable Set<String> typeVariableNameStack;

    GroovyAstTypeSignatureBuilder() {
    }

    public String signature(@Nullable Object t) {
        if (t == null) {
            return "{undefined}";
        }
        try {
            ASTNode astNode = (ASTNode)t;
            if (astNode instanceof ClassNode) {
                ClassNode clazz = (ClassNode)astNode;
                if (clazz.isArray()) {
                    return this.arraySignature(clazz);
                }
                if (ClassHelper.isPrimitiveType((ClassNode)clazz)) {
                    return this.primitiveSignature(clazz);
                }
                if (clazz.isUsingGenerics()) {
                    return this.parameterizedSignature(clazz);
                }
                return this.classSignature(astNode);
            }
            if (astNode instanceof GenericsType) {
                return this.genericSignature(astNode);
            }
            if (astNode instanceof MethodNode) {
                return this.methodSignature((MethodNode)astNode);
            }
            if (astNode instanceof FieldNode) {
                return this.variableSignature((FieldNode)astNode);
            }
        }
        catch (NoClassDefFoundError e) {
            return e.getMessage();
        }
        throw new UnsupportedOperationException("Unexpected type " + t.getClass().getName());
    }

    public String arraySignature(Object type) {
        ClassNode clazz = (ClassNode)type;
        String component = clazz.getComponentType().isUsingGenerics() ? this.genericSignature(clazz.getComponentType().getGenericsTypes()[0]) : this.signature(clazz.getComponentType());
        return component + "[]";
    }

    public String classSignature(Object type) {
        ClassNode clazz = (ClassNode)type;
        return clazz.getName();
    }

    public String genericSignature(Object type) {
        GenericsType g = (GenericsType)type;
        if (!g.isPlaceholder() && !g.isWildcard()) {
            return this.signature(g.getType());
        }
        String name = g.getName();
        if (this.typeVariableNameStack == null) {
            this.typeVariableNameStack = new HashSet<String>();
        }
        if (!this.typeVariableNameStack.add(name)) {
            this.typeVariableNameStack.remove(name);
            return "Generic{" + name + "}";
        }
        StringBuilder s = new StringBuilder("Generic{" + name);
        StringJoiner bounds = new StringJoiner(" & ");
        if (g.getUpperBounds() != null) {
            s.append(" extends ");
            for (ClassNode bound : g.getUpperBounds()) {
                bounds.add(this.signature(bound));
            }
        } else if (g.getLowerBound() != null) {
            s.append(" super ");
            bounds.add(this.signature(g.getLowerBound()));
        }
        s.append(bounds);
        this.typeVariableNameStack.remove(name);
        return s.append("}").toString();
    }

    public String parameterizedSignature(Object type) {
        ClassNode classNode = (ClassNode)type;
        StringBuilder s = new StringBuilder(this.classSignature(type));
        StringJoiner typeParameters = new StringJoiner(", ", "<", ">");
        if (classNode.getGenericsTypes() != null) {
            for (GenericsType genericsType : classNode.getGenericsTypes()) {
                typeParameters.add(this.signature(genericsType));
            }
        }
        s.append(typeParameters);
        return s.toString();
    }

    public String primitiveSignature(Object type) {
        ClassNode clazz = (ClassNode)type;
        return clazz.getName();
    }

    public String methodSignature(MethodNode node) {
        StringBuilder s = new StringBuilder(node.getDeclaringClass().getName());
        s.append("{name=").append(node instanceof ConstructorNode ? "<constructor>" : node.getName());
        s.append(",return=").append(node instanceof ConstructorNode ? node.getDeclaringClass().getName() : this.signature(node.getReturnType()));
        StringJoiner parameterTypes = new StringJoiner(",", "[", "]");
        if (node.getParameters().length > 0) {
            for (Parameter parameter : node.getParameters()) {
                parameterTypes.add(this.signature(parameter.getOriginType()));
            }
        }
        s.append(",parameters=").append(parameterTypes);
        s.append('}');
        return s.toString();
    }

    public String variableSignature(FieldNode declaredField) {
        String owner = this.signature(declaredField.getOwner());
        if (owner.contains("<")) {
            owner = owner.substring(0, owner.indexOf(60));
        }
        return owner + "{name=" + declaredField.getName() + '}';
    }

    public String variableSignature(String name) {
        return "{undefined}{name=" + name + '}';
    }
}

