/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.javadoc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.tools.checkstyle.FileStatefulCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.api.FileContents;
import org.openrewrite.tools.checkstyle.api.Scope;
import org.openrewrite.tools.checkstyle.api.TextBlock;
import org.openrewrite.tools.checkstyle.utils.AnnotationUtil;
import org.openrewrite.tools.checkstyle.utils.CheckUtil;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;
import org.openrewrite.tools.checkstyle.utils.ScopeUtil;

@FileStatefulCheck
public class MissingJavadocMethodCheck
extends AbstractCheck {
    public static final String MSG_JAVADOC_MISSING = "javadoc.missing";
    private static final int DEFAULT_MIN_LINE_COUNT = -1;
    private Scope scope = Scope.PUBLIC;
    private Scope excludeScope;
    private int minLineCount = -1;
    private boolean allowMissingPropertyJavadoc;
    private Pattern ignoreMethodNamesRegex;
    private List<String> allowedAnnotations = Collections.singletonList("Override");

    public void setAllowedAnnotations(String ... userAnnotations) {
        this.allowedAnnotations = Arrays.asList(userAnnotations);
    }

    public void setIgnoreMethodNamesRegex(Pattern pattern) {
        this.ignoreMethodNamesRegex = pattern;
    }

    public void setMinLineCount(int value) {
        this.minLineCount = value;
    }

    public void setAllowMissingPropertyJavadoc(boolean flag) {
        this.allowMissingPropertyJavadoc = flag;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setExcludeScope(Scope excludeScope) {
        this.excludeScope = excludeScope;
    }

    @Override
    public final int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8, 161, 203};
    }

    @Override
    public final void visitToken(DetailAST ast) {
        FileContents contents;
        TextBlock textBlock;
        Scope theScope = ScopeUtil.getScope(ast);
        if (this.shouldCheck(ast, theScope) && (textBlock = (contents = this.getFileContents()).getJavadocBefore(ast.getLineNo())) == null && !this.isMissingJavadocAllowed(ast)) {
            this.log(ast, MSG_JAVADOC_MISSING, new Object[0]);
        }
    }

    private static int getMethodsNumberOfLine(DetailAST methodDef) {
        DetailAST lcurly = methodDef.getLastChild();
        DetailAST rcurly = lcurly.getLastChild();
        int numberOfLines = lcurly.getFirstChild() == rcurly ? 1 : rcurly.getLineNo() - lcurly.getLineNo() - 1;
        return numberOfLines;
    }

    private boolean isMissingJavadocAllowed(DetailAST ast) {
        return this.allowMissingPropertyJavadoc && (CheckUtil.isSetterMethod(ast) || CheckUtil.isGetterMethod(ast)) || this.matchesSkipRegex(ast) || this.isContentsAllowMissingJavadoc(ast);
    }

    private boolean isContentsAllowMissingJavadoc(DetailAST ast) {
        return !(ast.getType() != 9 && ast.getType() != 8 && ast.getType() != 203 || MissingJavadocMethodCheck.getMethodsNumberOfLine(ast) > this.minLineCount && !AnnotationUtil.containsAnnotation(ast, this.allowedAnnotations));
    }

    private boolean matchesSkipRegex(DetailAST methodDef) {
        DetailAST ident;
        String methodName;
        Matcher matcher;
        boolean result = false;
        if (this.ignoreMethodNamesRegex != null && (matcher = this.ignoreMethodNamesRegex.matcher(methodName = (ident = methodDef.findFirstToken(58)).getText())).matches()) {
            result = true;
        }
        return result;
    }

    private boolean shouldCheck(DetailAST ast, Scope nodeScope) {
        Scope surroundingScope = ScopeUtil.getSurroundingScope(ast);
        return (this.excludeScope == null || nodeScope != this.excludeScope && surroundingScope != this.excludeScope) && nodeScope.isIn(this.scope) && surroundingScope.isIn(this.scope);
    }
}

