/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.TestKt;
import org.openrewrite.java.ChangeFieldName;
import org.openrewrite.java.ChangeFieldNameTest;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/ChangeFieldNameTest;", "", "changeFieldName", "", "jp", "Lorg/openrewrite/java/JavaParser;", "changeFieldNameReferences", "changeFieldNameReferencesInOtherClass", "rewrite-test"})
public interface ChangeFieldNameTest {
    @Test
    public void changeFieldName(@NotNull JavaParser var1);

    @Test
    public void changeFieldNameReferences(@NotNull JavaParser var1);

    @Test
    public void changeFieldNameReferencesInOtherClass(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void changeFieldName(@NotNull ChangeFieldNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import java.util.List;\n            public class A {\n               List collection = null;\n            }\n        ", (Parser)jp).whenVisitedByMapped(changeFieldName.1.INSTANCE).isRefactoredTo("\n                    import java.util.List;\n                    public class A {\n                       List list = null;\n                    }\n                ");
        }

        @Test
        public static void changeFieldNameReferences(@NotNull ChangeFieldNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            public class B {\n               int n;\n               \n               {\n                   n = 1;\n                   n /= 2;\n                   if(n + 1 == 2) {}\n                   n++;\n               }\n               \n               public int foo(int n) {\n                   return n + this.n;\n               }\n            }\n        ", (Parser)jp).whenVisitedBy((RefactorVisitor)new ChangeFieldName.Scoped(JavaType.Class.build((String)"B"), "n", "n1")).isRefactoredTo("\n                    public class B {\n                       int n1;\n                       \n                       {\n                           n1 = 1;\n                           n1 /= 2;\n                           if(n1 + 1 == 2) {}\n                           n1++;\n                       }\n                       \n                       public int foo(int n) {\n                           return n + this.n1;\n                       }\n                    }\n                ");
        }

        @Test
        public static void changeFieldNameReferencesInOtherClass(@NotNull ChangeFieldNameTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            public class A {\n                B b = new B();\n                {\n                    b.n = 1;\n                }\n            }\n        ", (Parser)jp).whichDependsOn("\n                    public class B {\n                       int n;\n                    }\n                ").whenVisitedBy((RefactorVisitor)new ChangeFieldName.Scoped(JavaType.Class.build((String)"B"), "n", "n1")).isRefactoredTo("\n                    public class A {\n                        B b = new B();\n                        {\n                            b.n1 = 1;\n                        }\n                    }\n                ");
        }
    }
}

