/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Assertions;
import org.openrewrite.Parser;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.TestKt;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaParser;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\bf\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0016"}, d2={"Lorg/openrewrite/java/ChangeTypeTest;", "", "annotation", "", "jp", "Lorg/openrewrite/java/JavaParser;", "array", "classDecl", "classReference", "dontAddImportWhenNoChangesWereMade", "fullyQualifiedName", "method", "methodInvocationTypeParametersAndWildcard", "methodSelect", "multiCatch", "multiVariable", "newClass", "parameterizedType", "simpleName", "staticImport", "typeCast", "Companion", "rewrite-test"})
public interface ChangeTypeTest {
    public static final Companion Companion = org.openrewrite.java.ChangeTypeTest$Companion.$$INSTANCE;

    @Test
    public void dontAddImportWhenNoChangesWereMade(@NotNull JavaParser var1);

    @Test
    public void simpleName(@NotNull JavaParser var1);

    @Test
    public void fullyQualifiedName(@NotNull JavaParser var1);

    @Test
    public void annotation(@NotNull JavaParser var1);

    @Test
    public void array(@NotNull JavaParser var1);

    @Test
    public void classDecl(@NotNull JavaParser var1);

    @Test
    public void method(@NotNull JavaParser var1);

    @Test
    public void methodInvocationTypeParametersAndWildcard(@NotNull JavaParser var1);

    @Test
    public void multiCatch(@NotNull JavaParser var1);

    @Test
    public void multiVariable(@NotNull JavaParser var1);

    @Test
    public void newClass(@NotNull JavaParser var1);

    @Test
    public void parameterizedType(@NotNull JavaParser var1);

    @Test
    public void typeCast(@NotNull JavaParser var1);

    @Test
    public void classReference(@NotNull JavaParser var1);

    @Test
    public void methodSelect(@NotNull JavaParser var1);

    @Test
    public void staticImport(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void dontAddImportWhenNoChangesWereMade(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("public class B {}", (Parser)jp).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isUnchanged();
        }

        @Test
        public static void simpleName(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import a.A1;\n            \n            public class B extends A1 {}\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("\n                    import a.A2;\n                    \n                    public class B extends A2 {}\n                ");
        }

        @Test
        public static void fullyQualifiedName(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("public class B extends a.A1 {}", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("public class B extends a.A2 {}");
        }

        @Test
        public static void annotation(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("@a.A1 public class B {}", (Parser)jp).whichDependsOn("package a;\npublic @interface A1 {}").whichDependsOn("package a;\npublic @interface A2 {}").whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("@a.A2 public class B {}");
        }

        @Test
        public static void array(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import a.A1;\n            public class B {\n               A1[] a = new A1[0];\n            }\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("\n                    import a.A2;\n                    public class B {\n                       A2[] a = new A2[0];\n                    }\n                ");
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void classDecl(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType();
            boolean bl = false;
            boolean bl2 = false;
            ChangeType changeType2 = changeType;
            Assertions.RefactoringAssert refactoringAssert = TestKt.whenParsedBy("\n            import a.A1;\n            public class B extends A1 implements I1 {}\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whichDependsOn("public interface I1 {}").whichDependsOn("public interface I2 {}").whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion));
            boolean bl3 = false;
            $this$apply.setType("I1");
            $this$apply.setTargetType("I2");
            Unit unit = Unit.INSTANCE;
            refactoringAssert.whenVisitedBy((RefactorVisitor)changeType).isRefactoredTo("\n                    import a.A2;\n                    public class B extends A2 implements I2 {}\n                ");
        }

        @Test
        public static void method(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import a.A1;\n            public class B {\n               public A1 foo() throws A1 { return null; }\n            }\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("\n                    import a.A2;\n                    public class B {\n                       public A2 foo() throws A2 { return null; }\n                    }\n                ");
        }

        @Test
        public static void methodInvocationTypeParametersAndWildcard(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import a.A1;\n            public class B {\n               public <T extends A1> T generic(T n, List<? super A1> in);\n               public void test() {\n                   A1.stat();\n                   this.<A1>generic(null, null);\n               }\n            }\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("\n                    import a.A2;\n                    public class B {\n                       public <T extends A2> T generic(T n, List<? super A2> in);\n                       public void test() {\n                           A2.stat();\n                           this.<A2>generic(null, null);\n                       }\n                    }\n                ");
        }

        @Test
        public static void multiCatch(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import a.A1;\n            public class B {\n               public void test() {\n                   try {}\n                   catch(A1 | RuntimeException e) {}\n               }\n            }\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("\n                    import a.A2;\n                    public class B {\n                       public void test() {\n                           try {}\n                           catch(A2 | RuntimeException e) {}\n                       }\n                    }\n                ");
        }

        @Test
        public static void multiVariable(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import a.A1;\n            public class B {\n               A1 f1, f2;\n            }\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("\n                    import a.A2;\n                    public class B {\n                       A2 f1, f2;\n                    }\n                ");
        }

        @Test
        public static void newClass(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import a.A1;\n            public class B {\n               A1 a = new A1();\n            }\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("\n                    import a.A2;\n                    public class B {\n                       A2 a = new A2();\n                    }\n                ");
        }

        @Test
        public static void parameterizedType(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import a.A1;\n            public class B {\n               Map<A1, A1> m;\n            }\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("\n                    import a.A2;\n                    public class B {\n                       Map<A2, A2> m;\n                    }\n                ");
        }

        @Test
        public static void typeCast(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import a.A1;\n            public class B {\n               A1 a = (A1) null;\n            }\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("\n                    import a.A2;\n                    public class B {\n                       A2 a = (A2) null;\n                    }\n                ");
        }

        @Test
        public static void classReference(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import a.A1;\n            public class A {\n                Class<?> clazz = A1.class;\n            }\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("\n                    import a.A2;\n                    public class A {\n                        Class<?> clazz = A2.class;\n                    }\n                ");
        }

        @Test
        public static void methodSelect(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import a.A1;\n            public class B {\n               A1 a = null;\n               public void test() { a.foo(); }\n            }\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("\n                    import a.A2;\n                    public class B {\n                       A2 a = null;\n                       public void test() { a.foo(); }\n                    }\n                ");
        }

        @Test
        public static void staticImport(@NotNull ChangeTypeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import static a.A1.stat;\n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ", (Parser)jp).whichDependsOn(org.openrewrite.java.ChangeTypeTest$Companion.access$getA1$p(Companion), org.openrewrite.java.ChangeTypeTest$Companion.access$getA2$p(Companion)).whenVisitedBy((RefactorVisitor)org.openrewrite.java.ChangeTypeTest$Companion.access$getChangeType$p(Companion)).isRefactoredTo("\n                    import static a.A2.stat;\n                    public class B {\n                        public void test() {\n                            stat();\n                        }\n                    }\n                ");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/ChangeTypeTest$Companion;", "", "()V", "a1", "", "a2", "changeType", "Lorg/openrewrite/java/ChangeType;", "rewrite-test"})
    public static final class Companion {
        private static final ChangeType changeType;
        private static final String a1;
        private static final String a2;
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            ChangeType changeType = new ChangeType();
            boolean bl = false;
            boolean bl2 = false;
            ChangeType $this$apply = changeType;
            boolean bl3 = false;
            $this$apply.setType("a.A1");
            $this$apply.setTargetType("a.A2");
            org.openrewrite.java.ChangeTypeTest$Companion.changeType = changeType;
            a1 = "package a;\npublic class A1 extends Exception {\n    public static void stat() {}\n    public void foo() {}\n}";
            a2 = "package a;\npublic class A2 extends Exception {\n    public static void stat() {}\n    public void foo() {}\n}";
        }

        public static final /* synthetic */ ChangeType access$getChangeType$p(Companion $this) {
            Companion companion = $this;
            return changeType;
        }

        public static final /* synthetic */ String access$getA1$p(Companion $this) {
            Companion companion = $this;
            return a1;
        }

        public static final /* synthetic */ String access$getA2$p(Companion $this) {
            Companion companion = $this;
            return a2;
        }
    }
}

