/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\n"}, d2={"Lorg/openrewrite/java/search/HasTypeTest;", "", "hasType", "", "jp", "Lorg/openrewrite/java/JavaParser;", "hasTypeBasedOnAnnotation", "hasTypeInLocalVariable", "hasTypeInStaticMethodTarget", "unresolvableMethodSymbol", "rewrite-test"})
public interface HasTypeTest {
    @Test
    public void hasType(@NotNull JavaParser var1);

    @Test
    public void hasTypeBasedOnAnnotation(@NotNull JavaParser var1);

    @Test
    public void hasTypeInStaticMethodTarget(@NotNull JavaParser var1);

    @Test
    public void hasTypeInLocalVariable(@NotNull JavaParser var1);

    @Test
    public void unresolvableMethodSymbol(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void hasType(@NotNull HasTypeTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.List;\n            class A {\n               List list;\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Assertions.assertTrue((boolean)((J.ClassDecl)compilationUnit.getClasses().get(0)).hasType("java.util.List"));
        }

        @Test
        public static void hasTypeBasedOnAnnotation(@NotNull HasTypeTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String b = "\n            package b;\n            public @interface MyAnnotation {\n            }\n        ";
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import b.MyAnnotation;\n            class A {\n               @MyAnnotation\n               public void post() {\n               }\n            }\n        ", b}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Assertions.assertTrue((boolean)((J.ClassDecl)compilationUnit.getClasses().get(0)).hasType("b.MyAnnotation"));
        }

        @Test
        public static void hasTypeInStaticMethodTarget(@NotNull HasTypeTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.*;\n            class A {\n               public void test() {\n                   List list = Collections.emptyList();\n               }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Assertions.assertTrue((boolean)((J.ClassDecl)compilationUnit.getClasses().get(0)).hasType("java.util.Collections"));
        }

        @Test
        public static void hasTypeInLocalVariable(@NotNull HasTypeTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.List;\n            class A {\n               public void test() {\n                   List list;\n               }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Assertions.assertTrue((boolean)((J.ClassDecl)compilationUnit.getClasses().get(0)).hasType("java.util.List"));
        }

        @Test
        public static void unresolvableMethodSymbol(@NotNull HasTypeTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class B {\n                public static void baz() {\n                    // the parse tree inside this anonymous class will be un-attributed because\n                    // A is not a resolvable symbol\n                    A a = new A() {\n                        @Override public void foo() {\n                            bar();\n                        }\n                    };\n                }\n                public static void bar() {}\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            ((J.ClassDecl)compilationUnit.getClasses().get(0)).hasType("DoesNotMatter");
        }
    }
}

