/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/tree/IfTest;", "", "ifElse", "", "jp", "Lorg/openrewrite/java/JavaParser;", "noElse", "singleLineIfElseStatements", "rewrite-test"})
public interface IfTest {
    @Test
    public void ifElse(@NotNull JavaParser var1);

    @Test
    public void noElse(@NotNull JavaParser var1);

    @Test
    public void singleLineIfElseStatements(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void ifElse(@NotNull IfTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                int n;\n                public void test() {\n                    if(n == 0) {\n                    }\n                    else if(n == 1) {\n                    }\n                    else {\n                    }\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.If iff = (J.If)statement;
            J.Parentheses parentheses2 = iff.getIfCondition();
            Intrinsics.checkNotNullExpressionValue((Object)parentheses2, (String)"iff.ifCondition");
            Assertions.assertTrue((boolean)(parentheses2.getTree() instanceof J.Binary));
            Assertions.assertTrue((boolean)(iff.getThenPart() instanceof J.Block));
            J.If.Else else_ = iff.getElsePart();
            Assertions.assertTrue((boolean)((else_ != null ? else_.getStatement() : null) instanceof J.If));
            J.If.Else else_2 = iff.getElsePart();
            Object object = else_2 != null ? else_2.getStatement() : null;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.If elseIf = (J.If)object;
            J.Parentheses parentheses3 = elseIf.getIfCondition();
            Intrinsics.checkNotNullExpressionValue((Object)parentheses3, (String)"elseIf.ifCondition");
            Assertions.assertTrue((boolean)(parentheses3.getTree() instanceof J.Binary));
            Assertions.assertTrue((boolean)(elseIf.getThenPart() instanceof J.Block));
            J.If.Else else_3 = elseIf.getElsePart();
            Assertions.assertTrue((boolean)((else_3 != null ? else_3.getStatement() : null) instanceof J.Block));
            Assertions.assertEquals((Object)"if(n == 0) {\n}\nelse if(n == 1) {\n}\nelse {\n}", (Object)iff.printTrimmed());
        }

        @Test
        public static void noElse(@NotNull IfTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                int n;\n                public void test() {\n                    if(n == 0) {} \n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.If iff = (J.If)statement;
            Assertions.assertNull((Object)iff.getElsePart());
        }

        @Test
        public static void singleLineIfElseStatements(@NotNull IfTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                int n;\n                public void test() {\n                    if(n == 0) test();\n                    else if(n == 1) test();\n                    else test();\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Assertions.assertEquals((Object)"public void test() {\n    if(n == 0) test();\n    else if(n == 1) test();\n    else test();\n}", (Object)((J.MethodDecl)((J.ClassDecl)e).getMethods().get(0)).printTrimmed());
        }
    }
}

