/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\n"}, d2={"Lorg/openrewrite/java/tree/LambdaTest;", "", "lambda", "", "jp", "Lorg/openrewrite/java/JavaParser;", "multipleParameters", "optionalSingleParameterParentheses", "rightSideBlock", "untypedLambdaParameter", "rewrite-test"})
public interface LambdaTest {
    @Test
    public void lambda(@NotNull JavaParser var1);

    @Test
    public void untypedLambdaParameter(@NotNull JavaParser var1);

    @Test
    public void optionalSingleParameterParentheses(@NotNull JavaParser var1);

    @Test
    public void rightSideBlock(@NotNull JavaParser var1);

    @Test
    public void multipleParameters(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void lambda(@NotNull LambdaTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.function.Function;\n            public class A {\n                Function<String, String> func = (String s) -> \"\";\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Lambda");
            }
            J.Lambda lambda = (J.Lambda)expression;
            J.Lambda.Parameters parameters = lambda.getParamSet();
            Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"lambda.paramSet");
            Assertions.assertEquals((int)1, (int)parameters.getParams().size());
            Assertions.assertTrue((boolean)(lambda.getBody() instanceof J.Literal));
            Assertions.assertEquals((Object)"(String s) -> \"\"", (Object)lambda.printTrimmed());
        }

        @Test
        public static void untypedLambdaParameter(@NotNull LambdaTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.*;\n            public class A {\n                List<String> list = new ArrayList<>();\n                public void test() {\n                    list.stream().filter(s -> s.isEmpty());\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].methods[0]");
            J.Block block = ((J.MethodDecl)e2).getBody();
            Intrinsics.checkNotNull((Object)block);
            Assertions.assertEquals((Object)"list.stream().filter(s -> s.isEmpty())", (Object)((Statement)block.getStatements().get(0)).printTrimmed());
        }

        @Test
        public static void optionalSingleParameterParentheses(@NotNull LambdaTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.*;\n            public class A {\n                List<String> list = new ArrayList<>();\n                public void test() {\n                    list.stream().filter((s) -> s.isEmpty());\n                }\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].methods[0]");
            J.Block block = ((J.MethodDecl)e2).getBody();
            Intrinsics.checkNotNull((Object)block);
            Assertions.assertEquals((Object)"list.stream().filter((s) -> s.isEmpty())", (Object)((Statement)block.getStatements().get(0)).printTrimmed());
        }

        @Test
        public static void rightSideBlock(@NotNull LambdaTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                Action a = ( ) -> { };\n            }\n\n            interface Action {\n                void call();\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            Expression lambda = expression;
            Assertions.assertEquals((Object)"( ) -> { }", (Object)lambda.printTrimmed());
        }

        @Test
        public static void multipleParameters(@NotNull LambdaTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.function.BiConsumer;\n            public class A {\n                BiConsumer<String, String> a = (s1, s2) -> { };\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            Intrinsics.checkNotNull((Object)expression);
            Expression lambda = expression;
            Assertions.assertEquals((Object)"(s1, s2) -> { }", (Object)lambda.printTrimmed());
        }
    }
}

