/*
 * Copyright 2020 the original author or authors.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.openrewrite.java.tree

import org.junit.jupiter.api.Assertions.assertEquals
import org.junit.jupiter.api.Assertions.assertTrue
import org.junit.jupiter.api.Test
import org.openrewrite.java.JavaParser
import org.openrewrite.java.firstMethodStatement

interface AssignTest {
    
    @Test
    fun assignmentToField(jp: JavaParser) {
        val a = jp.parse("""
            public class A {
                String s;
                public void test() {
                    s = "foo";
                }
            }
        """)[0]
        
        val assign = a.firstMethodStatement() as J.Assign
        assertEquals("s", (assign.variable as J.Ident).simpleName)
        assertTrue(assign.assignment is J.Literal)
    }
    
    @Test
    fun format(jp: JavaParser) {
        val a = jp.parse("""
            @SuppressWarnings(value = "ALL")
            public class A {}
        """)[0]
        
        val assign = a.classes[0].annotations[0].args!!.args[0] as J.Assign
        
        assertEquals("value = \"ALL\"", assign.printTrimmed())
    }
}
