/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.openrewrite.java.JavaParser;

public class JavaParserResolver
implements ParameterResolver {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().equals(JavaParser.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Object o = extensionContext.getTestInstance().get();
        try {
            Class<?> clazz = o.getClass();
            Object target = o;
            while (true) {
                try {
                    Method javaParser = clazz.getMethod("javaParser", new Class[0]);
                    javaParser.setAccessible(true);
                    return javaParser.invoke(target, new Object[0]);
                }
                catch (NoSuchMethodException javaParser) {
                    try {
                        target = o.getClass().getDeclaredField("this$0").get(target);
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        break;
                    }
                    if ((clazz = clazz.getEnclosingClass()) != null) continue;
                }
                break;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        Assertions.fail((String)"This should never happen -- an implementation of javaParser() was not found");
        return null;
    }
}

