/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AddImportTest;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\r\bf\u0018\u00002\u00020\u0001:\u0001+J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J-\u0010\n\u001a\u00020\u000b2\u001e\u0010\f\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r\"\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\u001e\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001fH\u0017J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010*\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006,"}, d2={"Lorg/openrewrite/java/AddImportTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "addFirstImport", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addImportAndFoldIntoWildcard", "addImportIfReferenced", "addImportInsertsNewMiddleBlock", "addImportWhenDuplicatesExist", "addImports", "Lorg/openrewrite/Recipe;", "adds", "", "Lorg/openrewrite/java/AddImport;", "Lorg/openrewrite/ExecutionContext;", "([Lorg/openrewrite/java/AddImport;)Lorg/openrewrite/Recipe;", "addMultipleImports", "addNamedImport", "addNamedImportIfStarStaticImportExists", "addNamedStaticImport", "addNamedStaticImportWhenReferenced", "addStaticImportField", "addStaticWildcardImportWhenReferenced", "doNotAddImportIfAlreadyExists", "doNotAddImportIfCoveredByStarImport", "doNotAddImportIfNotReferenced", "doNotAddNamedStaticImportIfNotReferenced", "doNotAddWildcardImportIfNotReferenced", "dontAddImportForPrimitive", "dontAddImportForStaticImportsIndirectlyReferenced", "Lorg/openrewrite/java/JavaParser$Builder;", "dontAddImportWhenClassHasNoPackage", "dontAddStaticWildcardImportIfNotReferenced", "dontDuplicateImports", "dontDuplicateImports2", "dontDuplicateImports3", "dontImportFromSamePackage", "dontImportYourself", "importOrderingIssue", "importsAddedInAlphabeticalOrder", "lastImportWhenFirstClassDeclarationHasJavadoc", "namedImportAddedAfterPackageDeclaration", "FixEmptyListMethodType", "rewrite-test"})
public interface AddImportTest
extends JavaRecipeTest {
    @NotNull
    public Recipe addImports(AddImport<ExecutionContext> ... var1);

    @Test
    public void dontDuplicateImports(@NotNull JavaParser var1);

    @Test
    public void dontDuplicateImports2(@NotNull JavaParser var1);

    @Test
    public void dontDuplicateImports3(@NotNull JavaParser var1);

    @Test
    public void dontImportYourself(@NotNull JavaParser var1);

    @Test
    public void dontImportFromSamePackage(@NotNull JavaParser var1);

    @Test
    public void importOrderingIssue(@NotNull JavaParser var1);

    @Test
    public void addMultipleImports(@NotNull JavaParser var1);

    @Test
    public void addNamedImport(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addImportInsertsNewMiddleBlock(@NotNull JavaParser var1);

    @Test
    public void addFirstImport(@NotNull JavaParser var1);

    @Test
    public void addImportIfReferenced(@NotNull JavaParser var1);

    @Test
    public void doNotAddWildcardImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull JavaParser var1);

    @Test
    public void namedImportAddedAfterPackageDeclaration(@NotNull JavaParser var1);

    @Test
    public void importsAddedInAlphabeticalOrder(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfAlreadyExists(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfCoveredByStarImport(@NotNull JavaParser var1);

    @Test
    public void dontAddImportWhenClassHasNoPackage(@NotNull JavaParser var1);

    @Test
    public void dontAddImportForPrimitive(@NotNull JavaParser var1);

    @Test
    public void addNamedImportIfStarStaticImportExists(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImport(@NotNull JavaParser var1);

    @Test
    public void addStaticImportField(@NotNull JavaParser var1);

    @Test
    public void dontAddStaticWildcardImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImportWhenReferenced(@NotNull JavaParser var1);

    @Test
    public void doNotAddNamedStaticImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addStaticWildcardImportWhenReferenced(@NotNull JavaParser var1);

    @Test
    public void dontAddImportForStaticImportsIndirectlyReferenced(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void addImportAndFoldIntoWildcard(@NotNull JavaParser var1);

    @Test
    public void addImportWhenDuplicatesExist(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/AddImportTest$FixEmptyListMethodType;", "Lorg/openrewrite/Recipe;", "()V", "getDisplayName", "", "getVisitor", "Lorg/openrewrite/TreeVisitor;", "Lorg/openrewrite/ExecutionContext;", "rewrite-test"})
    private static final class FixEmptyListMethodType
    extends Recipe {
        @NotNull
        public String getDisplayName() {
            return "Fix Empty List";
        }

        @NotNull
        protected TreeVisitor<?, ExecutionContext> getVisitor() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    J.MethodInvocation methodInvocation2 = super.visitMethodInvocation(method, (Object)ctx);
                    Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"super.visitMethodInvocation(method, ctx)");
                    J.MethodInvocation original = methodInvocation2;
                    if (Intrinsics.areEqual((Object)original.getName().getSimpleName(), (Object)"emptyList")) {
                        methodInvocation2 = original.withSelect(null);
                        Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"original.withSelect(null)");
                        return methodInvocation2;
                    }
                    return original;
                }
            };
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Recipe addImports(@NotNull AddImportTest this_, AddImport<ExecutionContext> ... adds) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(adds, (String)"adds");
            AddImport<ExecutionContext>[] $this$map$iv = adds;
            boolean $i$f$map = false;
            AddImport<ExecutionContext>[] addImportArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo2 = false;
            void var7_8 = $this$mapTo$iv$iv;
            int n = ((void)var7_8).length;
            for (int i = 0; i < n; ++i) {
                void add;
                void item$iv$iv;
                void var11_13 = item$iv$iv = var7_8[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                RecipeTest.AdHocRecipe adHocRecipe = this_.toRecipe((TreeVisitor)add);
                collection.add(adHocRecipe);
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            if (iterator$iv.hasNext()) {
                void r2;
                RecipeTest.AdHocRecipe $i$f$mapTo2 = (RecipeTest.AdHocRecipe)((Object)iterator$iv.next());
                RecipeTest.AdHocRecipe r1 = (RecipeTest.AdHocRecipe)((Object)accumulator$iv);
                boolean bl = false;
                Recipe recipe2 = r1.doNext((Recipe)r2);
                Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"r1.doNext(r2)");
                return recipe2;
            }
            return (Recipe)accumulator$iv;
        }

        @Test
        public static void dontDuplicateImports(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("org.springframework.http.HttpStatus", null, false), new AddImport("org.springframework.http.HttpStatus.Series", null, false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "class A {}", null, "\n            import org.springframework.http.HttpStatus;\n            import org.springframework.http.HttpStatus.Series;\n            \n            class A {}\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void dontDuplicateImports2(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("org.junit.jupiter.api.Test", null, false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "\n            import org.junit.jupiter.api.AfterEach;\n            import org.junit.jupiter.api.Assertions;\n            import org.junit.jupiter.api.BeforeAll;\n            import org.junit.jupiter.api.BeforeEach;\n            import org.slf4j.Logger;\n            import org.slf4j.LoggerFactory;\n\n            class A {}\n        ", null, "\n            import org.junit.jupiter.api.*;\n            import org.slf4j.Logger;\n            import org.slf4j.LoggerFactory;\n            \n            class A {}\n        ", 1, 1, false, null, 392, null);
        }

        @Test
        public static void dontDuplicateImports3(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("org.junit.jupiter.api.Assertions", "assertNull", false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "\n            import static org.junit.jupiter.api.Assertions.assertFalse;\n            import static org.junit.jupiter.api.Assertions.assertTrue;\n            \n            import java.util.List;\n\n            class A {}\n        ", null, "\n            import static org.junit.jupiter.api.Assertions.*;\n            \n            import java.util.List;\n            \n            class A {}\n        ", 1, 1, false, null, 392, null);
        }

        @Test
        public static void dontImportYourself(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("com.myorg.A", null, false)};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(addImportArray), "\n            package com.myorg;\n            \n            class A {\n            }\n        ", null, 8, null);
        }

        @Test
        public static void dontImportFromSamePackage(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new AddImport[]{new AddImport("com.myorg.B", null, false)};
            Recipe recipe2 = this_.addImports((AddImport<ExecutionContext>[])objectArray);
            String[] stringArray = new String[]{"\n            package com.myorg;\n            \n            class B {\n            }\n        "};
            objectArray = stringArray;
            this_.assertUnchanged(jp, recipe2, "\n            package com.myorg;\n            \n            class A {\n            }\n        ", (String[])objectArray);
        }

        @Test
        public static void importOrderingIssue(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("org.springframework.http.HttpHeaders", null, false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "\n            import javax.ws.rs.core.Response.ResponseBuilder;\n            import java.util.Locale;\n\n            class A {}\n        ", null, "\n            import org.springframework.http.HttpHeaders;\n\n            import javax.ws.rs.core.Response.ResponseBuilder;\n            import java.util.Locale;\n\n            class A {}\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void addMultipleImports(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false), new AddImport("java.util.Set", null, false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "\n            class A {}\n        ", null, "\n            import java.util.List;\n            import java.util.Set;\n\n            class A {}\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void addNamedImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "class A {}", null, "\n            import java.util.List;\n            \n            class A {}\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void doNotAddImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, true)};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(addImportArray), "\n            package a;\n            \n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void addImportInsertsNewMiddleBlock(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "\n            package a;\n            \n            import com.sun.naming.*;\n            \n            import static java.util.Collections.*;\n            \n            class A {}\n        ", null, "\n            package a;\n            \n            import com.sun.naming.*;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {}\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void addFirstImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "\n            package a;\n            \n            class A {}\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {}\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void addImportIfReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    J.ClassDeclaration c = super.visitClassDeclaration(classDecl, (Object)ctx);
                    J.Block b = c.getBody();
                    Integer n = (Integer)ctx.getMessage("cyclesThatResultedInChanges", (Object)0);
                    boolean bl = false;
                    if (n != null && n == 0) {
                        String[] stringArray = new String[]{"java.math.BigDecimal", "java.math.RoundingMode"};
                        JavaTemplate t = JavaTemplate.builder(() -> addImportIfReferenced.1.visitClassDeclaration$lambda-0(this), (String)"BigDecimal d = BigDecimal.valueOf(1).setScale(1, RoundingMode.HALF_EVEN);").imports(stringArray).build();
                        b = (J.Block)b.withTemplate((SourceTemplate)t, b.getCoordinates().lastStatement(), new Object[0]);
                        this.maybeAddImport("java.math.BigDecimal");
                        this.maybeAddImport("java.math.RoundingMode");
                    }
                    J.ClassDeclaration classDeclaration = c.withBody(b);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"c.withBody(b)");
                    return classDeclaration;
                }

                private static final Cursor visitClassDeclaration$lambda-0(addImportIfReferenced.1 this$0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    return this$0.getCursor();
                }
            }), "\n            package a;\n\n            class A {\n            }\n        ", null, "\n            package a;\n            \n            import java.math.BigDecimal;\n            import java.math.RoundingMode;\n            \n            class A {\n                BigDecimal d = BigDecimal.valueOf(1).setScale(1, RoundingMode.HALF_EVEN);\n            }\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void doNotAddWildcardImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.*", null, true)};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(addImportArray), "\n            package a;\n            \n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.Collections", "*", false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "\n            import java.util.List;\n            \n            /**\n             * My type\n             */\n            class A {}\n        ", null, "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            /**\n             * My type\n             */\n            class A {}\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void namedImportAddedAfterPackageDeclaration(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "\n            package a;\n            class A {}\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {}\n        ", 0, 0, false, null, 488, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void importsAddedInAlphabeticalOrder(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            String string;
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new String[]{"c", "c.c", "c.c.c"};
            List otherPackages = CollectionsKt.listOf((Object[])objectArray);
            Object[] $this$mapIndexed$iv = (Object[])otherPackages;
            boolean $i$f$mapIndexed = false;
            Object[] objectArray2 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void pkg;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                string = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = "package " + (String)pkg + ";\npublic class C" + (int)i + " {}";
                collection.add(string2);
            }
            List otherImports = (List)destination$iv$iv;
            $this$mapIndexed$iv = new Pair[]{TuplesKt.to((Object)"b", (Object)0), TuplesKt.to((Object)"c.b", (Object)1), TuplesKt.to((Object)"c.c.b", (Object)2)};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])$this$mapIndexed$iv);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapIndexedTo$iv$iv2;
                Pair it = (Pair)element$iv;
                boolean bl = false;
                Pair pair = it;
                String pkg = (String)pair.component1();
                int order = ((Number)pair.component2()).intValue();
                Iterable $this$mapIndexed$iv2 = otherPackages;
                boolean $i$f$mapIndexed2 = false;
                Iterable i = $this$mapIndexed$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
                boolean $i$f$mapIndexedTo2 = false;
                int index$iv$iv2 = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                    void i2;
                    void otherPkg;
                    int n = index$iv$iv2++;
                    boolean bl3 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string3 = (String)item$iv$iv;
                    int n3 = n;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    String string4 = (String)otherPkg + ".C" + (int)i2;
                    collection.add(string4);
                }
                List expectedImports = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
                expectedImports.add(order, Intrinsics.stringPlus((String)pkg, (Object)".B"));
                string = new SpreadBuilder(2);
                Collection $this$toTypedArray$iv = otherImports;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                string.addSpread((Object)stringArray);
                string.add((Object)("\n                            package " + pkg + ";\n                            public class B {}\n                        "));
                String[] stringArray2 = (String[])string.toArray((Object[])new String[string.size()]);
                Object object = new AddImport[]{new AddImport(Intrinsics.stringPlus((String)pkg, (Object)".B"), null, false)};
                string = this_.addImports((AddImport<ExecutionContext>)object);
                object = "package a;\n\n" + CollectionsKt.joinToString$default((Iterable)expectedImports, (CharSequence)"\n", null, null, (int)0, null, (Function1)importsAddedInAlphabeticalOrder.1.1.INSTANCE, (int)30, null) + "\n\nclass A {}";
                JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)string, "\n                    package a;\n        \n                    import c.C0;\n                    import c.c.C1;\n                    import c.c.c.C2;\n        \n                    class A {}\n                ", stringArray2, (String)object, 0, 0, false, null, 480, null);
                jp.reset();
            }
        }

        @Test
        public static void doNotAddImportIfAlreadyExists(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false)};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(addImportArray), "\n            package a;\n            \n            import java.util.List;\n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void doNotAddImportIfCoveredByStarImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false)};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(addImportArray), "\n            package a;\n            \n            import java.util.*;\n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void dontAddImportWhenClassHasNoPackage(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("C", null, false)};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(addImportArray), "class A {}", null, 8, null);
        }

        @Test
        public static void dontAddImportForPrimitive(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("int", null, false)};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(addImportArray), "class A {}", null, 8, null);
        }

        @Test
        public static void addNamedImportIfStarStaticImportExists(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "\n            package a;\n            \n            import static java.util.List.*;\n            class A {}\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.List.*;\n            \n            class A {}\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void addNamedStaticImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.Collections", "emptyList", false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "\n            import java.util.*;\n            class A {}\n        ", null, "\n            import java.util.*;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {}\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void addStaticImportField(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new AddImport[]{new AddImport("mycompany.Type", "FIELD", false)};
            Recipe recipe2 = this_.addImports((AddImport<ExecutionContext>[])objectArray);
            String[] stringArray = new String[]{"\n                package mycompany;\n                public class Type {\n                    public static String FIELD;\n                }\n            "};
            objectArray = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, "class A {}", (String[])objectArray, "\n            import static mycompany.Type.FIELD;\n            \n            class A {}\n        ", 0, 0, false, null, 480, null);
        }

        @Test
        public static void dontAddStaticWildcardImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.Collections", "*", true)};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(addImportArray), "\n            package a;\n            \n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void addNamedStaticImportWhenReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.Collections", "emptyList", true)};
            Recipe recipe2 = new Recipe(){

                @NotNull
                public String getDisplayName() {
                    return "Test";
                }

                @NotNull
                protected TreeVisitor<?, ExecutionContext> getVisitor() {
                    return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                        public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation m, @NotNull ExecutionContext ctx) {
                            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            return m.withSelect(null);
                        }
                    };
                }
            }.doNext(this_.addImports(addImportArray));
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"object : Recipe() {\n            override fun getDisplayName(): String {\n                return \"Test\"\n            }\n\n            override fun getVisitor(): TreeVisitor<*, ExecutionContext> {\n                return object : JavaIsoVisitor<ExecutionContext>() {\n                    override fun visitMethodInvocation(m: J.MethodInvocation, ctx: ExecutionContext) =\n                        m.withSelect(null)\n                }\n            }\n\n        }.doNext(\n            addImports(AddImport(\"java.util.Collections\", \"emptyList\", true))\n        )");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, jp, recipe2, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {\n                public A() {\n                    List<String> list = java.util.Collections.emptyList();\n                }\n            }\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {\n                public A() {\n                    List<String> list = emptyList();\n                }\n            }\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void doNotAddNamedStaticImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.Collections", "emptyList", true)};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(addImportArray), "\n            package a;\n            \n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void addStaticWildcardImportWhenReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.Collections", "*", true)};
            Recipe recipe2 = new FixEmptyListMethodType().doNext(this_.addImports(addImportArray));
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"FixEmptyListMethodType().doNext(\n            addImports(\n                AddImport(\"java.util.Collections\", \"*\", true)\n            )\n        )");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, jp, recipe2, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {\n                public A() {\n                    List<String> list = java.util.Collections.emptyList();\n                }\n            }\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {\n                public A() {\n                    List<String> list = emptyList();\n                }\n            }\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void dontAddImportForStaticImportsIndirectlyReferenced(@NotNull AddImportTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            Object object = new String[]{"jackson-databind"};
            JavaParser javaParser = jp.classpath(object).build();
            object = this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.CompilationUnit visitCompilationUnit(@NotNull J.CompilationUnit cu, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)cu, (String)"cu");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    this.maybeAddImport("com.fasterxml.jackson.databind.ObjectMapper");
                    J.CompilationUnit compilationUnit = super.visitCompilationUnit(cu, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"super.visitCompilationUnit(cu, p)");
                    return compilationUnit;
                }
            });
            String[] stringArray = new String[]{"\n                import com.fasterxml.jackson.databind.ObjectMapper;\n                class Helper {\n                    static ObjectMapper OBJECT_MAPPER;\n                }\n            "};
            String[] stringArray2 = stringArray;
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"build()");
            this_.assertUnchanged(javaParser, (Recipe)object, "\n            class Test {\n                void test() {\n                    Helper.OBJECT_MAPPER.writer();\n                }\n            }\n        ", stringArray2);
        }

        @Test
        public static void addImportAndFoldIntoWildcard(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"\n                package foo;\n                public class B {\n                }\n                public class C {\n                }\n            "};
            Recipe recipe3 = recipe2;
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.ArrayList", null, false)};
            recipe2 = this_.addImports(addImportArray);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, "\n            import foo.B;\n            import foo.C;\n            import java.util.Collections;\n            import java.util.List;\n            import java.util.HashSet;\n            import java.util.HashMap;\n            \n            class A {\n                B b = new B();\n                C c = new C();\n                Map<String, String> map = new HashMap<>();\n                Set<String> set = new HashSet<>();\n                List<String> test = Collections.singletonList(\"test\");\n                List<String> test2 = new ArrayList<>();\n            }\n        ", (String[])recipe3, "\n            import foo.B;\n            import foo.C;\n            \n            import java.util.*;\n\n            class A {\n                B b = new B();\n                C c = new C();\n                Map<String, String> map = new HashMap<>();\n                Set<String> set = new HashSet<>();\n                List<String> test = Collections.singletonList(\"test\");\n                List<String> test2 = new ArrayList<>();\n            }\n        ", 0, 0, false, null, 480, null);
        }

        @Test
        public static void addImportWhenDuplicatesExist(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("org.springframework.http.MediaType", null, false)};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(addImportArray), "\n            import javax.ws.rs.Path;\n            import javax.ws.rs.Path;\n            \n            class A {}\n        ", null, "\n            import org.springframework.http.MediaType;\n            \n            import javax.ws.rs.Path;\n            import javax.ws.rs.Path;\n            \n            class A {}\n        ", 0, 0, false, null, 488, null);
        }

        public static void assertChangedBase(@NotNull AddImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull AddImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull AddImportTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull AddImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, boolean skipEnhancedTypeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, skipEnhancedTypeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, boolean skipEnhancedTypeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, skipEnhancedTypeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull AddImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull AddImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull AddImportTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull AddImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull AddImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull AddImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull AddImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

