/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\bf\u0018\u0000 &2\u00020\u0001:\u0001&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\n\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\u000f\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010!\u001a\u00020\u0007H\u0017J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006'"}, d2={"Lorg/openrewrite/java/OrderImportsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/java/OrderImports;", "getRecipe", "()Lorg/openrewrite/java/OrderImports;", "blankLineThenEmptyBlockThenNonEmptyBlock", "", "jp", "Lorg/openrewrite/java/JavaParser;", "blankLinesBetweenImports", "Lorg/openrewrite/java/JavaParser$Builder;", "blankLinesNotFollowedByBlockArentAdded", "collapsesDifferentStaticImportsFromSamePackage", "detectBlockPattern", "doNotFoldImports", "foldGroupOfStaticImportsThatAppearLast", "foldIntoExistingStar", "foldIntoStar", "groupImportsIsAwareOfNestedClasses", "idempotence", "importSorting", "innerClasses", "multipleClassesWithTheSameNameButDifferentPackages", "orderImports", "packagePatternEscapesDots", "preservesDifferentStaticImportsFromSamePackage", "preservesStaticInheritanceImport", "preservesStaticMethodArguments", "preservesStaticStarImportWhenRemovingUnused", "removeUnused", "removesRedundantImports", "sortInnerAndOuterClassesInTheSamePackage", "springCloudFormat", "twoImportsFollowedByStar", "unfoldStar", "unfoldStarMultiple", "unfoldStaticStar", "Companion", "rewrite-test"})
public interface OrderImportsTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.OrderImportsTest$Companion.$$INSTANCE;
    @NotNull
    public static final String a = "\n            package com.foo;\n            \n            public class A {\n                public static int one() { return 1;}\n                public static int plusOne(int n) { return n + 1; }\n                public static int three() { return 3; }\n            }\n        ";
    @NotNull
    public static final String b = "\n            package com.foo;\n            \n            public class B {\n                public static int two() { return 2; }\n                public static int multiply(int n, int n2) { return n * n2; }\n                public static int four() { return 4; }\n            }    \n        ";

    @NotNull
    public OrderImports getRecipe();

    @Test
    public void orderImports(@NotNull JavaParser var1);

    @Test
    public void sortInnerAndOuterClassesInTheSamePackage(@NotNull JavaParser var1);

    @Test
    public void multipleClassesWithTheSameNameButDifferentPackages(@NotNull JavaParser var1);

    @Test
    public void innerClasses(@NotNull JavaParser var1);

    @Test
    public void blankLineThenEmptyBlockThenNonEmptyBlock(@NotNull JavaParser var1);

    @Test
    public void foldIntoStar(@NotNull JavaParser var1);

    @Test
    public void blankLinesNotFollowedByBlockArentAdded(@NotNull JavaParser var1);

    @Test
    public void foldIntoExistingStar(@NotNull JavaParser var1);

    @Test
    public void idempotence(@NotNull JavaParser var1);

    @Test
    public void unfoldStar(@NotNull JavaParser var1);

    @Test
    public void unfoldStarMultiple(@NotNull JavaParser var1);

    @Test
    public void removeUnused(@NotNull JavaParser var1);

    @Test
    public void unfoldStaticStar(@NotNull JavaParser var1);

    @Test
    public void packagePatternEscapesDots(@NotNull JavaParser var1);

    @Test
    public void twoImportsFollowedByStar(@NotNull JavaParser var1);

    @Test
    public void springCloudFormat();

    @Test
    public void importSorting(@NotNull JavaParser var1);

    @Test
    public void foldGroupOfStaticImportsThatAppearLast(@NotNull JavaParser var1);

    @Test
    public void preservesStaticStarImportWhenRemovingUnused(@NotNull JavaParser var1);

    @Test
    public void preservesStaticInheritanceImport(@NotNull JavaParser var1);

    @Test
    public void preservesStaticMethodArguments(@NotNull JavaParser var1);

    @Test
    public void preservesDifferentStaticImportsFromSamePackage(@NotNull JavaParser var1);

    @Test
    public void collapsesDifferentStaticImportsFromSamePackage(@NotNull JavaParser var1);

    @Test
    public void removesRedundantImports(@NotNull JavaParser var1);

    @Test
    public void blankLinesBetweenImports(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void groupImportsIsAwareOfNestedClasses(@NotNull JavaParser var1);

    @Test
    public void detectBlockPattern(@NotNull JavaParser var1);

    @Test
    public void doNotFoldImports(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/OrderImportsTest$Companion;", "", "()V", "a", "", "b", "rewrite-test"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String a = "\n            package com.foo;\n            \n            public class A {\n                public static int one() { return 1;}\n                public static int plusOne(int n) { return n + 1; }\n                public static int three() { return 3; }\n            }\n        ";
        @NotNull
        public static final String b = "\n            package com.foo;\n            \n            public class B {\n                public static int two() { return 2; }\n                public static int multiply(int n, int n2) { return n * n2; }\n                public static int four() { return 4; }\n            }    \n        ";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static OrderImports getRecipe(@NotNull OrderImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return new OrderImports(false);
        }

        @Test
        public static void orderImports(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import static java.util.stream.Collectors.joining;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            import java.util.Set;\n            import org.openrewrite.java.tree.JavaType;\n            import org.openrewrite.java.tree.TypeUtils;\n            \n            class A {}\n        ", null, "\n            import org.openrewrite.java.tree.JavaType;\n            import org.openrewrite.java.tree.TypeUtils;\n            \n            import java.util.ArrayList;\n            import java.util.Objects;\n            import java.util.Set;\n            import java.util.regex.Pattern;\n            \n            import static java.util.stream.Collectors.joining;\n            \n            class A {}\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void sortInnerAndOuterClassesInTheSamePackage(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            class Test {}\n        ", null, 10, null);
        }

        @Test
        public static void multipleClassesWithTheSameNameButDifferentPackages(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.another;\n            public class Comment {}\n        "};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import org.another.Comment;\n            import org.openrewrite.java.tree.Comment;\n            import org.openrewrite.java.tree.CoordinatesBuilder;\n            import org.openrewrite.java.tree.Expression;\n            import org.openrewrite.java.tree.Flag;\n            import org.openrewrite.java.tree.JavaType;\n            \n            class Test {}\n        ", stringArray, 2, null);
        }

        @Test
        public static void innerClasses(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import org.openrewrite.java.tree.Comment;\n            import org.openrewrite.java.tree.CoordinatesBuilder;\n            import org.openrewrite.java.tree.Expression;\n            import org.openrewrite.java.tree.Flag;\n            import org.openrewrite.java.tree.J.Assert;\n            import org.openrewrite.java.tree.J.ClassDeclaration;\n            import org.openrewrite.java.tree.J.MethodDeclaration;\n            import org.openrewrite.java.tree.J.NewArray;\n            import org.openrewrite.java.tree.J.NewClass;\n            import org.openrewrite.java.tree.JavaType;\n            \n            class Test {}\n        ", null, "\n            import org.openrewrite.java.tree.*;\n            import org.openrewrite.java.tree.J.*;\n            \n            class Test {}\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void blankLineThenEmptyBlockThenNonEmptyBlock(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.util.ArrayList;\n            import java.util.Objects;\n\n            import org.openrewrite.java.tree.JavaType;\n            \n            class A {}\n        ", null, "\n            import org.openrewrite.java.tree.JavaType;\n            \n            import java.util.ArrayList;\n            import java.util.Objects;\n            \n            class A {}\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void foldIntoStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.util.List;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            import java.util.Set;\n            import java.util.Map;\n            \n            class A {}\n        ", null, "\n            import java.util.*;\n            import java.util.regex.Pattern;\n            \n            class A {}\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void blankLinesNotFollowedByBlockArentAdded(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void foldIntoExistingStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.util.*;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            \n            class A {}\n        ", null, "\n            import java.util.*;\n            import java.util.regex.Pattern;\n            \n            class A {}\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void idempotence(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.util.*;\n            import java.util.regex.Pattern;\n\n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void unfoldStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(true), "\n            import java.util.*;\n            \n            class A {\n                List list;\n                List list2;\n            }\n        ", null, "\n            import java.util.List;\n            \n            class A {\n                List list;\n                List list2;\n            }\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void unfoldStarMultiple(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(true), "\n            import java.util.*;\n            \n            class A {\n                List list;\n                List list2;\n                Map map;\n            }\n        ", null, "\n            import java.util.List;\n            import java.util.Map;\n            \n            class A {\n                List list;\n                List list2;\n                Map map;\n            }\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void removeUnused(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(true), "\n            import java.util.*;\n            \n            class A {\n            }\n        ", null, "\n            class A {\n            }\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void unfoldStaticStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(true), "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {\n                List list = emptyList();\n            }\n        ", null, "\n            import java.util.List;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {\n                List list = emptyList();\n            }\n        ", 0, 0, false, null, 488, null);
        }

        @Test
        public static void packagePatternEscapesDots(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import javax.annotation.Nonnull;\n            \n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void twoImportsFollowedByStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.io.IOException;\n            import java.io.UncheckedIOException;\n            import java.nio.files.*;\n            \n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void springCloudFormat(@NotNull OrderImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "spring", "spring", "spring", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().classCountToUseStarImport(999).nameCountToUseStarImport(999).importPackage("java.*").blankLine().importPackage("javax.*").blankLine().importAllOthers().blankLine().importPackage("org.springframework.*").blankLine().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles(\n            listOf(\n                NamedStyles(\n                    randomId(), \"spring\", \"spring\", \"spring\", emptySet(), listOf(\n                        ImportLayoutStyle.builder()\n                            .classCountToUseStarImport(999)\n                            .nameCountToUseStarImport(999)\n                            .importPackage(\"java.*\")\n                            .blankLine()\n                            .importPackage(\"javax.*\")\n                            .blankLine()\n                            .importAllOthers()\n                            .blankLine()\n                            .importPackage(\"org.springframework.*\")\n                            .blankLine()\n                            .importStaticAllOthers()\n                            .build()\n                    )\n                )\n            )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, "\n            import java.io.ByteArrayOutputStream;\n            import java.nio.charset.StandardCharsets;\n            import java.util.Collections;\n            import java.util.zip.GZIPOutputStream;\n            \n            import javax.servlet.ReadListener;\n            import javax.servlet.ServletInputStream;\n            import javax.servlet.ServletOutputStream;\n            \n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import reactor.core.publisher.Mono;\n            \n            import org.springframework.core.io.buffer.DataBuffer;\n            import org.springframework.core.io.buffer.DataBufferFactory;\n            import org.springframework.http.HttpHeaders;\n            import org.springframework.util.MultiValueMap;\n            import org.springframework.web.bind.annotation.PathVariable;\n            import org.springframework.web.server.ServerWebExchange;\n            \n            import static java.util.Arrays.stream;\n            import static org.springframework.cloud.gateway.support.ServerWebExchangeUtils.toAsyncPredicate;\n            \n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void importSorting(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import r.core.Flux;\n            import s.core.Flux;\n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import reactor.core.publisher.Mono;\n            \n            class A {}\n        ", null, "\n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import r.core.Flux;\n            import reactor.core.publisher.Mono;\n            import s.core.Flux;\n            \n            class A {}\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void foldGroupOfStaticImportsThatAppearLast(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import static java.util.stream.Collectors.toList;\n            import static java.util.stream.Collectors.toMap;\n            import static java.util.stream.Collectors.toSet;\n            \n            class A {}\n        ", null, "\n            import static java.util.stream.Collectors.*;\n            \n            class A {}\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void preservesStaticStarImportWhenRemovingUnused(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                package com.foo;\n                \n                public class A {\n                    public static void foo() {}\n                    public static void bar() {}\n                    public static void baz() {}\n                    public static void foo2() {}\n                    public static void bar2() {}\n                    public static void baz2() {}\n                }\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            package org.bar;\n            \n            import static com.foo.A.*;\n            \n            class B {\n                void bar() {\n                    foo();\n                    bar();\n                    baz();\n                    foo2();\n                    bar2();\n                    baz2();\n                }\n            }\n        ", stringArray2, 2, null);
        }

        @Test
        public static void preservesStaticInheritanceImport(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports(true);
            String[] stringArray = new String[]{"\n                package com.baz;\n                \n                public class A {\n                    public static void foo() {}\n                    public static void bar() {}\n                    public static void baz() {}\n                    public static void foo2() {}\n                    public static void bar2() {}\n                    public static void baz2() {}\n                }\n            ", "\n                package com.foo;\n                \n                import com.baz.A; \n                \n                public class B extends A { }\n            "};
            String[] stringArray2 = stringArray;
            this_.assertUnchanged(jp, (Recipe)orderImports, "\n            package org.bar;\n            \n            import static com.foo.B.*;\n            \n            class C {\n                void bar() {\n                    foo();\n                    bar();\n                    baz();\n                    foo2();\n                    bar2();\n                    baz2();\n                }\n            }\n        ", stringArray2);
        }

        @Test
        public static void preservesStaticMethodArguments(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports(true);
            String[] stringArray = new String[]{"\n                package com.foo;\n                \n                public class A {\n                    public static void foo(String bar) {}\n                    public static String stringify(Integer baz) { return baz.toString(); }\n                    public static Integer numberOne() { return 1; }\n                    public static Integer plusOne(Integer n) { return n + 1; }\n                    public static Integer timesTwo(Integer n) { return n * 2; }\n                    public static Integer numberTwo() { return 2; }\n                }\n            "};
            String[] stringArray2 = stringArray;
            this_.assertUnchanged(jp, (Recipe)orderImports, "\n            package org.bar;\n            \n            import static com.foo.A.*;\n            \n            class B {\n                void bar() {\n                    foo(stringify(numberOne()));\n                    timesTwo(plusOne(numberTwo()));\n                }\n            }\n        ", stringArray2);
        }

        @Test
        public static void preservesDifferentStaticImportsFromSamePackage(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports(true);
            String[] stringArray = new String[]{OrderImportsTest.a, OrderImportsTest.b};
            String[] stringArray2 = stringArray;
            this_.assertUnchanged(jp, (Recipe)orderImports, "\n            package org.bar;\n            \n            import static com.foo.A.one;\n            import static com.foo.A.plusOne;\n            import static com.foo.B.multiply;\n            import static com.foo.B.two;\n            \n            public class C {\n                void c() {\n                    multiply(plusOne(one()), two());\n                }\n            }\n        ", stringArray2);
        }

        @Test
        public static void collapsesDifferentStaticImportsFromSamePackage(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports(true);
            String[] stringArray = new String[]{OrderImportsTest.a, OrderImportsTest.b};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)orderImports, "\n            package org.bar;\n            \n            import static com.foo.A.one;\n            import static com.foo.A.plusOne;\n            import static com.foo.A.three;\n            import static com.foo.B.multiply;\n            import static com.foo.B.two;\n            import static com.foo.B.four;\n            \n            public class C {\n                void c() {\n                    multiply(plusOne(one()), two());\n                    three();\n                    four();\n                }\n            }\n        ", stringArray2, "\n            package org.bar;\n            \n            import static com.foo.A.*;\n            import static com.foo.B.*;\n            \n            public class C {\n                void c() {\n                    multiply(plusOne(one()), two());\n                    three();\n                    four();\n                }\n            }\n        ", 0, 0, false, null, 480, null);
        }

        @Test
        public static void removesRedundantImports(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{OrderImportsTest.a, OrderImportsTest.b};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            package org.bar;\n            \n            import com.foo.B;\n            import com.foo.B;\n            \n            import static com.foo.A.one;\n            import static com.foo.A.one;\n            \n            public class C {\n                void c() {\n                    one();\n                    B.two();\n                }\n            }\n        ", stringArray2, "\n            package org.bar;\n            \n            import com.foo.B;\n            \n            import static com.foo.A.one;\n            \n            public class C {\n                void c() {\n                    one();\n                    B.two();\n                }\n            }\n        ", 0, 0, false, null, 482, null);
        }

        @Test
        public static void blankLinesBetweenImports(@NotNull OrderImportsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            ImportLayoutStyle importLayoutStyle = ImportLayoutStyle.builder().classCountToUseStarImport(9999).nameCountToUseStarImport(9999).importStaticAllOthers().blankLine().importAllOthers().blankLine().build();
            if (importLayoutStyle == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.style.Style");
            }
            JavaParser javaParser = jp.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "custom", "custom style", null, SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)((Style)importLayoutStyle))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(\n            listOf(\n                NamedStyles(\n                    randomId(),\n                    \"custom\",\n                    \"custom style\",\n                    null,\n                    emptySet(),\n                    listOf(\n                        ImportLayoutStyle.builder()\n                            .classCountToUseStarImport(9999)\n                            .nameCountToUseStarImport(9999)\n                            .importStaticAllOthers()\n                            .blankLine()\n                            .importAllOthers()\n                            .blankLine()\n                            .build() as Style\n                    )\n                )\n            )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, "\n            import java.util.List;\n            import static java.util.Collections.singletonList;\n            class Test {\n            }\n        ", null, "\n            import static java.util.Collections.singletonList;\n            \n            import java.util.List;\n            \n            class Test {\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void groupImportsIsAwareOfNestedClasses(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.abc;\n            public class A {}\n            public class B {}\n            public class C {}\n            public class D {}\n            public class E {}\n            public class F {}\n            public class G {}\n            public class H {\n                public class H1 {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "package org.bar;\n\nimport org.abc.A;\nimport org.abc.B;\nimport org.abc.C;\nimport org.abc.D;\nimport org.abc.E;\nimport org.abc.F;\nimport org.abc.G;\nimport org.abc.H;\nimport org.abc.H.H1;\nimport java.util.Arrays;\nimport java.util.List;\n\npublic class C {\n    void c() {\n        List l = Arrays.asList(new A(), new B(), new C(), new D(), new E(), new F(), new G(), new H(), new H1());\n    }\n}", stringArray2, "package org.bar;\n\nimport org.abc.*;\nimport org.abc.H.H1;\n\nimport java.util.Arrays;\nimport java.util.List;\n\npublic class C {\n    void c() {\n        List l = Arrays.asList(new A(), new B(), new C(), new D(), new E(), new F(), new G(), new H(), new H1());\n    }\n}", 0, 0, false, null, 482, null);
        }

        @Test
        public static void detectBlockPattern(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            package org.bar;\n            \n            // org.slf4j should be detected as a block pattern, and not be moved to all other imports.\n            import org.slf4j.Logger;\n            import org.slf4j.LoggerFactory;\n            \n            import java.util.Arrays;\n            import java.util.List;\n            \n            public class C {\n            }\n        ", null, 10, null);
        }

        @Test
        public static void doNotFoldImports(@NotNull OrderImportsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            ImportLayoutStyle importLayoutStyle = ImportLayoutStyle.builder().classCountToUseStarImport(Integer.MAX_VALUE).nameCountToUseStarImport(Integer.MAX_VALUE).importPackage("java.*").blankLine().importPackage("javax.*").blankLine().importAllOthers().blankLine().importStaticAllOthers().build();
            if (importLayoutStyle == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.style.Style");
            }
            JavaParser javaParser = jp.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "custom", "custom style", null, SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)((Style)importLayoutStyle))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(\n            listOf(\n                NamedStyles(\n                    randomId(),\n                    \"custom\",\n                    \"custom style\",\n                    null,\n                    emptySet(),\n                    listOf(\n                        ImportLayoutStyle.builder()\n                            .classCountToUseStarImport(2147483647)\n                            .nameCountToUseStarImport(2147483647)\n                            .importPackage(\"java.*\")\n                            .blankLine()\n                            .importPackage(\"javax.*\")\n                            .blankLine()\n                            .importAllOthers()\n                            .blankLine()\n                            .importStaticAllOthers()\n                            .build() as Style\n                    )\n                )\n            )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, "\n            package org.bar;\n            \n            import java.util.ArrayList;\n            import java.util.Collections;\n            import java.util.HashSet;\n            import java.util.List;\n            import java.util.Set;\n            \n            import javax.persistence.Entity;\n            import javax.persistence.FetchType;\n            import javax.persistence.JoinColumn;\n            import javax.persistence.JoinTable;\n            import javax.persistence.ManyToMany;\n            import javax.persistence.Table;\n            \n            public class C {\n            }\n        ", null, 10, null);
        }

        public static void assertChangedBase(@NotNull OrderImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull OrderImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull OrderImportsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull OrderImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull OrderImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, boolean skipEnhancedTypeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, skipEnhancedTypeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull OrderImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, boolean skipEnhancedTypeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, skipEnhancedTypeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull OrderImportsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull OrderImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull OrderImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull OrderImportsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull OrderImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull OrderImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull OrderImportsTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull OrderImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull OrderImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull OrderImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

