/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.cleanup.DefaultComesLast;
import org.openrewrite.java.cleanup.DefaultComesLastStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.NamedStyles;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\u0010\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011H\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lorg/openrewrite/java/cleanup/DefaultComesLastTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "allCasesGroupedWithDefault", "", "jp", "Lorg/openrewrite/java/JavaParser;", "defaultIsLastAndReturnsNonVoid", "defaultIsLastAndThrows", "dontAddBreaksIfCasesArentMoving", "dontRemoveExtraneousDefaultCaseBreaks", "moveDefaultToLastAlongWithItsStatementsAndAddBreakIfNecessary", "moveDefaultToLastWhenSharedWithAnotherCaseStatement", "skipIfLastAndSharedWithCase", "Lorg/openrewrite/java/JavaParser$Builder;", "rewrite-test"})
public interface DefaultComesLastTest
extends JavaRecipeTest {
    @Override
    @Nullable
    public Recipe getRecipe();

    @Test
    public void moveDefaultToLastAlongWithItsStatementsAndAddBreakIfNecessary(@NotNull JavaParser var1);

    @Test
    public void moveDefaultToLastWhenSharedWithAnotherCaseStatement(@NotNull JavaParser var1);

    @Test
    public void skipIfLastAndSharedWithCase(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void defaultIsLastAndThrows(@NotNull JavaParser var1);

    @Test
    public void defaultIsLastAndReturnsNonVoid(@NotNull JavaParser var1);

    @Test
    public void dontAddBreaksIfCasesArentMoving(@NotNull JavaParser var1);

    @Test
    public void dontRemoveExtraneousDefaultCaseBreaks(@NotNull JavaParser var1);

    @Test
    public void allCasesGroupedWithDefault(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull DefaultComesLastTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new DefaultComesLast();
        }

        @Test
        public static void moveDefaultToLastAlongWithItsStatementsAndAddBreakIfNecessary(@NotNull DefaultComesLastTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            class Test {\n                int n;\n                {\n                    switch (n) {\n                        case 1:\n                            break;\n                        case 2:\n                            break;\n                        default:\n                            System.out.println(\"default\");\n                            break;\n                        case 3:\n                            System.out.println(\"case3\");\n                    }\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                {\n                    switch (n) {\n                        case 1:\n                            break;\n                        case 2:\n                            break;\n                        case 3:\n                            System.out.println(\"case3\");\n                            break;\n                        default:\n                            System.out.println(\"default\");\n                    }\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void moveDefaultToLastWhenSharedWithAnotherCaseStatement(@NotNull DefaultComesLastTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            class Test {\n                int n;\n                {\n                    switch (n) {\n                        case 1:\n                            break;\n                        case 2:\n                            break;\n                        case 3:\n                        default:\n                            break;\n                        case 4:\n                        case 5:\n                    }\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                {\n                    switch (n) {\n                        case 1:\n                            break;\n                        case 2:\n                            break;\n                        case 4:\n                        case 5:\n                            break;\n                        case 3:\n                        default:\n                    }\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void skipIfLastAndSharedWithCase(@NotNull DefaultComesLastTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)new DefaultComesLastStyle(Boolean.valueOf(true)))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(\n            listOf(\n                NamedStyles(\n                    Tree.randomId(), \"test\", \"test\", \"test\", emptySet(),\n                    listOf(DefaultComesLastStyle(true))\n                )\n            )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, "\n            class Test {\n                int n;\n                {\n                    switch (n) {\n                        case 1:\n                            break;\n                        case 2:\n                        default:\n                            break;\n                        case 3:\n                            break;\n                    }\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void defaultIsLastAndThrows(@NotNull DefaultComesLastTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            class Test {\n                int n;\n                {\n                    switch (n) {\n                        case 1:\n                            break;\n                        default:\n                            throw new RuntimeException(\"unexpected value\");\n                    }\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void defaultIsLastAndReturnsNonVoid(@NotNull DefaultComesLastTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            class Test {\n                public int foo(int n) {\n                    switch (n) {\n                        case 1:\n                            return 1;\n                        default:\n                            return 2;\n                    }\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void dontAddBreaksIfCasesArentMoving(@NotNull DefaultComesLastTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            class Test {\n                int n;\n                boolean foo() {\n                    switch (n) {\n                        case 1:\n                        case 2:\n                            System.out.println(\"side effect\");\n                        default:\n                            return true;\n                    }\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void dontRemoveExtraneousDefaultCaseBreaks(@NotNull DefaultComesLastTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            class Test {\n                int n;\n                void foo() {\n                    switch (n) {\n                        default:\n                            break;\n                    }\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void allCasesGroupedWithDefault(@NotNull DefaultComesLastTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            class Test {\n                int n;\n                boolean foo() {\n                    switch (n) {\n                        case 1:\n                        case 2:\n                        default:\n                            return true;\n                    }\n                }\n            }\n        ", null, 10, null);
        }

        public static void assertChangedBase(@NotNull DefaultComesLastTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull DefaultComesLastTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull DefaultComesLastTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull DefaultComesLastTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull DefaultComesLastTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, boolean skipEnhancedTypeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, skipEnhancedTypeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull DefaultComesLastTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, boolean skipEnhancedTypeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, skipEnhancedTypeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull DefaultComesLastTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull DefaultComesLastTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull DefaultComesLastTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull DefaultComesLastTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull DefaultComesLastTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull DefaultComesLastTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull DefaultComesLastTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull DefaultComesLastTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull DefaultComesLastTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull DefaultComesLastTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

