/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTreeTest;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/tree/NewClassTest;", "Lorg/openrewrite/java/JavaTreeTest;", "anonymousInnerClass", "", "jp", "Lorg/openrewrite/java/JavaParser;", "concreteClassWithParams", "concreteInnerClass", "rawType", "rewrite-test"})
public interface NewClassTest
extends JavaTreeTest {
    @Test
    public void anonymousInnerClass(@NotNull JavaParser var1);

    @Test
    public void concreteInnerClass(@NotNull JavaParser var1);

    @Test
    public void concreteClassWithParams(@NotNull JavaParser var1);

    @Test
    public void rawType(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void anonymousInnerClass(@NotNull NewClassTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            class A { static class B {} }\n            class C {\n                A.B anonB = new A.B() {};\n            }\n        ", new String[0]);
        }

        @Test
        public static void concreteInnerClass(@NotNull NewClassTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            class A { static class B {} }\n            class C {\n                A.B anonB = new A.B();\n            }\n        ", new String[0]);
        }

        @Test
        public static void concreteClassWithParams(@NotNull NewClassTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"java.util.*"};
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            Object l = new ArrayList < String > ( 0 ) { };\n        ", stringArray);
        }

        @Test
        public static void rawType(@NotNull NewClassTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"java.util.*"};
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            List<String> l = new ArrayList < > ();\n        ", stringArray);
        }
    }
}

