/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.sun.net.httpserver.HttpServer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.lang.Nullable;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.time.Duration;

public class MetricsDestinations {
    public static PrometheusMeterRegistry prometheus() {
        PrometheusMeterRegistry prometheusRegistry = new PrometheusMeterRegistry(new PrometheusConfig(){

            public Duration step() {
                return Duration.ofSeconds(10L);
            }

            @Nullable
            public String get(String k) {
                return null;
            }
        });
        try {
            HttpServer server = HttpServer.create(new InetSocketAddress(8080), 0);
            server.createContext("/prometheus", httpExchange -> {
                String response = prometheusRegistry.scrape();
                httpExchange.sendResponseHeaders(200, response.length());
                OutputStream os = httpExchange.getResponseBody();
                os.write(response.getBytes());
                os.close();
            });
            Thread serverThread = new Thread(server::start);
            serverThread.setDaemon(true);
            serverThread.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        new JvmHeapPressureMetrics().bindTo((MeterRegistry)prometheusRegistry);
        new ProcessorMetrics().bindTo((MeterRegistry)prometheusRegistry);
        new JvmGcMetrics().bindTo((MeterRegistry)prometheusRegistry);
        new FileDescriptorMetrics().bindTo((MeterRegistry)prometheusRegistry);
        Metrics.addRegistry((MeterRegistry)prometheusRegistry);
        return prometheusRegistry;
    }
}

