/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTreeTest;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/tree/MemberReferenceTest;", "Lorg/openrewrite/java/JavaTreeTest;", "constructorMethodReference", "", "jp", "Lorg/openrewrite/java/JavaParser;", "memberReferenceWithTypeParameter", "staticFunctionReference", "unknownDeclaringType", "rewrite-test"})
public interface MemberReferenceTest
extends JavaTreeTest {
    @Test
    public void unknownDeclaringType(@NotNull JavaParser var1);

    @Test
    public void memberReferenceWithTypeParameter(@NotNull JavaParser var1);

    @Test
    public void staticFunctionReference(@NotNull JavaParser var1);

    @Test
    public void constructorMethodReference(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void unknownDeclaringType(@NotNull MemberReferenceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            package com.company.pkg;\n\n            import java.util.concurrent.CompletableFuture;\n            import java.util.stream.Collectors;\n            import java.util.stream.Stream;\n            import com.company.pkg.UnknownClass;\n\n            public class ReproduceParserIssue {\n\n              public static void main(String[] args) {\n                CompletableFuture.supplyAsync(\n                    () -> {\n                      return Stream.empty()\n                          .map(UnknownClass::valueOf) \n                          .collect(Collectors.toList());\n                    });\n              }\n            }\n        ", new String[0]);
        }

        @Test
        public static void memberReferenceWithTypeParameter(@NotNull MemberReferenceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.List;\n            import java.util.Map;\n            import java.util.Set;\n            import java.util.function.Function;\n            import java.util.stream.Collector;\n            import java.util.stream.Collectors;\n            \n            public class Sample {\n            \n                private void foo(List<Criteria> request) {\n                    Set<Id<Criteria>> allCriteria = request.stream()\n                            .map(Id::<Criteria>of)\n                            .collect(Collectors.toSet());\n                    allCriteria = request.stream()\n                            .map(Id/**yo**/::/**hola**/<Criteria>/**hello**/of)\n                            .collect(Collectors.toSet());\n                            \n                    List<String> result = allCriteria.stream()\n                            .map(Sample::idToString)\n                            .collect(Collectors.toList());\n                }\n            \n                public static <T, K, V> Collector<T, ?, Map<K, V>> toImmutableMap(\n                        Function<? super T, ? extends K> keyFunction,\n                        Function<? super T, ? extends V> valueFunction) {\n                    return null;\n                }\n                private static String idToString(Id id) {\n                    return id.toString();\n                }\n                private class Id<T> {\n                    static <Y> Id<Y> of(Y thing) {\n                        return null;\n                    }\n                }\n            \n                private class Criteria {\n                    Long getId() {\n                        return null;\n                    }\n                }\n            }\n        ", new String[0]);
        }

        @Test
        public static void staticFunctionReference(@NotNull MemberReferenceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.stream.Stream;\n\n            public class StaticLambdaRef {\n                void test() {\n                    Stream.of(\"s\").forEach(A :: func);\n                }\n            }\n\n            class A {\n                static void func(String s) {}\n            }\n        ", new String[0]);
        }

        @Test
        public static void constructorMethodReference(@NotNull MemberReferenceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"java.util.*", "java.util.stream.*"};
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            Stream<Integer> n = Stream.of(1, 2);\n            Set<Integer> n2 = n.collect(HashSet < Integer > :: new, HashSet :: add);\n        ", stringArray);
        }
    }
}

