/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Maintainer;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class AdHocRecipe
extends ScanningRecipe<Void> {
    @Nullable
    @Language(value="markdown")
    private final String displayName;
    @Nullable
    private final String name;
    @Nullable
    private final Boolean causesAnotherCycle;
    private final Supplier<TreeVisitor<?, ExecutionContext>> getVisitor;
    @Nullable
    private final Supplier<Collection<SourceFile>> generator;
    @Nullable
    private final List<Maintainer> maintainers;
    @Nullable
    private final Integer maxCycles;

    public String getDisplayName() {
        return StringUtils.isBlank((String)this.displayName) ? "Ad hoc recipe" : this.displayName;
    }

    public String getDescription() {
        return "An ad hoc recipe used in RewriteTest.";
    }

    public String getName() {
        return StringUtils.isBlank((String)this.name) ? super.getName() : this.name;
    }

    public boolean causesAnotherCycle() {
        return this.causesAnotherCycle == null ? super.causesAnotherCycle() : this.causesAnotherCycle.booleanValue();
    }

    public int maxCycles() {
        return this.maxCycles == null ? super.maxCycles() : this.maxCycles.intValue();
    }

    public List<Maintainer> getMaintainers() {
        return this.maintainers == null ? Collections.emptyList() : this.maintainers;
    }

    public Void getInitialValue(ExecutionContext ctx) {
        return null;
    }

    public TreeVisitor<?, ExecutionContext> getScanner(Void acc) {
        return TreeVisitor.noop();
    }

    public Collection<? extends SourceFile> generate(Void acc, ExecutionContext ctx) {
        return this.generator == null ? Collections.emptyList() : this.generator.get();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Void acc) {
        return this.getVisitor.get();
    }

    public AdHocRecipe(@Nullable @Language(value="markdown") String displayName, @Nullable String name, @Nullable Boolean causesAnotherCycle, Supplier<TreeVisitor<?, ExecutionContext>> getVisitor, @Nullable Supplier<Collection<SourceFile>> generator, @Nullable List<Maintainer> maintainers, @Nullable Integer maxCycles) {
        this.displayName = displayName;
        this.name = name;
        this.causesAnotherCycle = causesAnotherCycle;
        this.getVisitor = getVisitor;
        this.generator = generator;
        this.maintainers = maintainers;
        this.maxCycles = maxCycles;
    }

    @Nullable
    public Boolean getCausesAnotherCycle() {
        return this.causesAnotherCycle;
    }

    public Supplier<TreeVisitor<?, ExecutionContext>> getGetVisitor() {
        return this.getVisitor;
    }

    @Nullable
    public Supplier<Collection<SourceFile>> getGenerator() {
        return this.generator;
    }

    @Nullable
    public Integer getMaxCycles() {
        return this.maxCycles;
    }

    @NonNull
    public String toString() {
        return "AdHocRecipe(displayName=" + this.getDisplayName() + ", name=" + this.getName() + ", causesAnotherCycle=" + this.getCausesAnotherCycle() + ", getVisitor=" + this.getGetVisitor() + ", generator=" + this.getGenerator() + ", maintainers=" + this.getMaintainers() + ", maxCycles=" + this.getMaxCycles() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdHocRecipe)) {
            return false;
        }
        AdHocRecipe other = (AdHocRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$causesAnotherCycle = this.getCausesAnotherCycle();
        Boolean other$causesAnotherCycle = other.getCausesAnotherCycle();
        if (this$causesAnotherCycle == null ? other$causesAnotherCycle != null : !((Object)this$causesAnotherCycle).equals(other$causesAnotherCycle)) {
            return false;
        }
        Integer this$maxCycles = this.getMaxCycles();
        Integer other$maxCycles = other.getMaxCycles();
        if (this$maxCycles == null ? other$maxCycles != null : !((Object)this$maxCycles).equals(other$maxCycles)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Supplier<TreeVisitor<?, ExecutionContext>> this$getVisitor = this.getGetVisitor();
        Supplier<TreeVisitor<?, ExecutionContext>> other$getVisitor = other.getGetVisitor();
        if (this$getVisitor == null ? other$getVisitor != null : !this$getVisitor.equals(other$getVisitor)) {
            return false;
        }
        Supplier<Collection<SourceFile>> this$generator = this.getGenerator();
        Supplier<Collection<SourceFile>> other$generator = other.getGenerator();
        if (this$generator == null ? other$generator != null : !this$generator.equals(other$generator)) {
            return false;
        }
        List<Maintainer> this$maintainers = this.getMaintainers();
        List<Maintainer> other$maintainers = other.getMaintainers();
        return !(this$maintainers == null ? other$maintainers != null : !((Object)this$maintainers).equals(other$maintainers));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AdHocRecipe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $causesAnotherCycle = this.getCausesAnotherCycle();
        result = result * 59 + ($causesAnotherCycle == null ? 43 : ((Object)$causesAnotherCycle).hashCode());
        Integer $maxCycles = this.getMaxCycles();
        result = result * 59 + ($maxCycles == null ? 43 : ((Object)$maxCycles).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Supplier<TreeVisitor<?, ExecutionContext>> $getVisitor = this.getGetVisitor();
        result = result * 59 + ($getVisitor == null ? 43 : $getVisitor.hashCode());
        Supplier<Collection<SourceFile>> $generator = this.getGenerator();
        result = result * 59 + ($generator == null ? 43 : $generator.hashCode());
        List<Maintainer> $maintainers = this.getMaintainers();
        result = result * 59 + ($maintainers == null ? 43 : ((Object)$maintainers).hashCode());
        return result;
    }

    @NonNull
    public AdHocRecipe withDisplayName(@Nullable @Language(value="markdown") String displayName) {
        return this.displayName == displayName ? this : new AdHocRecipe(displayName, this.name, this.causesAnotherCycle, this.getVisitor, this.generator, this.maintainers, this.maxCycles);
    }

    @NonNull
    public AdHocRecipe withName(@Nullable String name) {
        return this.name == name ? this : new AdHocRecipe(this.displayName, name, this.causesAnotherCycle, this.getVisitor, this.generator, this.maintainers, this.maxCycles);
    }

    @NonNull
    public AdHocRecipe withCausesAnotherCycle(@Nullable Boolean causesAnotherCycle) {
        return this.causesAnotherCycle == causesAnotherCycle ? this : new AdHocRecipe(this.displayName, this.name, causesAnotherCycle, this.getVisitor, this.generator, this.maintainers, this.maxCycles);
    }

    @NonNull
    public AdHocRecipe withGetVisitor(Supplier<TreeVisitor<?, ExecutionContext>> getVisitor) {
        return this.getVisitor == getVisitor ? this : new AdHocRecipe(this.displayName, this.name, this.causesAnotherCycle, getVisitor, this.generator, this.maintainers, this.maxCycles);
    }

    @NonNull
    public AdHocRecipe withGenerator(@Nullable Supplier<Collection<SourceFile>> generator) {
        return this.generator == generator ? this : new AdHocRecipe(this.displayName, this.name, this.causesAnotherCycle, this.getVisitor, generator, this.maintainers, this.maxCycles);
    }

    @NonNull
    public AdHocRecipe withMaintainers(@Nullable List<Maintainer> maintainers) {
        return this.maintainers == maintainers ? this : new AdHocRecipe(this.displayName, this.name, this.causesAnotherCycle, this.getVisitor, this.generator, maintainers, this.maxCycles);
    }

    @NonNull
    public AdHocRecipe withMaxCycles(@Nullable Integer maxCycles) {
        return this.maxCycles == maxCycles ? this : new AdHocRecipe(this.displayName, this.name, this.causesAnotherCycle, this.getVisitor, this.generator, this.maintainers, maxCycles);
    }
}

