/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.InMemoryLargeSourceSet;
import org.openrewrite.quark.Quark;

class LargeSourceSetCheckingExpectedCycles
extends InMemoryLargeSourceSet {
    private final int expectedCyclesThatMakeChanges;
    private int cyclesThatResultedInChanges = 0;
    private Map<Path, SourceFile> lastCycleChanges = Collections.emptyMap();

    LargeSourceSetCheckingExpectedCycles(int expectedCyclesThatMakeChanges, List<SourceFile> ls) {
        super(ls);
        this.expectedCyclesThatMakeChanges = expectedCyclesThatMakeChanges;
    }

    public void afterCycle(boolean lastCycle) {
        boolean detectedChangeInThisCycle = false;
        HashMap<Path, SourceFile> thisCycleChanges = new HashMap<Path, SourceFile>();
        for (Result result : this.getChangeset().getAllResults()) {
            SourceFile before = result.getBefore() == null ? (result.getAfter() == null ? null : this.lastCycleChanges.get(result.getAfter().getSourcePath())) : this.lastCycleChanges.getOrDefault(result.getBefore().getSourcePath(), result.getBefore());
            SourceFile after = result.getAfter();
            if (before != null && after != null && !(after instanceof Quark)) {
                if (!detectedChangeInThisCycle) {
                    detectedChangeInThisCycle = true;
                    ++this.cyclesThatResultedInChanges;
                }
                if (this.cyclesThatResultedInChanges > this.expectedCyclesThatMakeChanges) {
                    ((AbstractStringAssert)Assertions.assertThat((String)after.printAllTrimmed()).as("Expected recipe to complete in " + this.expectedCyclesThatMakeChanges + " cycle" + (this.expectedCyclesThatMakeChanges == 1 ? "" : "s") + ", but took at least one more cycle. Between the last two executed cycles there were changes to \"" + before.getSourcePath() + "\"", new Object[0])).isEqualTo(before.printAllTrimmed());
                }
            }
            if (result.getAfter() == null) continue;
            thisCycleChanges.put(result.getAfter().getSourcePath(), result.getAfter());
        }
        this.lastCycleChanges = thisCycleChanges;
        if (lastCycle) {
            if (this.cyclesThatResultedInChanges == 0 && this.expectedCyclesThatMakeChanges > 0) {
                Assertions.fail((String)"Recipe was expected to make a change but made no changes.");
            } else if (this.cyclesThatResultedInChanges != this.expectedCyclesThatMakeChanges) {
                Assertions.fail((String)("Expected recipe to complete in " + this.expectedCyclesThatMakeChanges + " cycle" + (this.expectedCyclesThatMakeChanges > 1 ? "s" : "") + ", but took " + this.cyclesThatResultedInChanges + " cycle" + (this.cyclesThatResultedInChanges > 1 ? "s" : "") + ". This usually indicates the recipe is making changes after it should have stabilized."));
            }
        }
    }
}

