/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;

class ParserTypeUtils {
    private ParserTypeUtils() {
    }

    public static Class<SourceFile> parserType(Parser parser) {
        return ParserTypeUtils.parserType(parser.getClass());
    }

    private static Class<SourceFile> parserType(Class<?> parser) {
        for (Type anInterface : parser.getGenericInterfaces()) {
            ParameterizedType pt;
            if (anInterface instanceof Class) {
                return ParserTypeUtils.parserType((Class)anInterface);
            }
            if (!(anInterface instanceof ParameterizedType) || !(pt = (ParameterizedType)anInterface).getRawType().equals(Parser.class)) continue;
            return (Class)pt.getActualTypeArguments()[0];
        }
        throw new IllegalArgumentException("Could not determine SourceFile type for this parser.");
    }
}

