/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.config.MeterFilter;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openrewrite.internal.LoggingMeterRegistry;

public class MetricsExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final String METER_REGISTRY = "loggingMeterRegistry";

    public void beforeTestExecution(ExtensionContext context) {
        LoggingMeterRegistry meterRegistry = LoggingMeterRegistry.builder().build();
        meterRegistry.config().meterFilter(MeterFilter.ignoreTags((String[])new String[]{"repo.id", "exception.line", "exception.declaring.class", "exception", "step"}));
        Metrics.addRegistry((MeterRegistry)meterRegistry);
        this.getStore(context).put((Object)METER_REGISTRY, (Object)meterRegistry);
    }

    public void afterTestExecution(ExtensionContext context) {
        LoggingMeterRegistry meterRegistry = (LoggingMeterRegistry)this.getStore(context).remove((Object)METER_REGISTRY, LoggingMeterRegistry.class);
        meterRegistry.print();
        Metrics.removeRegistry((MeterRegistry)meterRegistry);
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getRequiredTestMethod()}));
    }
}

