/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markers;
import org.openrewrite.toml.tree.Space;
import org.openrewrite.toml.tree.Toml;

public class TomlRightPadded<T> {
    private final T element;
    private final Space after;
    private final Markers markers;

    public TomlRightPadded<T> map(UnaryOperator<T> map) {
        return this.withElement(map.apply(this.element));
    }

    public static <T> List<T> getElements(List<TomlRightPadded<T>> ls) {
        ArrayList<T> list = new ArrayList<T>();
        for (TomlRightPadded<T> l : ls) {
            T elem = l.getElement();
            list.add(elem);
        }
        return list;
    }

    public static <P extends Toml> List<TomlRightPadded<P>> withElements(List<TomlRightPadded<P>> before, List<P> elements) {
        if (elements.size() == before.size()) {
            boolean hasChanges = false;
            for (int i = 0; i < before.size(); ++i) {
                if (before.get(i).getElement() == elements.get(i)) continue;
                hasChanges = true;
                break;
            }
            if (!hasChanges) {
                return before;
            }
        }
        ArrayList<TomlRightPadded<P>> after = new ArrayList<TomlRightPadded<P>>(elements.size());
        Map beforeById = before.stream().collect(Collectors.toMap(j -> ((Toml)j.getElement()).getId(), Function.identity()));
        for (Toml t : elements) {
            if (beforeById.get(t.getId()) != null) {
                TomlRightPadded found = (TomlRightPadded)beforeById.get(t.getId());
                after.add(found.withElement(t));
                continue;
            }
            after.add(new TomlRightPadded<Toml>(t, Space.EMPTY, Markers.EMPTY));
        }
        return after;
    }

    public static <T> TomlRightPadded<T> build(T element) {
        return new TomlRightPadded<T>(element, Space.EMPTY, Markers.EMPTY);
    }

    public static <T> @Nullable TomlRightPadded<T> withElement(@Nullable TomlRightPadded<T> before, @Nullable T elements) {
        if (before == null) {
            if (elements == null) {
                return null;
            }
            return new TomlRightPadded<T>(elements, Space.EMPTY, Markers.EMPTY);
        }
        if (elements == null) {
            return null;
        }
        return before.withElement(elements);
    }

    public String toString() {
        return "TomlRightPadded(element=" + this.element.getClass().getSimpleName() + ", after=" + this.after + ')';
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TomlRightPadded)) {
            return false;
        }
        TomlRightPadded other = (TomlRightPadded)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof TomlRightPadded;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public TomlRightPadded(T element, Space after, Markers markers) {
        this.element = element;
        this.after = after;
        this.markers = markers;
    }

    @Generated
    public T getElement() {
        return this.element;
    }

    @Generated
    public Space getAfter() {
        return this.after;
    }

    @Generated
    public Markers getMarkers() {
        return this.markers;
    }

    @NonNull
    @Generated
    public TomlRightPadded<T> withElement(T element) {
        return this.element == element ? this : new TomlRightPadded<T>(element, this.after, this.markers);
    }

    @NonNull
    @Generated
    public TomlRightPadded<T> withAfter(Space after) {
        return this.after == after ? this : new TomlRightPadded<T>(this.element, after, this.markers);
    }

    @NonNull
    @Generated
    public TomlRightPadded<T> withMarkers(Markers markers) {
        return this.markers == markers ? this : new TomlRightPadded<T>(this.element, this.after, markers);
    }
}

