/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.internal;

import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.YamlSourceVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class PrintYaml
extends YamlSourceVisitor<String> {
    public String defaultTo(Tree t) {
        return "";
    }

    public String reduce(String r1, String r2) {
        return r1 + r2;
    }

    @Override
    public String visitDocument(Yaml.Document document) {
        return this.fmt(document, (document.isExplicit() ? "---" : "") + (String)this.visit(document.getBlocks()));
    }

    @Override
    public String visitSequenceEntry(Yaml.Sequence.Entry entry) {
        return this.fmt(entry, "-" + (String)this.visit(entry.getBlock()));
    }

    @Override
    public String visitMappingEntry(Yaml.Mapping.Entry entry) {
        return this.fmt(entry, (String)this.visit(entry.getKey()) + ":" + (String)this.visit(entry.getValue()));
    }

    @Override
    public String visitScalar(Yaml.Scalar scalar) {
        String value;
        switch (scalar.getStyle()) {
            case DOUBLE_QUOTED: {
                value = "\"" + scalar.getValue() + "\"";
                break;
            }
            case SINGLE_QUOTED: {
                value = "'" + scalar.getValue() + "'";
                break;
            }
            case LITERAL: {
                value = "|" + scalar.getValue();
                break;
            }
            case FOLDED: {
                value = ">" + scalar.getValue();
                break;
            }
            default: {
                value = scalar.getValue();
            }
        }
        return this.fmt(scalar, value);
    }

    private String fmt(@Nullable Tree tree, @Nullable String code) {
        return tree == null || code == null ? "" : tree.getPrefix() + code + tree.getSuffix();
    }
}

