/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.Metadata;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.YamlSourceVisitor;
import org.openrewrite.yaml.internal.PrintYaml;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface Yaml
extends Serializable,
Tree {
    default public String print() {
        return (String)new PrintYaml().visit(this);
    }

    default public String printTrimmed() {
        int i;
        String print = this.print();
        for (i = 0; i < print.toCharArray().length && (print.charAt(i) == '\n' || print.charAt(i) == '\r'); ++i) {
        }
        return (print = print.substring(i)).isEmpty() || !Character.isWhitespace(print.charAt(0)) ? print : StringUtils.trimIndent((String)print.trim());
    }

    default public <R> R accept(SourceVisitor<R> v) {
        return (R)(v instanceof YamlSourceVisitor ? this.acceptYaml((YamlSourceVisitor)v) : v.defaultTo(null));
    }

    default public <R> R acceptYaml(YamlSourceVisitor<R> v) {
        return (R)v.defaultTo(null);
    }

    public Yaml copyPaste();

    public static interface Block
    extends Yaml {
        @Override
        public Block copyPaste();
    }

    public static class Sequence
    implements Block {
        private final UUID id;
        private final List<Entry> entries;
        private final Formatting formatting;

        @Override
        public <R> R acceptYaml(YamlSourceVisitor<R> v) {
            return v.visitSequence(this);
        }

        @Override
        public Sequence copyPaste() {
            return new Sequence(Tree.randomId(), this.entries.stream().map(Entry::copyPaste).collect(Collectors.toList()), this.formatting);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sequence)) {
                return false;
            }
            Sequence other = (Sequence)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Sequence;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "entries", "formatting"})
        public Sequence(UUID id, List<Entry> entries, Formatting formatting) {
            this.id = id;
            this.entries = entries;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public List<Entry> getEntries() {
            return this.entries;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Yaml.Sequence(id=" + this.getId() + ", entries=" + this.getEntries() + ", formatting=" + this.getFormatting() + ")";
        }

        public Sequence withEntries(List<Entry> entries) {
            return this.entries == entries ? this : new Sequence(this.id, entries, this.formatting);
        }

        public Sequence withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Sequence(this.id, this.entries, formatting);
        }

        public static class Entry
        implements Yaml {
            private final UUID id;
            private final Block block;
            private final Formatting formatting;

            @Override
            public <R> R acceptYaml(YamlSourceVisitor<R> v) {
                return v.visitSequenceEntry(this);
            }

            @Override
            public Entry copyPaste() {
                return new Entry(Tree.randomId(), this.block.copyPaste(), this.formatting);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Entry;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "block", "formatting"})
            public Entry(UUID id, Block block, Formatting formatting) {
                this.id = id;
                this.block = block;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Block getBlock() {
                return this.block;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "Yaml.Sequence.Entry(id=" + this.getId() + ", block=" + this.getBlock() + ", formatting=" + this.getFormatting() + ")";
            }

            public Entry withBlock(Block block) {
                return this.block == block ? this : new Entry(this.id, block, this.formatting);
            }

            public Entry withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Entry(this.id, this.block, formatting);
            }
        }
    }

    public static class Mapping
    implements Block {
        private final UUID id;
        private final List<Entry> entries;
        private final Formatting formatting;

        @Override
        public <R> R acceptYaml(YamlSourceVisitor<R> v) {
            return v.visitMapping(this);
        }

        @Override
        public Mapping copyPaste() {
            return new Mapping(Tree.randomId(), this.entries.stream().map(Entry::copyPaste).collect(Collectors.toList()), this.formatting);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mapping)) {
                return false;
            }
            Mapping other = (Mapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Mapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "entries", "formatting"})
        public Mapping(UUID id, List<Entry> entries, Formatting formatting) {
            this.id = id;
            this.entries = entries;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public List<Entry> getEntries() {
            return this.entries;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Yaml.Mapping(id=" + this.getId() + ", entries=" + this.getEntries() + ", formatting=" + this.getFormatting() + ")";
        }

        public Mapping withEntries(List<Entry> entries) {
            return this.entries == entries ? this : new Mapping(this.id, entries, this.formatting);
        }

        public Mapping withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Mapping(this.id, this.entries, formatting);
        }

        public static class Entry
        implements Yaml {
            private final UUID id;
            private final Scalar key;
            private final Block value;
            private final Formatting formatting;

            @Override
            public <R> R acceptYaml(YamlSourceVisitor<R> v) {
                return v.visitMappingEntry(this);
            }

            @Override
            public Entry copyPaste() {
                return new Entry(Tree.randomId(), this.key.copyPaste(), this.value.copyPaste(), this.formatting);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Entry;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "key", "value", "formatting"})
            public Entry(UUID id, Scalar key, Block value, Formatting formatting) {
                this.id = id;
                this.key = key;
                this.value = value;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Scalar getKey() {
                return this.key;
            }

            public Block getValue() {
                return this.value;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "Yaml.Mapping.Entry(id=" + this.getId() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", formatting=" + this.getFormatting() + ")";
            }

            public Entry withKey(Scalar key) {
                return this.key == key ? this : new Entry(this.id, key, this.value, this.formatting);
            }

            public Entry withValue(Block value) {
                return this.value == value ? this : new Entry(this.id, this.key, value, this.formatting);
            }

            public Entry withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Entry(this.id, this.key, this.value, formatting);
            }
        }
    }

    public static class Scalar
    implements Block {
        private final UUID id;
        private final Style style;
        private final String value;
        private final Formatting formatting;

        @Override
        public <R> R acceptYaml(YamlSourceVisitor<R> v) {
            return v.visitScalar(this);
        }

        @Override
        public Scalar copyPaste() {
            return new Scalar(Tree.randomId(), this.style, this.value, this.formatting);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Scalar)) {
                return false;
            }
            Scalar other = (Scalar)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Scalar;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "style", "value", "formatting"})
        public Scalar(UUID id, Style style, String value, Formatting formatting) {
            this.id = id;
            this.style = style;
            this.value = value;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public Style getStyle() {
            return this.style;
        }

        public String getValue() {
            return this.value;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Yaml.Scalar(id=" + this.getId() + ", style=" + (Object)((Object)this.getStyle()) + ", value=" + this.getValue() + ", formatting=" + this.getFormatting() + ")";
        }

        public Scalar withStyle(Style style) {
            return this.style == style ? this : new Scalar(this.id, style, this.value, this.formatting);
        }

        public Scalar withValue(String value) {
            return this.value == value ? this : new Scalar(this.id, this.style, value, this.formatting);
        }

        public Scalar withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Scalar(this.id, this.style, this.value, formatting);
        }

        public static enum Style {
            DOUBLE_QUOTED,
            SINGLE_QUOTED,
            LITERAL,
            FOLDED,
            PLAIN;

        }
    }

    public static class Document
    implements Yaml {
        private final UUID id;
        private final boolean explicit;
        private final List<Block> blocks;
        @Nullable
        private final End end;
        private final Formatting formatting;

        @Override
        public <R> R acceptYaml(YamlSourceVisitor<R> v) {
            return v.visitDocument(this);
        }

        @Override
        public Document copyPaste() {
            return new Document(Tree.randomId(), this.explicit, this.blocks.stream().map(Block::copyPaste).collect(Collectors.toList()), this.end == null ? null : this.end.copyPaste(), this.formatting);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Document)) {
                return false;
            }
            Document other = (Document)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Document;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "explicit", "blocks", "end", "formatting"})
        public Document(UUID id, boolean explicit, List<Block> blocks, End end, Formatting formatting) {
            this.id = id;
            this.explicit = explicit;
            this.blocks = blocks;
            this.end = end;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public boolean isExplicit() {
            return this.explicit;
        }

        public List<Block> getBlocks() {
            return this.blocks;
        }

        public End getEnd() {
            return this.end;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Yaml.Document(id=" + this.getId() + ", explicit=" + this.isExplicit() + ", blocks=" + this.getBlocks() + ", end=" + this.getEnd() + ", formatting=" + this.getFormatting() + ")";
        }

        public Document withExplicit(boolean explicit) {
            return this.explicit == explicit ? this : new Document(this.id, explicit, this.blocks, this.end, this.formatting);
        }

        public Document withBlocks(List<Block> blocks) {
            return this.blocks == blocks ? this : new Document(this.id, this.explicit, blocks, this.end, this.formatting);
        }

        public Document withEnd(End end) {
            return this.end == end ? this : new Document(this.id, this.explicit, this.blocks, end, this.formatting);
        }

        public Document withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Document(this.id, this.explicit, this.blocks, this.end, formatting);
        }

        public static class End
        implements Yaml {
            private final UUID id;
            private final Formatting formatting;

            @Override
            public End copyPaste() {
                return new End(Tree.randomId(), this.formatting);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof End)) {
                    return false;
                }
                End other = (End)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof End;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "formatting"})
            public End(UUID id, Formatting formatting) {
                this.id = id;
                this.formatting = formatting;
            }

            public UUID getId() {
                return this.id;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public String toString() {
                return "Yaml.Document.End(id=" + this.getId() + ", formatting=" + this.getFormatting() + ")";
            }

            public End withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new End(this.id, formatting);
            }
        }
    }

    @JsonIgnoreProperties(value={"styles"})
    public static class Documents
    implements Yaml,
    SourceFile {
        private final UUID id;
        private final String sourcePath;
        private final Collection<Metadata> metadata;
        private final List<Document> documents;
        private final Formatting formatting;

        @Override
        public <R> R acceptYaml(YamlSourceVisitor<R> v) {
            return v.visitDocuments(this);
        }

        @Override
        public Documents copyPaste() {
            return new Documents(Tree.randomId(), this.sourcePath, this.metadata, this.documents.stream().map(Document::copyPaste).collect(Collectors.toList()), this.formatting);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Documents)) {
                return false;
            }
            Documents other = (Documents)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Documents;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "sourcePath", "metadata", "documents", "formatting"})
        public Documents(UUID id, String sourcePath, Collection<Metadata> metadata, List<Document> documents, Formatting formatting) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.metadata = metadata;
            this.documents = documents;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public Collection<Metadata> getMetadata() {
            return this.metadata;
        }

        public List<Document> getDocuments() {
            return this.documents;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Yaml.Documents(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", metadata=" + this.getMetadata() + ", documents=" + this.getDocuments() + ", formatting=" + this.getFormatting() + ")";
        }

        public Documents withMetadata(Collection<Metadata> metadata) {
            return this.metadata == metadata ? this : new Documents(this.id, this.sourcePath, metadata, this.documents, this.formatting);
        }

        public Documents withDocuments(List<Document> documents) {
            return this.documents == documents ? this : new Documents(this.id, this.sourcePath, this.metadata, documents, this.formatting);
        }

        public Documents withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Documents(this.id, this.sourcePath, this.metadata, this.documents, formatting);
        }
    }
}

