/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Formatting;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.FormatPreservingReader;
import org.openrewrite.yaml.tree.Yaml;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Scanner;
import org.yaml.snakeyaml.scanner.ScannerImpl;

public class YamlParser
implements Parser<Yaml.Documents> {
    public List<Yaml.Documents> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo) {
        return this.acceptedInputs(sourceFiles).stream().map(sourceFile -> {
            Yaml.Documents documents;
            block8: {
                InputStream is = sourceFile.getSource();
                try {
                    documents = this.parseFromInput(sourceFile.getRelativePath(relativeTo), is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                is.close();
            }
            return documents;
        }).collect(Collectors.toList());
    }

    private Yaml.Documents parseFromInput(Path sourceFile, InputStream source) {
        Yaml.Documents documents;
        FormatPreservingReader reader = new FormatPreservingReader(new InputStreamReader(source));
        try {
            StreamReader streamReader = new StreamReader((Reader)reader);
            ScannerImpl scanner = new ScannerImpl(streamReader);
            ParserImpl parser = new ParserImpl((Scanner)scanner);
            int lastEnd = 0;
            ArrayList<Yaml.Document> documents2 = new ArrayList<Yaml.Document>();
            Yaml.Document document = null;
            Stack<BlockBuilder> blockStack = new Stack<BlockBuilder>();
            Event event = parser.getEvent();
            while (event != null) {
                Formatting fmt = reader.prefix(lastEnd, event);
                switch (event.getEventId()) {
                    case Alias: {
                        break;
                    }
                    case DocumentEnd: {
                        documents2.add(document);
                        break;
                    }
                    case DocumentStart: {
                        document = new Yaml.Document(Tree.randomId(), event.getEndMark().getIndex() - event.getStartMark().getIndex() > 0, Collections.emptyList(), null, fmt);
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case MappingStart: {
                        blockStack.push(new MappingBuilder(fmt));
                        break;
                    }
                    case Scalar: {
                        Yaml.Scalar.Style style;
                        ScalarEvent scalar = (ScalarEvent)event;
                        switch (scalar.getScalarStyle()) {
                            case DOUBLE_QUOTED: {
                                style = Yaml.Scalar.Style.DOUBLE_QUOTED;
                                break;
                            }
                            case SINGLE_QUOTED: {
                                style = Yaml.Scalar.Style.SINGLE_QUOTED;
                                break;
                            }
                            case LITERAL: {
                                style = Yaml.Scalar.Style.LITERAL;
                                break;
                            }
                            case FOLDED: {
                                style = Yaml.Scalar.Style.FOLDED;
                                break;
                            }
                            default: {
                                style = Yaml.Scalar.Style.PLAIN;
                            }
                        }
                        ((BlockBuilder)blockStack.peek()).push(new Yaml.Scalar(Tree.randomId(), style, scalar.getValue(), fmt));
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case SequenceEnd: 
                    case MappingEnd: {
                        Yaml.Block mappingOrSequence = ((BlockBuilder)blockStack.pop()).build();
                        if (blockStack.isEmpty()) {
                            document = document.withBlocks(Stream.concat(document.getBlocks().stream(), Stream.of(mappingOrSequence)).collect(Collectors.toList()));
                            break;
                        }
                        ((BlockBuilder)blockStack.peek()).push(mappingOrSequence);
                        break;
                    }
                    case SequenceStart: {
                        blockStack.push(new SequenceBuilder(fmt));
                        break;
                    }
                }
                event = parser.getEvent();
            }
            documents = new Yaml.Documents(Tree.randomId(), sourceFile.toFile().getPath(), Collections.emptyList(), documents2, Formatting.EMPTY);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return documents;
    }

    public boolean accept(Path path) {
        String fileName = path.getFileName().toString();
        return fileName.endsWith(".yml") || fileName.endsWith(".yaml");
    }

    private static class SequenceBuilder
    implements BlockBuilder {
        private final Formatting formatting;
        private final List<Yaml.Sequence.Entry> entries = new ArrayList<Yaml.Sequence.Entry>();

        private SequenceBuilder(Formatting formatting) {
            this.formatting = formatting;
        }

        @Override
        public void push(Yaml.Block block) {
            String entryPrefix = block.getPrefix();
            block = (Yaml.Block)block.withPrefix(entryPrefix.substring(entryPrefix.lastIndexOf(45) + 1));
            entryPrefix = entryPrefix.substring(0, entryPrefix.lastIndexOf(45));
            this.entries.add(new Yaml.Sequence.Entry(Tree.randomId(), block, Formatting.format((String)entryPrefix)));
        }

        @Override
        public Yaml.Sequence build() {
            return new Yaml.Sequence(Tree.randomId(), this.entries, this.formatting);
        }
    }

    private static class MappingBuilder
    implements BlockBuilder {
        private final Formatting formatting;
        private final List<Yaml.Mapping.Entry> entries = new ArrayList<Yaml.Mapping.Entry>();
        @Nullable
        private Yaml.Scalar key;

        private MappingBuilder(Formatting formatting) {
            this.formatting = formatting;
        }

        @Override
        public void push(Yaml.Block block) {
            if (this.key == null && block instanceof Yaml.Scalar) {
                this.key = (Yaml.Scalar)block;
            } else {
                String keySuffix = block.getPrefix();
                block = (Yaml.Block)block.withPrefix(keySuffix.substring(keySuffix.lastIndexOf(58) + 1));
                String keyPrefix = this.key.getPrefix();
                this.key = this.key.withFormatting(Formatting.format((String)"", (String)keySuffix.substring(0, keySuffix.lastIndexOf(58))));
                this.entries.add(new Yaml.Mapping.Entry(Tree.randomId(), this.key, block, Formatting.format((String)keyPrefix.substring(keyPrefix.lastIndexOf(58) + 1))));
                this.key = null;
            }
        }

        @Override
        public Yaml.Mapping build() {
            return new Yaml.Mapping(Tree.randomId(), this.entries, this.formatting);
        }
    }

    private static interface BlockBuilder {
        public Yaml.Block build();

        public void push(Yaml.Block var1);
    }
}

