/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.internal.YamlPrinter;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface Yaml
extends Serializable,
Tree {
    default public <P> String print(P p) {
        return new YamlPrinter<P>(TreePrinter.identity()).print(this, p);
    }

    default public <P> String print(TreePrinter<P> printer, P p) {
        return new YamlPrinter<P>(printer).print(this, p);
    }

    default public String printTrimmed() {
        int i;
        String print = this.print();
        for (i = 0; i < print.toCharArray().length && (print.charAt(i) == '\n' || print.charAt(i) == '\r'); ++i) {
        }
        return (print = print.substring(i)).isEmpty() || !Character.isWhitespace(print.charAt(0)) ? print : StringUtils.trimIndent((String)print.trim());
    }

    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)(v instanceof YamlVisitor ? this.acceptYaml((YamlVisitor)v, p) : v.defaultValue((Tree)this, p));
    }

    @Nullable
    default public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
        return (Yaml)v.defaultValue(this, p);
    }

    public Yaml copyPaste();

    public String getPrefix();

    public Yaml withPrefix(String var1);

    public static interface Block
    extends Yaml {
        @Override
        public Block copyPaste();

        @Override
        public Block withPrefix(String var1);
    }

    public static class Sequence
    implements Block {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final List<Entry> entries;

        @Override
        public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
            return v.visitSequence(this, p);
        }

        @Override
        public Sequence copyPaste() {
            return new Sequence(Tree.randomId(), this.prefix, Markers.EMPTY, this.entries.stream().map(Entry::copyPaste).collect(Collectors.toList()));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sequence)) {
                return false;
            }
            Sequence other = (Sequence)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Sequence;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Sequence(UUID id, String prefix, Markers markers, List<Entry> entries) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.entries = entries;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Entry> getEntries() {
            return this.entries;
        }

        public String toString() {
            return "Yaml.Sequence(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", entries=" + this.getEntries() + ")";
        }

        @Override
        public Sequence withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Sequence(this.id, prefix, this.markers, this.entries);
        }

        public Sequence withMarkers(Markers markers) {
            return this.markers == markers ? this : new Sequence(this.id, this.prefix, markers, this.entries);
        }

        public Sequence withEntries(List<Entry> entries) {
            return this.entries == entries ? this : new Sequence(this.id, this.prefix, this.markers, entries);
        }

        public static class Entry
        implements Yaml {
            private final UUID id;
            private final String prefix;
            private final Markers markers;
            private final Block block;

            @Override
            public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
                return v.visitSequenceEntry(this, p);
            }

            @Override
            public Entry copyPaste() {
                return new Entry(Tree.randomId(), this.prefix, Markers.EMPTY, this.block.copyPaste());
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Entry;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Entry(UUID id, String prefix, Markers markers, Block block) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.block = block;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public String getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public Block getBlock() {
                return this.block;
            }

            public String toString() {
                return "Yaml.Sequence.Entry(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", block=" + this.getBlock() + ")";
            }

            @Override
            public Entry withPrefix(String prefix) {
                return this.prefix == prefix ? this : new Entry(this.id, prefix, this.markers, this.block);
            }

            public Entry withMarkers(Markers markers) {
                return this.markers == markers ? this : new Entry(this.id, this.prefix, markers, this.block);
            }

            public Entry withBlock(Block block) {
                return this.block == block ? this : new Entry(this.id, this.prefix, this.markers, block);
            }
        }
    }

    public static class Mapping
    implements Block {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final List<Entry> entries;

        @Override
        public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
            return v.visitMapping(this, p);
        }

        @Override
        public Mapping copyPaste() {
            return new Mapping(Tree.randomId(), this.prefix, Markers.EMPTY, this.entries.stream().map(Entry::copyPaste).collect(Collectors.toList()));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mapping)) {
                return false;
            }
            Mapping other = (Mapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Mapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Mapping(UUID id, String prefix, Markers markers, List<Entry> entries) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.entries = entries;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Entry> getEntries() {
            return this.entries;
        }

        public String toString() {
            return "Yaml.Mapping(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", entries=" + this.getEntries() + ")";
        }

        @Override
        public Mapping withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Mapping(this.id, prefix, this.markers, this.entries);
        }

        public Mapping withMarkers(Markers markers) {
            return this.markers == markers ? this : new Mapping(this.id, this.prefix, markers, this.entries);
        }

        public Mapping withEntries(List<Entry> entries) {
            return this.entries == entries ? this : new Mapping(this.id, this.prefix, this.markers, entries);
        }

        public static class Entry
        implements Yaml {
            private final UUID id;
            private final String prefix;
            private final Markers markers;
            private final Scalar key;
            private final String beforeMappingValueIndicator;
            private final Block value;

            @Override
            public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
                return v.visitMappingEntry(this, p);
            }

            @Override
            public Entry copyPaste() {
                return new Entry(Tree.randomId(), this.prefix, Markers.EMPTY, this.key.copyPaste(), this.beforeMappingValueIndicator, this.value.copyPaste());
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Entry;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Entry(UUID id, String prefix, Markers markers, Scalar key, String beforeMappingValueIndicator, Block value) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.key = key;
                this.beforeMappingValueIndicator = beforeMappingValueIndicator;
                this.value = value;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public String getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public Scalar getKey() {
                return this.key;
            }

            public String getBeforeMappingValueIndicator() {
                return this.beforeMappingValueIndicator;
            }

            public Block getValue() {
                return this.value;
            }

            public String toString() {
                return "Yaml.Mapping.Entry(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", key=" + this.getKey() + ", beforeMappingValueIndicator=" + this.getBeforeMappingValueIndicator() + ", value=" + this.getValue() + ")";
            }

            @Override
            public Entry withPrefix(String prefix) {
                return this.prefix == prefix ? this : new Entry(this.id, prefix, this.markers, this.key, this.beforeMappingValueIndicator, this.value);
            }

            public Entry withMarkers(Markers markers) {
                return this.markers == markers ? this : new Entry(this.id, this.prefix, markers, this.key, this.beforeMappingValueIndicator, this.value);
            }

            public Entry withKey(Scalar key) {
                return this.key == key ? this : new Entry(this.id, this.prefix, this.markers, key, this.beforeMappingValueIndicator, this.value);
            }

            public Entry withBeforeMappingValueIndicator(String beforeMappingValueIndicator) {
                return this.beforeMappingValueIndicator == beforeMappingValueIndicator ? this : new Entry(this.id, this.prefix, this.markers, this.key, beforeMappingValueIndicator, this.value);
            }

            public Entry withValue(Block value) {
                return this.value == value ? this : new Entry(this.id, this.prefix, this.markers, this.key, this.beforeMappingValueIndicator, value);
            }
        }
    }

    public static class Scalar
    implements Block {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final Style style;
        private final String value;

        @Override
        public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
            return v.visitScalar(this, p);
        }

        @Override
        public Scalar copyPaste() {
            return new Scalar(Tree.randomId(), this.prefix, Markers.EMPTY, this.style, this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Scalar)) {
                return false;
            }
            Scalar other = (Scalar)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Scalar;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Scalar(UUID id, String prefix, Markers markers, Style style, String value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.style = style;
            this.value = value;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Style getStyle() {
            return this.style;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "Yaml.Scalar(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", style=" + (Object)((Object)this.getStyle()) + ", value=" + this.getValue() + ")";
        }

        @Override
        public Scalar withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Scalar(this.id, prefix, this.markers, this.style, this.value);
        }

        public Scalar withMarkers(Markers markers) {
            return this.markers == markers ? this : new Scalar(this.id, this.prefix, markers, this.style, this.value);
        }

        public Scalar withStyle(Style style) {
            return this.style == style ? this : new Scalar(this.id, this.prefix, this.markers, style, this.value);
        }

        public Scalar withValue(String value) {
            return this.value == value ? this : new Scalar(this.id, this.prefix, this.markers, this.style, value);
        }

        public static enum Style {
            DOUBLE_QUOTED,
            SINGLE_QUOTED,
            LITERAL,
            FOLDED,
            PLAIN;

        }
    }

    public static class Document
    implements Yaml {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final boolean explicit;
        private final List<Block> blocks;
        @Nullable
        private final End end;

        @Override
        public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
            return v.visitDocument(this, p);
        }

        @Override
        public Document copyPaste() {
            return new Document(Tree.randomId(), this.prefix, Markers.EMPTY, this.explicit, this.blocks.stream().map(Block::copyPaste).collect(Collectors.toList()), this.end == null ? null : this.end.copyPaste());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Document)) {
                return false;
            }
            Document other = (Document)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Document;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Document(UUID id, String prefix, Markers markers, boolean explicit, List<Block> blocks, End end) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.explicit = explicit;
            this.blocks = blocks;
            this.end = end;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public boolean isExplicit() {
            return this.explicit;
        }

        public List<Block> getBlocks() {
            return this.blocks;
        }

        public End getEnd() {
            return this.end;
        }

        public String toString() {
            return "Yaml.Document(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", explicit=" + this.isExplicit() + ", blocks=" + this.getBlocks() + ", end=" + this.getEnd() + ")";
        }

        @Override
        public Document withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Document(this.id, prefix, this.markers, this.explicit, this.blocks, this.end);
        }

        public Document withMarkers(Markers markers) {
            return this.markers == markers ? this : new Document(this.id, this.prefix, markers, this.explicit, this.blocks, this.end);
        }

        public Document withExplicit(boolean explicit) {
            return this.explicit == explicit ? this : new Document(this.id, this.prefix, this.markers, explicit, this.blocks, this.end);
        }

        public Document withBlocks(List<Block> blocks) {
            return this.blocks == blocks ? this : new Document(this.id, this.prefix, this.markers, this.explicit, blocks, this.end);
        }

        public Document withEnd(End end) {
            return this.end == end ? this : new Document(this.id, this.prefix, this.markers, this.explicit, this.blocks, end);
        }

        public static class End
        implements Yaml {
            private final UUID id;
            private final String prefix;
            private final Markers markers;

            @Override
            public End copyPaste() {
                return new End(Tree.randomId(), this.prefix, Markers.EMPTY);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof End)) {
                    return false;
                }
                End other = (End)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            protected boolean canEqual(Object other) {
                return other instanceof End;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public End(UUID id, String prefix, Markers markers) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public String getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "Yaml.Document.End(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public End withPrefix(String prefix) {
                return this.prefix == prefix ? this : new End(this.id, prefix, this.markers);
            }

            public End withMarkers(Markers markers) {
                return this.markers == markers ? this : new End(this.id, this.prefix, markers);
            }
        }
    }

    @JsonIgnoreProperties(value={"styles"})
    public static class Documents
    implements Yaml,
    SourceFile {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final Path sourcePath;
        private final List<Document> documents;

        @Override
        public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
            return v.visitDocuments(this, p);
        }

        @Override
        public Documents copyPaste() {
            return new Documents(Tree.randomId(), this.prefix, Markers.EMPTY, this.sourcePath, this.documents.stream().map(Document::copyPaste).collect(Collectors.toList()));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Documents)) {
                return false;
            }
            Documents other = (Documents)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Documents;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Documents(UUID id, String prefix, Markers markers, Path sourcePath, List<Document> documents) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.documents = documents;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public List<Document> getDocuments() {
            return this.documents;
        }

        public String toString() {
            return "Yaml.Documents(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", documents=" + this.getDocuments() + ")";
        }

        @Override
        public Documents withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Documents(this.id, prefix, this.markers, this.sourcePath, this.documents);
        }

        public Documents withMarkers(Markers markers) {
            return this.markers == markers ? this : new Documents(this.id, this.prefix, markers, this.sourcePath, this.documents);
        }

        public Documents withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new Documents(this.id, this.prefix, this.markers, sourcePath, this.documents);
        }

        public Documents withDocuments(List<Document> documents) {
            return this.documents == documents ? this : new Documents(this.id, this.prefix, this.markers, this.sourcePath, documents);
        }
    }
}

