/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.internal;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class YamlPrinter<P>
extends YamlVisitor<P> {
    private static final String PRINTER_ACC_KEY = "printed";
    private final TreePrinter<P> treePrinter;

    public YamlPrinter(TreePrinter<P> treePrinter) {
        this.treePrinter = treePrinter;
    }

    @NonNull
    protected StringBuilder getPrinter() {
        StringBuilder acc = (StringBuilder)this.getCursor().getRoot().getMessage(PRINTER_ACC_KEY);
        if (acc == null) {
            acc = new StringBuilder();
            this.getCursor().getRoot().putMessage(PRINTER_ACC_KEY, (Object)acc);
        }
        return acc;
    }

    public String print(Yaml yaml, P p) {
        this.setCursor(new Cursor(null, (Object)"EPSILON"));
        this.visit((Tree)yaml, (Object)p);
        return this.getPrinter().toString();
    }

    @Nullable
    public Yaml visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return (Yaml)this.defaultValue(null, p);
        }
        StringBuilder printerAcc = this.getPrinter();
        this.treePrinter.doBefore(tree, printerAcc, p);
        tree = super.visit(tree, p);
        if (tree != null) {
            this.treePrinter.doAfter(tree, printerAcc, p);
        }
        return (Yaml)tree;
    }

    public void visit(@Nullable List<? extends Yaml> nodes, P p) {
        if (nodes != null) {
            for (Yaml yaml : nodes) {
                this.visit((Tree)yaml, (Object)p);
            }
        }
    }

    @Override
    public Yaml visitDocument(Yaml.Document document, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(document.getPrefix());
        if (document.isExplicit()) {
            acc.append("---");
        }
        this.visit(document.getBlocks(), p);
        if (document.getEnd() != null) {
            acc.append(document.getEnd().getPrefix()).append("...");
        }
        return document;
    }

    @Override
    public Yaml visitDocuments(Yaml.Documents documents, P p) {
        this.getPrinter().append(documents.getPrefix());
        return super.visitDocuments(documents, p);
    }

    @Override
    public Yaml visitSequenceEntry(Yaml.Sequence.Entry entry, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(entry.getPrefix()).append('-');
        this.visit((Tree)entry.getBlock(), (Object)p);
        return entry;
    }

    @Override
    public Yaml visitSequence(Yaml.Sequence sequence, P p) {
        this.getPrinter().append(sequence.getPrefix());
        return super.visitSequence(sequence, p);
    }

    @Override
    public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(entry.getPrefix());
        this.visit((Tree)entry.getKey(), (Object)p);
        acc.append(entry.getBeforeMappingValueIndicator()).append(':');
        this.visit((Tree)entry.getValue(), (Object)p);
        return entry;
    }

    @Override
    public Yaml visitMapping(Yaml.Mapping mapping, P p) {
        return super.visitMapping(mapping, p);
    }

    @Override
    public Yaml visitScalar(Yaml.Scalar scalar, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(scalar.getPrefix());
        switch (scalar.getStyle()) {
            case DOUBLE_QUOTED: {
                acc.append('\"').append(scalar.getValue()).append('\"');
                break;
            }
            case SINGLE_QUOTED: {
                acc.append('\'').append(scalar.getValue()).append('\'');
                break;
            }
            case LITERAL: {
                acc.append('|').append(scalar.getValue());
                break;
            }
            case FOLDED: {
                acc.append('>').append(scalar.getValue());
                break;
            }
            default: {
                acc.append(scalar.getValue());
            }
        }
        return scalar;
    }
}

