/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.FormatPreservingReader;
import org.openrewrite.yaml.tree.Yaml;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Scanner;
import org.yaml.snakeyaml.scanner.ScannerImpl;

public class YamlParser
implements Parser<Yaml.Documents> {
    public List<Yaml.Documents> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public List<Yaml.Documents> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.acceptedInputs(sourceFiles).stream().map(sourceFile -> {
            Yaml.Documents documents;
            block8: {
                Timer.Builder timer = Timer.builder((String)"rewrite.parse").description("The time spent parsing a YAML file").tag("file.type", "YAML");
                Timer.Sample sample = Timer.start();
                InputStream is = sourceFile.getSource();
                try {
                    Yaml.Documents yaml = this.parseFromInput(sourceFile.getRelativePath(relativeTo), is);
                    sample.stop(MetricsHelper.successTags((Timer.Builder)timer).register((MeterRegistry)Metrics.globalRegistry));
                    documents = yaml;
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        sample.stop(MetricsHelper.errorTags((Timer.Builder)timer, (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                        ctx.getOnError().accept(t);
                        return null;
                    }
                }
                is.close();
            }
            return documents;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Yaml.Documents parseFromInput(Path sourceFile, InputStream source) {
        Yaml.Documents documents;
        FormatPreservingReader reader = new FormatPreservingReader(new InputStreamReader(source));
        try {
            StreamReader streamReader = new StreamReader((Reader)reader);
            ScannerImpl scanner = new ScannerImpl(streamReader);
            ParserImpl parser = new ParserImpl((Scanner)scanner);
            int lastEnd = 0;
            ArrayList<Yaml.Document> documents2 = new ArrayList<Yaml.Document>();
            Yaml.Document document = null;
            Stack<BlockBuilder> blockStack = new Stack<BlockBuilder>();
            Event event = parser.getEvent();
            while (event != null) {
                String fmt = reader.prefix(lastEnd, event);
                switch (event.getEventId()) {
                    case DocumentEnd: {
                        if (((DocumentEndEvent)event).getExplicit()) {
                            assert (document != null);
                            documents2.add(document.withEnd(new Yaml.Document.End(Tree.randomId(), fmt, Markers.EMPTY)));
                            lastEnd = event.getEndMark().getIndex();
                            break;
                        }
                        documents2.add(document);
                        break;
                    }
                    case DocumentStart: {
                        document = new Yaml.Document(Tree.randomId(), fmt, Markers.EMPTY, event.getEndMark().getIndex() - event.getStartMark().getIndex() > 0, Collections.emptyList(), null);
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case MappingStart: {
                        blockStack.push(new MappingBuilder(fmt));
                        break;
                    }
                    case Scalar: {
                        Yaml.Scalar.Style style;
                        ScalarEvent scalar = (ScalarEvent)event;
                        switch (scalar.getScalarStyle()) {
                            case DOUBLE_QUOTED: {
                                style = Yaml.Scalar.Style.DOUBLE_QUOTED;
                                break;
                            }
                            case SINGLE_QUOTED: {
                                style = Yaml.Scalar.Style.SINGLE_QUOTED;
                                break;
                            }
                            case LITERAL: {
                                style = Yaml.Scalar.Style.LITERAL;
                                break;
                            }
                            case FOLDED: {
                                style = Yaml.Scalar.Style.FOLDED;
                                break;
                            }
                            default: {
                                style = Yaml.Scalar.Style.PLAIN;
                            }
                        }
                        ((BlockBuilder)blockStack.peek()).push(new Yaml.Scalar(Tree.randomId(), fmt, Markers.EMPTY, style, scalar.getValue()));
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case SequenceEnd: 
                    case MappingEnd: {
                        Yaml.Block mappingOrSequence = ((BlockBuilder)blockStack.pop()).build();
                        if (blockStack.isEmpty()) {
                            document = document.withBlocks(Stream.concat(document.getBlocks().stream(), Stream.of(mappingOrSequence)).collect(Collectors.toList()));
                            break;
                        }
                        ((BlockBuilder)blockStack.peek()).push(mappingOrSequence);
                        break;
                    }
                    case SequenceStart: {
                        blockStack.push(new SequenceBuilder(fmt));
                        break;
                    }
                }
                event = parser.getEvent();
            }
            documents = new Yaml.Documents(Tree.randomId(), "", Markers.EMPTY, sourceFile, documents2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return documents;
    }

    public boolean accept(Path path) {
        String fileName = path.toString();
        return fileName.endsWith(".yml") || fileName.endsWith(".yaml");
    }

    private static class SequenceBuilder
    implements BlockBuilder {
        private final String prefix;
        private final List<Yaml.Sequence.Entry> entries = new ArrayList<Yaml.Sequence.Entry>();

        private SequenceBuilder(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public void push(Yaml.Block block) {
            String entryPrefix = block.getPrefix();
            block = block.withPrefix(entryPrefix.substring(entryPrefix.lastIndexOf(45) + 1));
            entryPrefix = entryPrefix.substring(0, entryPrefix.lastIndexOf(45));
            this.entries.add(new Yaml.Sequence.Entry(Tree.randomId(), entryPrefix, Markers.EMPTY, block));
        }

        @Override
        public Yaml.Sequence build() {
            return new Yaml.Sequence(Tree.randomId(), this.prefix, Markers.EMPTY, this.entries);
        }
    }

    private static class MappingBuilder
    implements BlockBuilder {
        private final String prefix;
        private final List<Yaml.Mapping.Entry> entries = new ArrayList<Yaml.Mapping.Entry>();
        @Nullable
        private Yaml.Scalar key;

        private MappingBuilder(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public void push(Yaml.Block block) {
            if (this.key == null && block instanceof Yaml.Scalar) {
                this.key = (Yaml.Scalar)block;
            } else {
                String keySuffix = block.getPrefix();
                block = block.withPrefix(keySuffix.substring(keySuffix.lastIndexOf(58) + 1));
                String keyPrefix = this.key.getPrefix();
                this.key = this.key.withPrefix("");
                String beforeMappingValueIndicator = keySuffix.substring(0, keySuffix.lastIndexOf(58));
                String entryPrefix = keyPrefix.substring(keyPrefix.lastIndexOf(58) + 1);
                this.entries.add(new Yaml.Mapping.Entry(Tree.randomId(), entryPrefix, Markers.EMPTY, this.key, beforeMappingValueIndicator, block));
                this.key = null;
            }
        }

        @Override
        public Yaml.Mapping build() {
            return new Yaml.Mapping(Tree.randomId(), this.prefix, Markers.EMPTY, this.entries);
        }
    }

    private static interface BlockBuilder {
        public Yaml.Block build();

        public void push(Yaml.Block var1);
    }
}

