/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.internal;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class YamlPrinter<P>
extends YamlVisitor<P> {
    private static final String PRINTER_ACC_KEY = "printed";
    private final TreePrinter<P> treePrinter;

    public YamlPrinter(TreePrinter<P> treePrinter) {
        this.treePrinter = treePrinter;
    }

    @NonNull
    protected StringBuilder getPrinter() {
        StringBuilder acc = (StringBuilder)this.getCursor().getRoot().getMessage(PRINTER_ACC_KEY);
        if (acc == null) {
            acc = new StringBuilder();
            this.getCursor().getRoot().putMessage(PRINTER_ACC_KEY, (Object)acc);
        }
        return acc;
    }

    public String print(Yaml yaml, P p) {
        this.setCursor(new Cursor(null, (Object)"EPSILON"));
        this.visit((Tree)yaml, (Object)p);
        return this.getPrinter().toString();
    }

    @Nullable
    public Yaml visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return (Yaml)this.defaultValue(null, p);
        }
        StringBuilder printerAcc = this.getPrinter();
        this.treePrinter.doBefore(tree, printerAcc, p);
        tree = super.visit(tree, p);
        if (tree != null) {
            this.treePrinter.doAfter(tree, printerAcc, p);
        }
        return (Yaml)tree;
    }

    public void visit(@Nullable List<? extends Yaml> nodes, P p) {
        if (nodes != null) {
            for (Yaml yaml : nodes) {
                this.visit((Tree)yaml, (Object)p);
            }
        }
    }

    @Override
    public Yaml visitDocument(Yaml.Document document, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(document.getPrefix());
        this.visitMarkers(document.getMarkers(), p);
        if (document.isExplicit()) {
            acc.append("---");
        }
        this.visit((Tree)document.getBlock(), (Object)p);
        acc.append(document.getEnd().getPrefix());
        if (document.getEnd().isExplicit()) {
            acc.append("...");
        }
        return document;
    }

    @Override
    public Yaml visitDocuments(Yaml.Documents documents, P p) {
        this.getPrinter().append(documents.getPrefix());
        this.visitMarkers(documents.getMarkers(), p);
        return super.visitDocuments(documents, p);
    }

    @Override
    public Yaml visitSequenceEntry(Yaml.Sequence.Entry entry, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(entry.getPrefix());
        if (entry.isDash()) {
            acc.append('-');
        }
        this.visit((Tree)entry.getBlock(), (Object)p);
        if (entry.getTrailingCommaPrefix() != null) {
            acc.append(entry.getTrailingCommaPrefix()).append(',');
        }
        return entry;
    }

    @Override
    public Yaml visitSequence(Yaml.Sequence sequence, P p) {
        this.getPrinter().append(sequence.getPrefix());
        this.visitMarkers(sequence.getMarkers(), p);
        if (sequence.getOpeningBracketPrefix() != null) {
            this.getPrinter().append(sequence.getOpeningBracketPrefix()).append('[');
        }
        Yaml result = super.visitSequence(sequence, p);
        if (sequence.getClosingBracketPrefix() != null) {
            this.getPrinter().append(sequence.getClosingBracketPrefix()).append(']');
        }
        return result;
    }

    @Override
    public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(entry.getPrefix());
        this.visitMarkers(entry.getMarkers(), p);
        this.visit((Tree)entry.getKey(), (Object)p);
        acc.append(entry.getBeforeMappingValueIndicator()).append(':');
        this.visit((Tree)entry.getValue(), (Object)p);
        return entry;
    }

    @Override
    public Yaml visitMapping(Yaml.Mapping mapping, P p) {
        this.visitMarkers(mapping.getMarkers(), p);
        return super.visitMapping(mapping, p);
    }

    public <M extends Marker> M visitMarker(Marker marker, P p) {
        StringBuilder acc = this.getPrinter();
        this.treePrinter.doBefore((Tree)marker, acc, p);
        acc.append(marker.print(this.treePrinter, p));
        this.treePrinter.doAfter((Tree)marker, acc, p);
        return (M)marker;
    }

    public Markers visitMarkers(Markers markers, P p) {
        StringBuilder acc = this.getPrinter();
        this.treePrinter.doBefore((Tree)markers, acc, p);
        Markers m = super.visitMarkers(markers, p);
        this.treePrinter.doAfter((Tree)markers, acc, p);
        return m;
    }

    @Override
    public Yaml visitScalar(Yaml.Scalar scalar, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(scalar.getPrefix());
        this.visitMarkers(scalar.getMarkers(), p);
        switch (scalar.getStyle()) {
            case DOUBLE_QUOTED: {
                acc.append('\"').append(scalar.getValue().replaceAll("\\n", "\\\\n")).append('\"');
                break;
            }
            case SINGLE_QUOTED: {
                acc.append('\'').append(scalar.getValue().replaceAll("\\n", "\\\\n")).append('\'');
                break;
            }
            case LITERAL: {
                acc.append('|').append(scalar.getValue());
                break;
            }
            case FOLDED: {
                acc.append('>').append(scalar.getValue());
                break;
            }
            default: {
                acc.append(scalar.getValue());
            }
        }
        return scalar;
    }
}

