/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class AppendToSequenceVisitor
extends YamlIsoVisitor<ExecutionContext> {
    private final JsonPathMatcher matcher;
    private final String value;
    @Nullable
    private final List<String> existingSequenceValues;
    private final boolean matchExistingSequenceValuesInAnyOrder;

    public AppendToSequenceVisitor(JsonPathMatcher matcher, String value, @Nullable List<String> existingSequenceValues, boolean matchExistingSequenceValuesInAnyOrder) {
        this.matcher = matcher;
        this.value = value;
        this.existingSequenceValues = existingSequenceValues;
        this.matchExistingSequenceValuesInAnyOrder = matchExistingSequenceValuesInAnyOrder;
    }

    @Override
    public Yaml.Sequence visitSequence(Yaml.Sequence existingSeq, ExecutionContext executionContext) {
        Cursor parent = this.getCursor().getParent();
        if (this.matcher.matches(parent) && !AppendToSequenceVisitor.alreadyVisited(existingSeq, executionContext) && this.checkExistingSequenceValues(existingSeq, parent)) {
            AppendToSequenceVisitor.setVisited(existingSeq, executionContext);
            Yaml.Sequence newSeq = this.appendToSequence(existingSeq, this.value, executionContext);
            AppendToSequenceVisitor.setVisited(newSeq, executionContext);
            return newSeq;
        }
        return super.visitSequence(existingSeq, executionContext);
    }

    protected boolean checkExistingSequenceValues(Yaml.Sequence seq, Cursor cursor) {
        if (null == this.existingSequenceValues) {
            return true;
        }
        List values = seq.getEntries().stream().map(entry -> entry.getBlock()).map(block -> this.convertBlockToString((Yaml.Block)block, cursor)).collect(Collectors.toList());
        if (this.matchExistingSequenceValuesInAnyOrder) {
            ArrayList<String> sorted = new ArrayList<String>(this.existingSequenceValues);
            Collections.sort(sorted);
            Collections.sort(values);
            return values.equals(sorted);
        }
        return values.equals(this.existingSequenceValues);
    }

    private String convertBlockToString(Yaml.Block block, Cursor cursor) {
        if (block instanceof Yaml.Scalar) {
            return ((Yaml.Scalar)block).getValue();
        }
        return block.printTrimmed(cursor);
    }

    private Yaml.Sequence appendToSequence(Yaml.Sequence existingSequence, String value, ExecutionContext executionContext) {
        Yaml.Sequence newSequence = existingSequence.copyPaste();
        List<Yaml.Sequence.Entry> entries = newSequence.getEntries();
        boolean hasDash = false;
        Yaml.Scalar.Style style = Yaml.Scalar.Style.PLAIN;
        String entryPrefix = "";
        String entryTrailingCommaPrefix = null;
        String itemPrefix = "";
        if (!entries.isEmpty()) {
            int lastEntryIndex = entries.size() - 1;
            Yaml.Sequence.Entry existingEntry = entries.get(lastEntryIndex);
            hasDash = existingEntry.isDash();
            entryPrefix = existingEntry.getPrefix();
            entryTrailingCommaPrefix = existingEntry.getTrailingCommaPrefix();
            Yaml.Block block = existingEntry.getBlock();
            if (block instanceof Yaml.Mapping) {
                Yaml.Mapping mapping = (Yaml.Mapping)block;
                List<Yaml.Mapping.Entry> mappingEntries = mapping.getEntries();
                if (!mappingEntries.isEmpty()) {
                    Yaml.Mapping.Entry entry = mappingEntries.get(0);
                    itemPrefix = entry.getPrefix();
                }
            } else if (block instanceof Yaml.Scalar) {
                itemPrefix = block.getPrefix();
                style = ((Yaml.Scalar)block).getStyle();
            }
            if (!existingEntry.isDash()) {
                entries.set(lastEntryIndex, existingEntry.withTrailingCommaPrefix(""));
            }
        }
        Yaml.Scalar newItem = new Yaml.Scalar(Tree.randomId(), itemPrefix, Markers.EMPTY, style, null, value);
        Yaml.Sequence.Entry newEntry = new Yaml.Sequence.Entry(Tree.randomId(), entryPrefix, Markers.EMPTY, newItem, hasDash, entryTrailingCommaPrefix);
        entries.add(newEntry);
        return newSequence;
    }

    private static void setVisited(Yaml.Sequence seq, ExecutionContext context) {
        context.putMessage(AppendToSequenceVisitor.makeAlreadyVisitedKey(seq), (Object)Boolean.TRUE);
    }

    private static boolean alreadyVisited(Yaml.Sequence seq, ExecutionContext context) {
        return (Boolean)context.getMessage(AppendToSequenceVisitor.makeAlreadyVisitedKey(seq), (Object)Boolean.FALSE);
    }

    private static String makeAlreadyVisitedKey(Yaml.Sequence seq) {
        return AppendToSequenceVisitor.class.getName() + ".alreadyVisited." + seq.getId().toString();
    }
}

