/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class CopyValue
extends Recipe {
    @Option(displayName="Old key path", description="A [JsonPath](https://github.com/json-path/JsonPath) expression to locate a YAML key/value pair to copy.", example="$.source.kind")
    private final String oldKeyPath;
    @Option(displayName="New key path", description="A [JsonPath](https://github.com/json-path/JsonPath) expression for where the new value should be copied to.", example="$.dest.kind")
    private final String newKey;

    public String getDisplayName() {
        return "Copy YAML value";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.oldKeyPath, this.newKey);
    }

    public String getDescription() {
        return "Copies a YAML value from one key to another. The existing key/value pair remains unaffected by this change. If either the source or destination key path does not exist, no value will be copied. Furthermore, copies are limited to scalar values, not whole YAML blocks.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher oldPathMatcher = new JsonPathMatcher(this.oldKeyPath);
        final JsonPathMatcher newPathMatcher = new JsonPathMatcher(this.newKey);
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml source = super.visitMappingEntry(entry, ctx);
                if (oldPathMatcher.matches(this.getCursor()) && entry.getValue() instanceof Yaml.Scalar) {
                    this.doAfterVisit(new YamlIsoVisitor<ExecutionContext>((Yaml.Mapping.Entry)source){
                        final /* synthetic */ Yaml.Mapping.Entry val$source;
                        {
                            this.val$source = entry;
                        }

                        @Override
                        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                            Yaml dest = super.visitMappingEntry(entry, ctx);
                            if (newPathMatcher.matches(this.getCursor())) {
                                dest = ((Yaml.Mapping.Entry)dest).withValue(this.val$source.getValue());
                            }
                            return dest;
                        }
                    });
                }
                return source;
            }
        };
    }

    public CopyValue(String oldKeyPath, String newKey) {
        this.oldKeyPath = oldKeyPath;
        this.newKey = newKey;
    }

    public String getOldKeyPath() {
        return this.oldKeyPath;
    }

    public String getNewKey() {
        return this.newKey;
    }

    @NonNull
    public String toString() {
        return "CopyValue(oldKeyPath=" + this.getOldKeyPath() + ", newKey=" + this.getNewKey() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyValue)) {
            return false;
        }
        CopyValue other = (CopyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldKeyPath = this.getOldKeyPath();
        String other$oldKeyPath = other.getOldKeyPath();
        if (this$oldKeyPath == null ? other$oldKeyPath != null : !this$oldKeyPath.equals(other$oldKeyPath)) {
            return false;
        }
        String this$newKey = this.getNewKey();
        String other$newKey = other.getNewKey();
        return !(this$newKey == null ? other$newKey != null : !this$newKey.equals(other$newKey));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CopyValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldKeyPath = this.getOldKeyPath();
        result = result * 59 + ($oldKeyPath == null ? 43 : $oldKeyPath.hashCode());
        String $newKey = this.getNewKey();
        result = result * 59 + ($newKey == null ? 43 : $newKey.hashCode());
        return result;
    }
}

