/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markers;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;
import org.openrewrite.yaml.FormatPreservingReader;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;
import org.openrewrite.yaml.tree.YamlKey;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Scanner;
import org.yaml.snakeyaml.scanner.ScannerImpl;

public class YamlParser
implements Parser {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile(":\\s+(@[^\n\r@]+@)");
    private static final Pattern HELM_TEMPLATE_PATTERN = Pattern.compile("\\{\\{[^{}\\n\\r]*\\}\\}");

    public Stream<SourceFile> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        return this.acceptedInputs(sourceFiles).map(input -> {
            SourceFile sourceFile;
            block8: {
                parsingListener.startedParsing(input);
                Path path = input.getRelativePath(relativeTo);
                EncodingDetectingInputStream is = input.getSource(ctx);
                try {
                    Yaml.Documents yaml = this.parseFromInput(path, is);
                    parsingListener.parsed(input, (SourceFile)yaml);
                    yaml = yaml.withFileAttributes(input.getFileAttributes());
                    yaml = this.unwrapPrefixedMappings(yaml);
                    sourceFile = this.requirePrintEqualsInput((SourceFile)yaml, (Parser.Input)input, relativeTo, ctx);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        ctx.getOnError().accept(t);
                        return ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
                    }
                }
                is.close();
            }
            return sourceFile;
        }).map(sourceFile -> {
            if (sourceFile instanceof Yaml.Documents) {
                Yaml.Documents docs = (Yaml.Documents)sourceFile;
                if (docs.getDocuments().isEmpty()) {
                    Yaml.Document.End end = new Yaml.Document.End(Tree.randomId(), "", Markers.EMPTY, false);
                    Yaml.Mapping mapping = new Yaml.Mapping(Tree.randomId(), Markers.EMPTY, null, Collections.emptyList(), null, null, null);
                    return docs.withDocuments(Collections.singletonList(new Yaml.Document(Tree.randomId(), "", Markers.EMPTY, false, mapping, end)));
                }
                return docs;
            }
            return sourceFile;
        });
    }

    private Yaml.Documents parseFromInput(Path sourceFile, EncodingDetectingInputStream source) {
        Yaml.Documents documents;
        String yamlSource = source.readFully();
        HashMap<String, String> variableByUuid = new HashMap<String, String>();
        HashMap<String, String> helmTemplateByUuid = new HashMap<String, String>();
        String processedSource = yamlSource;
        Matcher helmMatcher = HELM_TEMPLATE_PATTERN.matcher(processedSource);
        StringBuffer helmBuffer = new StringBuffer();
        while (helmMatcher.find()) {
            String uuid = UUID.randomUUID().toString();
            helmTemplateByUuid.put(uuid, helmMatcher.group());
            helmMatcher.appendReplacement(helmBuffer, uuid);
        }
        helmMatcher.appendTail(helmBuffer);
        processedSource = helmBuffer.toString();
        StringBuilder yamlSourceWithPlaceholders = new StringBuilder();
        Matcher variableMatcher = VARIABLE_PATTERN.matcher(processedSource);
        int pos = 0;
        while (pos < processedSource.length() && variableMatcher.find(pos)) {
            yamlSourceWithPlaceholders.append(processedSource, pos, variableMatcher.start(1));
            String uuid = UUID.randomUUID().toString();
            variableByUuid.put(uuid, variableMatcher.group(1));
            yamlSourceWithPlaceholders.append(uuid);
            pos = variableMatcher.end(1);
        }
        if (pos < processedSource.length()) {
            yamlSourceWithPlaceholders.append(processedSource, pos, processedSource.length());
        }
        FormatPreservingReader reader = new FormatPreservingReader(yamlSourceWithPlaceholders.toString());
        try {
            StreamReader streamReader = new StreamReader((Reader)reader);
            ScannerImpl scanner = new ScannerImpl(streamReader, new LoaderOptions());
            ParserImpl parser = new ParserImpl((Scanner)scanner);
            int lastEnd = 0;
            ArrayList<Yaml.Document> documents2 = new ArrayList<Yaml.Document>();
            HashMap<String, Yaml.Anchor> anchors = new HashMap<String, Yaml.Anchor>();
            Yaml.Document document = null;
            Stack<BlockBuilder> blockStack = new Stack<BlockBuilder>();
            String newLine = "";
            Event event = parser.getEvent();
            while (event != null) {
                switch (event.getEventId()) {
                    case DocumentEnd: {
                        Object scalar;
                        assert (document != null);
                        if (blockStack.size() == 1 && blockStack.peek() instanceof ScalarBuilder) {
                            ScalarBuilder builder = (ScalarBuilder)blockStack.pop();
                            lastEnd = builder.getLastEnd();
                            scalar = builder.getScalar();
                            document = document.withBlock((Yaml.Block)scalar);
                        }
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        newLine = "";
                        documents2.add(document.withEnd(new Yaml.Document.End(Tree.randomId(), fmt, Markers.EMPTY, ((DocumentEndEvent)event).getExplicit())));
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case DocumentStart: {
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        newLine = "";
                        document = new Yaml.Document(Tree.randomId(), fmt, Markers.EMPTY, ((DocumentStartEvent)event).getExplicit(), new Yaml.Mapping(Tree.randomId(), Markers.EMPTY, null, Collections.emptyList(), null, null, null), new Yaml.Document.End(Tree.randomId(), "", Markers.EMPTY, false));
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case MappingStart: {
                        String tagSuffix;
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        newLine = "";
                        MappingStartEvent mappingStartEvent = (MappingStartEvent)event;
                        Yaml.Anchor anchor = null;
                        if (mappingStartEvent.getAnchor() != null) {
                            anchor = this.buildYamlAnchor(reader, lastEnd, fmt, mappingStartEvent.getAnchor(), event.getEndMark().getIndex(), false);
                            anchors.put(mappingStartEvent.getAnchor(), anchor);
                            lastEnd = lastEnd + mappingStartEvent.getAnchor().length() + fmt.length() + 1;
                            fmt = reader.readStringFromBuffer(lastEnd, event.getEndMark().getIndex());
                            int dashPrefixIndex = YamlParser.commentAwareIndexOf('-', fmt);
                            if (dashPrefixIndex > -1) {
                                fmt = fmt.substring(0, dashPrefixIndex);
                            }
                        }
                        String fullPrefix = reader.readStringFromBuffer(lastEnd, event.getEndMark().getIndex() - 1);
                        int startIndex = YamlParser.commentAwareIndexOf(':', fullPrefix) + 1;
                        Yaml.Tag tag = null;
                        if (mappingStartEvent.getTag() != null) {
                            int i;
                            String prefixAfterColon = fullPrefix.substring(startIndex);
                            int tagStartIndex = prefixAfterColon.indexOf(33);
                            String tagPrefix = prefixAfterColon.substring(0, tagStartIndex);
                            for (i = tagStartIndex; i < prefixAfterColon.length() && !Character.isWhitespace(prefixAfterColon.charAt(i)); ++i) {
                            }
                            String tagName = prefixAfterColon.substring(tagStartIndex, i);
                            tagSuffix = prefixAfterColon.substring(i, prefixAfterColon.length() - 2);
                            tag = this.createTag(tagPrefix, Markers.EMPTY, tagName, tagSuffix);
                            lastEnd = lastEnd + startIndex + i + 1;
                        }
                        String startBracePrefix = null;
                        int openingBraceIndex = YamlParser.commentAwareIndexOf('{', fullPrefix);
                        if (openingBraceIndex != -1) {
                            startBracePrefix = fullPrefix.substring(startIndex, openingBraceIndex);
                            lastEnd = event.getEndMark().getIndex();
                        }
                        blockStack.push(new MappingBuilder(fmt, startBracePrefix, anchor, tag));
                        break;
                    }
                    case Scalar: {
                        BlockBuilder builder;
                        Yaml.Scalar.Style style;
                        String scalarValue;
                        int valueStart;
                        String tagSuffix;
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        Object scalar = (ScalarEvent)event;
                        Yaml.Anchor anchor = null;
                        if (scalar.getAnchor() != null) {
                            anchor = this.buildYamlAnchor(reader, lastEnd, fmt, scalar.getAnchor(), event.getEndMark().getIndex(), true);
                            anchors.put(scalar.getAnchor(), anchor);
                            valueStart = lastEnd + fmt.length() + scalar.getAnchor().length() + 1 + anchor.getPostfix().length();
                        } else {
                            valueStart = lastEnd + fmt.length();
                        }
                        valueStart -= newLine.length();
                        newLine = "";
                        Yaml.Tag tag = null;
                        if (scalar.getTag() != null) {
                            int indexOfSpaceAfterTag;
                            int indexOfTagName;
                            String potentialScalarValue = reader.readStringFromBuffer(valueStart, event.getEndMark().getIndex() - 1);
                            assert (potentialScalarValue.contains("!"));
                            int tagStartIndex = potentialScalarValue.indexOf(33);
                            String tagPrefix = potentialScalarValue.substring(0, tagStartIndex);
                            for (indexOfTagName = tagStartIndex; indexOfTagName < potentialScalarValue.length() && !Character.isWhitespace(potentialScalarValue.charAt(indexOfTagName)); ++indexOfTagName) {
                            }
                            String tagName = potentialScalarValue.substring(tagStartIndex, indexOfTagName);
                            for (indexOfSpaceAfterTag = indexOfTagName; indexOfSpaceAfterTag < potentialScalarValue.length() && Character.isWhitespace(potentialScalarValue.charAt(indexOfSpaceAfterTag)); ++indexOfSpaceAfterTag) {
                            }
                            tagSuffix = potentialScalarValue.substring(indexOfTagName, indexOfSpaceAfterTag);
                            valueStart += indexOfSpaceAfterTag;
                            tag = this.createTag(tagPrefix, Markers.EMPTY, tagName, tagSuffix);
                        }
                        valueStart -= fmt.codePoints().map(c -> Character.isSupplementaryCodePoint(c) ? 1 : 0).sum();
                        switch (scalar.getScalarStyle()) {
                            case DOUBLE_QUOTED: 
                            case SINGLE_QUOTED: {
                                scalarValue = reader.readStringFromBuffer(valueStart + 1, event.getEndMark().getIndex() - 2);
                                break;
                            }
                            case PLAIN: {
                                scalarValue = reader.readStringFromBuffer(valueStart, event.getEndMark().getIndex() - 1);
                                break;
                            }
                            case FOLDED: 
                            case LITERAL: {
                                scalarValue = reader.readStringFromBuffer(valueStart + 1, event.getEndMark().getIndex() - 1);
                                if (!scalarValue.endsWith("\n")) break;
                                newLine = "\n";
                                scalarValue = scalarValue.substring(0, scalarValue.length() - 1);
                                break;
                            }
                            default: {
                                scalarValue = reader.readStringFromBuffer(valueStart + 1, event.getEndMark().getIndex() - 1);
                            }
                        }
                        for (Map.Entry entry : helmTemplateByUuid.entrySet()) {
                            if (!scalarValue.contains((CharSequence)entry.getKey())) continue;
                            scalarValue = scalarValue.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                        }
                        if (variableByUuid.containsKey(scalarValue)) {
                            scalarValue = (String)variableByUuid.get(scalarValue);
                        }
                        switch (scalar.getScalarStyle()) {
                            case DOUBLE_QUOTED: {
                                style = Yaml.Scalar.Style.DOUBLE_QUOTED;
                                break;
                            }
                            case SINGLE_QUOTED: {
                                style = Yaml.Scalar.Style.SINGLE_QUOTED;
                                break;
                            }
                            case LITERAL: {
                                style = Yaml.Scalar.Style.LITERAL;
                                break;
                            }
                            case FOLDED: {
                                style = Yaml.Scalar.Style.FOLDED;
                                break;
                            }
                            default: {
                                style = Yaml.Scalar.Style.PLAIN;
                            }
                        }
                        Yaml.Scalar finalScalar = new Yaml.Scalar(Tree.randomId(), fmt, Markers.EMPTY, style, anchor, tag, scalarValue);
                        BlockBuilder blockBuilder = builder = blockStack.isEmpty() ? null : (BlockBuilder)blockStack.peek();
                        if (builder instanceof SequenceBuilder) {
                            SequenceBuilder sequenceBuilder = (SequenceBuilder)builder;
                            String betweenEvents = reader.readStringFromBuffer(event.getEndMark().getIndex(), parser.peekEvent().getStartMark().getIndex() - 1);
                            int commaIndex = YamlParser.commentAwareIndexOf(',', betweenEvents);
                            String commaPrefix = null;
                            if (commaIndex != -1) {
                                commaPrefix = betweenEvents.substring(0, commaIndex);
                            }
                            lastEnd = event.getEndMark().getIndex() + commaIndex + 1;
                            sequenceBuilder.push(finalScalar, commaPrefix);
                            break;
                        }
                        if (builder == null) {
                            if ("".equals(finalScalar.getValue())) break;
                            blockStack.push(new ScalarBuilder(finalScalar, event.getEndMark().getIndex()));
                            break;
                        }
                        builder.push(finalScalar);
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case SequenceEnd: 
                    case MappingEnd: {
                        Yaml.Block mappingOrSequence = ((BlockBuilder)blockStack.pop()).build();
                        if (mappingOrSequence instanceof SequenceWithPrefix) {
                            SequenceWithPrefix seq = (SequenceWithPrefix)mappingOrSequence;
                            if (seq.getOpeningBracketPrefix() != null) {
                                String s = reader.readStringFromBuffer(lastEnd, event.getStartMark().getIndex());
                                int closingBracketIndex = YamlParser.commentAwareIndexOf(']', s);
                                lastEnd = lastEnd + closingBracketIndex + 1;
                                mappingOrSequence = seq.withClosingBracketPrefix(s.substring(0, closingBracketIndex));
                            }
                        } else if (mappingOrSequence instanceof Yaml.Mapping) {
                            Yaml.Mapping map = (Yaml.Mapping)mappingOrSequence;
                            if (map.getOpeningBracePrefix() != null) {
                                String s = reader.readStringFromBuffer(lastEnd, event.getStartMark().getIndex());
                                int closingBraceIndex = YamlParser.commentAwareIndexOf('}', s);
                                lastEnd = lastEnd + closingBraceIndex + 1;
                                mappingOrSequence = map.withClosingBracePrefix(s.substring(0, closingBraceIndex));
                            }
                        } else {
                            throw new IllegalStateException("Unsupported element type: " + mappingOrSequence.getClass());
                        }
                        if (blockStack.isEmpty()) {
                            assert (document != null);
                            document = document.withBlock(mappingOrSequence);
                            break;
                        }
                        ((BlockBuilder)blockStack.peek()).push(mappingOrSequence);
                        break;
                    }
                    case SequenceStart: {
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        newLine = "";
                        SequenceStartEvent sse = (SequenceStartEvent)event;
                        int nextLastEnd = event.getEndMark().getIndex();
                        if (this.shouldUseYamlParserBugWorkaround(sse)) {
                            --nextLastEnd;
                        }
                        Yaml.Anchor anchor = null;
                        if (sse.getAnchor() != null) {
                            anchor = this.buildYamlAnchor(reader, lastEnd, fmt, sse.getAnchor(), nextLastEnd, false);
                            anchors.put(sse.getAnchor(), anchor);
                            lastEnd = lastEnd + sse.getAnchor().length() + fmt.length() + 1;
                            fmt = reader.readStringFromBuffer(lastEnd, nextLastEnd);
                            int dashPrefixIndex = YamlParser.commentAwareIndexOf('-', fmt);
                            if (dashPrefixIndex > -1) {
                                fmt = fmt.substring(0, dashPrefixIndex);
                            }
                        }
                        String fullPrefix = reader.readStringFromBuffer(lastEnd, nextLastEnd);
                        String startBracketPrefix = null;
                        int openingBracketIndex = YamlParser.commentAwareIndexOf('[', fullPrefix);
                        int startIndex = YamlParser.commentAwareIndexOf(Arrays.asList(Character.valueOf(':'), Character.valueOf('-')), fullPrefix) + 1;
                        if (openingBracketIndex != -1) {
                            startBracketPrefix = fullPrefix.substring(startIndex, openingBracketIndex);
                        }
                        Yaml.Tag tag = null;
                        if (sse.getTag() != null) {
                            int i;
                            String prefixAfterColon = fullPrefix.substring(startIndex);
                            int tagStartIndex = prefixAfterColon.indexOf(33);
                            String tagPrefix = prefixAfterColon.substring(0, tagStartIndex);
                            for (i = tagStartIndex; i < prefixAfterColon.length() && !Character.isWhitespace(prefixAfterColon.charAt(i)); ++i) {
                            }
                            String tagName = prefixAfterColon.substring(tagStartIndex, i);
                            String tagSuffix = prefixAfterColon.substring(i, prefixAfterColon.length() - 2);
                            tag = this.createTag(tagPrefix, Markers.EMPTY, tagName, tagSuffix);
                        }
                        lastEnd = nextLastEnd;
                        blockStack.push(new SequenceBuilder(fmt, startBracketPrefix, anchor, tag));
                        break;
                    }
                    case Alias: {
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        newLine = "";
                        AliasEvent alias = (AliasEvent)event;
                        Yaml.Anchor anchor = (Yaml.Anchor)anchors.get(alias.getAnchor());
                        if (anchor == null) {
                            throw new UnsupportedOperationException("Unknown anchor: " + alias.getAnchor());
                        }
                        BlockBuilder builder = (BlockBuilder)blockStack.peek();
                        builder.push(new Yaml.Alias(Tree.randomId(), fmt, Markers.EMPTY, anchor));
                        lastEnd = event.getEndMark().getIndex();
                        break;
                    }
                    case StreamEnd: {
                        String fmt = newLine + reader.prefix(lastEnd, event);
                        if (document != null || fmt.isEmpty()) break;
                        documents2.add(new Yaml.Document(Tree.randomId(), fmt, Markers.EMPTY, false, new Yaml.Mapping(Tree.randomId(), Markers.EMPTY, null, Collections.emptyList(), null, null, null), new Yaml.Document.End(Tree.randomId(), "", Markers.EMPTY, false)));
                        break;
                    }
                }
                event = parser.getEvent();
            }
            documents = new Yaml.Documents(Tree.randomId(), Markers.EMPTY, sourceFile, FileAttributes.fromPath((Path)sourceFile), source.getCharset().name(), source.isCharsetBomMarked(), null, documents2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return documents;
    }

    private boolean shouldUseYamlParserBugWorkaround(SequenceStartEvent event) {
        int startCharIndex = event.getStartMark().getPointer();
        int endCharIndex = event.getEndMark().getPointer();
        if (endCharIndex >= event.getEndMark().getBuffer().length) {
            return false;
        }
        int startChar = event.getStartMark().getBuffer()[startCharIndex];
        int endChar = event.getEndMark().getBuffer()[endCharIndex];
        if (startChar == 38) {
            return event.getEndMark().getBuffer()[endCharIndex - 1] == 45 && endChar != 45;
        }
        return startChar == 45 && endChar != 45;
    }

    private Yaml.Anchor buildYamlAnchor(FormatPreservingReader reader, int lastEnd, String eventPrefix, String anchorKey, int eventEndIndex, boolean isForScalar) {
        char c;
        int anchorLength = isForScalar ? anchorKey.length() + 1 : anchorKey.length();
        String whitespaceAndScalar = reader.prefix(lastEnd + eventPrefix.length() + anchorLength, eventEndIndex);
        StringBuilder postFix = new StringBuilder();
        for (int i = 0; i < whitespaceAndScalar.length() && ((c = whitespaceAndScalar.charAt(i)) == ' ' || c == '\t'); ++i) {
            postFix.append(c);
        }
        int prefixStart = YamlParser.commentAwareIndexOf(':', eventPrefix);
        String prefix = "";
        if (!isForScalar) {
            prefix = prefixStart > -1 && eventPrefix.length() > prefixStart + 1 ? eventPrefix.substring(prefixStart + 1) : "";
        }
        return new Yaml.Anchor(Tree.randomId(), prefix, postFix.toString(), Markers.EMPTY, anchorKey);
    }

    private static int commentAwareIndexOf(char target, String s) {
        return YamlParser.commentAwareIndexOf(Collections.singleton(Character.valueOf(target)), s);
    }

    private static int commentAwareIndexOf(Collection<Character> anyOf, String s) {
        boolean inComment = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inComment) {
                if (c != '\n') continue;
                inComment = false;
                continue;
            }
            if (anyOf.contains(Character.valueOf(c))) {
                return i;
            }
            if (c != '#') continue;
            inComment = true;
        }
        return -1;
    }

    public boolean accept(Path path) {
        String fileName = path.toString();
        return fileName.endsWith(".yml") || fileName.endsWith(".yaml");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.yaml");
    }

    private Yaml.Documents unwrapPrefixedMappings(Yaml.Documents y) {
        return (Yaml.Documents)new YamlIsoVisitor<Integer>(){

            @Override
            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, Integer p) {
                if (sequence instanceof SequenceWithPrefix) {
                    SequenceWithPrefix sequenceWithPrefix = (SequenceWithPrefix)sequence;
                    if (sequenceWithPrefix.getOpeningBracketPrefix() != null) {
                        return super.visitSequence(sequenceWithPrefix.toSequence(), p);
                    }
                    return super.visitSequence(new Yaml.Sequence(sequenceWithPrefix.getId(), sequenceWithPrefix.getMarkers(), sequenceWithPrefix.getOpeningBracketPrefix(), ListUtils.mapFirst(sequenceWithPrefix.getEntries(), e -> e.withPrefix(sequenceWithPrefix.getPrefix())), sequenceWithPrefix.getClosingBracketPrefix(), sequenceWithPrefix.getAnchor(), sequenceWithPrefix.getTag()), p);
                }
                return super.visitSequence(sequence, p);
            }

            @Override
            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, Integer p) {
                if (mapping instanceof MappingWithPrefix) {
                    MappingWithPrefix mappingWithPrefix = (MappingWithPrefix)mapping;
                    return super.visitMapping(new Yaml.Mapping(mappingWithPrefix.getId(), mappingWithPrefix.getMarkers(), mappingWithPrefix.getOpeningBracePrefix(), mappingWithPrefix.getEntries(), null, mappingWithPrefix.getAnchor(), mappingWithPrefix.getTag()), p);
                }
                return super.visitMapping(mapping, p);
            }
        }.visit(y, 0);
    }

    public static Builder builder() {
        return new Builder();
    }

    private Yaml.Tag createTag(String prefix, Markers markers, String text, String suffix) {
        Yaml.Tag.Kind kind;
        String name;
        if (text.startsWith("!<") && text.endsWith(">")) {
            name = text.substring(2, text.length() - 1);
            kind = Yaml.Tag.Kind.EXPLICIT_GLOBAL;
        } else if (text.startsWith("!!")) {
            name = text.substring(2);
            kind = Yaml.Tag.Kind.IMPLICIT_GLOBAL;
        } else if (text.startsWith("!")) {
            name = text.substring(1);
            kind = Yaml.Tag.Kind.LOCAL;
        } else {
            throw new IllegalArgumentException("Invalid tag format: " + text);
        }
        return new Yaml.Tag(Tree.randomId(), prefix, markers, name, suffix, kind);
    }

    private static final class ScalarBuilder
    implements BlockBuilder {
        private final Yaml.Scalar scalar;
        private final int lastEnd;

        @Override
        public void push(Yaml.Block block) {
            throw new IllegalStateException("Unable to push on top of a scalar.");
        }

        @Override
        public Yaml.Block build() {
            return this.scalar;
        }

        @Generated
        public ScalarBuilder(Yaml.Scalar scalar, int lastEnd) {
            this.scalar = scalar;
            this.lastEnd = lastEnd;
        }

        @Generated
        public Yaml.Scalar getScalar() {
            return this.scalar;
        }

        @Generated
        public int getLastEnd() {
            return this.lastEnd;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScalarBuilder)) {
                return false;
            }
            ScalarBuilder other = (ScalarBuilder)o;
            if (this.getLastEnd() != other.getLastEnd()) {
                return false;
            }
            Yaml.Scalar this$scalar = this.getScalar();
            Yaml.Scalar other$scalar = other.getScalar();
            return !(this$scalar == null ? other$scalar != null : !((Object)this$scalar).equals(other$scalar));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLastEnd();
            Yaml.Scalar $scalar = this.getScalar();
            result = result * 59 + ($scalar == null ? 43 : ((Object)$scalar).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "YamlParser.ScalarBuilder(scalar=" + this.getScalar() + ", lastEnd=" + this.getLastEnd() + ")";
        }
    }

    private static class MappingBuilder
    implements BlockBuilder {
        private final String prefix;
        private final @Nullable String startBracePrefix;
        private final  @Nullable Yaml.Anchor anchor;
        private final  @Nullable Yaml.Tag tag;
        private final List<Yaml.Mapping.Entry> entries = new ArrayList<Yaml.Mapping.Entry>();
        private @Nullable YamlKey key;

        private MappingBuilder(String prefix, @Nullable String startBracePrefix,  @Nullable Yaml.Anchor anchor,  @Nullable Yaml.Tag tag) {
            this.prefix = prefix;
            this.startBracePrefix = startBracePrefix;
            this.anchor = anchor;
            this.tag = tag;
        }

        @Override
        public void push(Yaml.Block block) {
            if (this.key == null && block instanceof Yaml.Scalar) {
                this.key = (Yaml.Scalar)block;
            } else if (this.key == null && block instanceof Yaml.Alias) {
                this.key = (Yaml.Alias)block;
            } else {
                String keySuffix = block.getPrefix();
                block = block.withPrefix(keySuffix.substring(YamlParser.commentAwareIndexOf(':', keySuffix) + 1));
                String originalKeyPrefix = this.key.getPrefix();
                this.key = this.key.withPrefix("");
                int entryPrefixStartIndex = Math.max(YamlParser.commentAwareIndexOf('-', originalKeyPrefix), YamlParser.commentAwareIndexOf(':', originalKeyPrefix)) + 1;
                String entryPrefix = originalKeyPrefix.substring(entryPrefixStartIndex);
                String beforeMappingValueIndicator = keySuffix.substring(0, Math.max(YamlParser.commentAwareIndexOf(':', keySuffix), 0));
                this.entries.add(new Yaml.Mapping.Entry(Tree.randomId(), entryPrefix, Markers.EMPTY, this.key, beforeMappingValueIndicator, block));
                this.key = null;
            }
        }

        @Override
        public MappingWithPrefix build() {
            return new MappingWithPrefix(this.prefix, this.startBracePrefix, this.entries, null, this.anchor, this.tag);
        }
    }

    private static interface BlockBuilder {
        public Yaml.Block build();

        public void push(Yaml.Block var1);
    }

    private static class SequenceBuilder
    implements BlockBuilder {
        private final String prefix;
        private final @Nullable String startBracketPrefix;
        private final  @Nullable Yaml.Anchor anchor;
        private final  @Nullable Yaml.Tag tag;
        private final List<Yaml.Sequence.Entry> entries = new ArrayList<Yaml.Sequence.Entry>();

        private SequenceBuilder(String prefix, @Nullable String startBracketPrefix,  @Nullable Yaml.Anchor anchor,  @Nullable Yaml.Tag tag) {
            this.prefix = prefix;
            this.startBracketPrefix = startBracketPrefix;
            this.anchor = anchor;
            this.tag = tag;
        }

        @Override
        public void push(Yaml.Block block) {
            this.push(block, null);
        }

        public void push(Yaml.Block block, @Nullable String commaPrefix) {
            String blockPrefix;
            String entryPrefix;
            boolean hasDash;
            String rawPrefix = block.getPrefix();
            int dashIndex = YamlParser.commentAwareIndexOf('-', rawPrefix);
            boolean bl = hasDash = dashIndex != -1;
            if (hasDash) {
                entryPrefix = rawPrefix.substring(0, dashIndex);
                blockPrefix = rawPrefix.substring(dashIndex + 1);
            } else {
                entryPrefix = "";
                blockPrefix = rawPrefix;
            }
            this.entries.add(new Yaml.Sequence.Entry(Tree.randomId(), entryPrefix, Markers.EMPTY, block.withPrefix(blockPrefix), hasDash, commaPrefix));
        }

        @Override
        public SequenceWithPrefix build() {
            return new SequenceWithPrefix(this.prefix, this.startBracketPrefix, this.entries, null, this.anchor, this.tag);
        }
    }

    private static class SequenceWithPrefix
    extends Yaml.Sequence {
        private String prefix;

        public SequenceWithPrefix(String prefix, @Nullable String startBracketPrefix, List<Yaml.Sequence.Entry> entries, @Nullable String endBracketPrefix,  @Nullable Yaml.Anchor anchor,  @Nullable Yaml.Tag tag) {
            super(Tree.randomId(), Markers.EMPTY, startBracketPrefix, entries, endBracketPrefix, anchor, tag);
            this.prefix = prefix;
        }

        public SequenceWithPrefix(UUID id, Markers markers, @Nullable String openingBracketPrefix, List<Yaml.Sequence.Entry> entries, @Nullable String closingBracketPrefix,  @Nullable Yaml.Anchor anchor,  @Nullable Yaml.Tag tag, String prefix) {
            super(id, markers, openingBracketPrefix, entries, closingBracketPrefix, anchor, tag);
            this.prefix = prefix;
        }

        @Override
        public Yaml.Sequence withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public SequenceWithPrefix withClosingBracketPrefix(@Nullable String closingBracketPrefix) {
            return new SequenceWithPrefix(this.getId(), this.getMarkers(), this.getOpeningBracketPrefix(), this.getEntries(), closingBracketPrefix, this.getAnchor(), this.getTag(), this.prefix);
        }

        public Yaml.Sequence toSequence() {
            return new Yaml.Sequence(this.getId(), this.getMarkers(), this.getOpeningBracketPrefix(), this.getEntries(), this.getClosingBracketPrefix(), this.getAnchor(), this.getTag());
        }

        @Override
        @Generated
        public String getPrefix() {
            return this.prefix;
        }
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(Yaml.Documents.class);
        }

        public YamlParser build() {
            return new YamlParser();
        }

        public String getDslName() {
            return "yaml";
        }
    }

    private static class MappingWithPrefix
    extends Yaml.Mapping {
        private String prefix;

        public MappingWithPrefix(String prefix, @Nullable String startBracePrefix, List<Yaml.Mapping.Entry> entries, @Nullable String endBracePrefix,  @Nullable Yaml.Anchor anchor,  @Nullable Yaml.Tag tag) {
            super(Tree.randomId(), Markers.EMPTY, startBracePrefix, entries, endBracePrefix, anchor, tag);
            this.prefix = prefix;
        }

        @Override
        public Yaml.Mapping withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        @Generated
        public String getPrefix() {
            return this.prefix;
        }
    }
}

