
    create table DBSINGULAR.RL_HIST_CONT_REQ_VER_ANOTACAO (
        CO_HISTORICO bigint not null,
        CO_VERSAO_ANOTACAO bigint not null
    ); 

    create table DBSINGULAR.RL_PAPEL_TAREFA (
        CO_PAPEL_TAREFA integer generated by default as identity,
        CO_DEFINICAO_PAPEL integer not null,
        CO_DEFINICAO_TAREFA integer not null,
        primary key (CO_PAPEL_TAREFA)
    ); 

    create table DBSINGULAR.RL_PERMISSAO_PROCESSO (
        CO_DEFINICAO_PROCESSO integer not null,
        TP_PERMISSAO char(255) not null,
        primary key (CO_DEFINICAO_PROCESSO, TP_PERMISSAO),
        check (TP_PERMISSAO IN ('A', 'I', 'C', 'R'))
    ); 

    create table DBSINGULAR.RL_PERMISSAO_TAREFA (
        CO_PERMISSAO_TAREFA integer generated by default as identity,
        CO_PERMISSAO varchar(500) not null,
        CO_DEFINICAO_TAREFA integer not null,
        primary key (CO_PERMISSAO_TAREFA)
    ); 

    create table DBSINGULAR.TB_ANEXO_FORMULARIO (
        CO_ARQUIVO bigint not null,
        CO_VERSAO_FORMULARIO bigint not null,
        primary key (CO_ARQUIVO, CO_VERSAO_FORMULARIO)
    ); 

    create table DBSINGULAR.TB_ANOTACAO_FORMULARIO (
        CO_CHAVE_ANOTACAO varchar(200) not null,
        CO_VERSAO_FORMULARIO bigint not null,
        CO_VERSAO_ANOTACAO_ATUAL bigint,
        primary key (CO_CHAVE_ANOTACAO, CO_VERSAO_FORMULARIO)
    ); 

    create table DBSINGULAR.TB_ARQUIVO (
        CO_ARQUIVO bigint generated by default as identity,
        CO_CONTEUDO_ARQUIVO bigint not null,
        DT_CRIACAO timestamp not null,
        TX_SHA1 varchar(40) not null,
        NO_ARQUIVO varchar(200) not null,
        NU_BYTES bigint not null,
        primary key (CO_ARQUIVO)
    ); 

    create table DBSINGULAR.TB_CACHE_CAMPO (
        CO_CACHE_CAMPO bigint generated by default as identity,
        DS_CAMINHO_CAMPO varchar(255),
        CO_TIPO_FORMULARIO bigint,
        primary key (CO_CACHE_CAMPO)
    ); 

    create table DBSINGULAR.TB_CACHE_VALOR (
        CO_CACHE_VALOR bigint generated by default as identity,
        DT_VALOR timestamp,
        NU_VALOR decimal(19,2),
        DS_VALOR varchar(1024),
        CO_CACHE_CAMPO bigint,
        CO_VERSAO_FORMULARIO bigint,
        CO_PARENT bigint,
        primary key (CO_CACHE_VALOR)
    ); 

    create table DBSINGULAR.TB_CAIXA (
        CO_CAIXA bigint generated by default as identity,
        DS_CAIXA varchar(500),
        NO_ICONE varchar(100) not null,
        NO_CAIXA varchar(100) not null,
        CO_MODULO varchar(30) not null,
        primary key (CO_CAIXA)
    ); 

    create table DBSINGULAR.TB_CATEGORIA (
        CO_CATEGORIA integer generated by default as identity,
        NO_CATEGORIA varchar(100) not null,
        primary key (CO_CATEGORIA)
    ); 

    create table DBSINGULAR.TB_CONTEUDO_ARQUIVO (
        CO_CONTEUDO_ARQUIVO bigint generated by default as identity,
        BL_CONTEUDO blob not null,
        TX_SHA1 varchar(40) not null,
        DT_INCLUSAO timestamp not null,
        NU_BYTES bigint not null,
        primary key (CO_CONTEUDO_ARQUIVO)
    ); 

    create table DBSINGULAR.TB_DEFINICAO_PAPEL (
        CO_DEFINICAO_PAPEL integer generated by default as identity,
        SG_PAPEL varchar(100) not null,
        NO_PAPEL varchar(300) not null,
        CO_DEFINICAO_PROCESSO integer not null,
        primary key (CO_DEFINICAO_PAPEL)
    ); 

    create table DBSINGULAR.TB_DEFINICAO_PROCESSO (
        CO_DEFINICAO_PROCESSO integer generated by default as identity,
        NO_CLASSE_JAVA varchar(500) not null,
        SG_PROCESSO varchar(200) not null,
        NO_PROCESSO varchar(200) not null,
        CO_CATEGORIA integer,
        CO_MODULO varchar(30) not null,
        primary key (CO_DEFINICAO_PROCESSO)
    ); 

    create table DBSINGULAR.TB_DEFINICAO_REQUISICAO (
        CO_DEFINICAO_REQUISICAO bigint generated by default as identity,
        NO_DEFINICAO_REQUISICAO varchar(300) not null,
        CO_TIPO_FORMULARIO bigint not null,
        CO_MODULO varchar(30) not null,
        primary key (CO_DEFINICAO_REQUISICAO)
    ); 

    create table DBSINGULAR.TB_DEFINICAO_TAREFA (
        CO_DEFINICAO_TAREFA integer generated by default as identity,
        SG_TAREFA varchar(100) not null,
        TP_ESTRATEGIA_SEGURANCA varchar(1),
        CO_DEFINICAO_PROCESSO integer not null,
        primary key (CO_DEFINICAO_TAREFA),
        check (TP_ESTRATEGIA_SEGURANCA IS NULL OR (TP_ESTRATEGIA_SEGURANCA IN ('D','E')))
    ); 

    create table DBSINGULAR.TB_DESTINATARIO_EMAIL (
        CO_DESTINATARIO_EMAIL bigint generated by default as identity,
        TX_ENDERECO varchar(100) not null,
        TP_ENVIO varchar(3) not null,
        DT_ENVIO timestamp,
        CO_EMAIL bigint not null,
        primary key (CO_DESTINATARIO_EMAIL),
        check (TP_ENVIO IN ('To','Cc','Bcc'))
    ); 

    create table DBSINGULAR.TB_EMAIL (
        CO_EMAIL bigint generated by default as identity,
        TX_CONTEUDO clob not null,
        DT_CRIACAO timestamp not null,
        CO_MODULO varchar(30),
        TX_RESPONDER_PARA varchar(200),
        TX_ASSUNTO varchar(200) not null,
        primary key (CO_EMAIL)
    ); 

    create table DBSINGULAR.TB_EMAIL_ARQUIVO (
        CO_EMAIL bigint not null,
        CO_ARQUIVO bigint not null
    ); 

    create table DBSINGULAR.TB_FORMULARIO (
        CO_FORMULARIO bigint generated by default as identity,
        CO_VERSAO_ATUAL bigint,
        CO_TIPO_FORMULARIO bigint not null,
        primary key (CO_FORMULARIO)
    ); 

    create table DBSINGULAR.TB_FORMULARIO_REQUISICAO (
        CO_FORMULARIO_REQUISICAO bigint generated by default as identity,
        ST_FORM_PRINCIPAL varchar(1) not null,
        CO_RASCUNHO_ATUAL bigint,
        CO_FORMULARIO bigint,
        CO_REQUISICAO bigint not null,
        CO_DEFINICAO_TAREFA integer,
        primary key (CO_FORMULARIO_REQUISICAO),
        check (ST_FORM_PRINCIPAL IN ('S','N'))
    ); 

    create table DBSINGULAR.TB_FUNCIONALIDADE_REQUISICAO (
        CO_FUNCIONALIDADE varchar(300) not null,
        CO_MODULO_SINGULAR varchar(50) not null,
        CO_PERMISSAO varchar(50) not null,
        primary key (CO_FUNCIONALIDADE, CO_MODULO_SINGULAR, CO_PERMISSAO)
    ); 

    create table DBSINGULAR.TB_HISTORICO_CONTEUDO_REQUISIC (
        CO_HISTORICO bigint generated by default as identity,
        DT_HISTORICO timestamp not null,
        CO_AUTOR integer,
        CO_REQUISITANTE bigint,
        CO_REQUISICAO bigint not null,
        CO_INSTANCIA_TAREFA integer,
        primary key (CO_HISTORICO)
    ); 

    create table DBSINGULAR.TB_HISTORICO_INSTANCIA_TAREFA (
        CO_HISTORICO_ALOCACAO integer generated by default as identity,
        DT_INICIO_ALOCACAO timestamp not null,
        DS_COMPLEMENTO varchar(8000),
        DT_FIM_ALOCACAO timestamp,
        CO_ATOR_ALOCADO integer,
        CO_ATOR_ALOCADOR integer,
        CO_INSTANCIA_TAREFA integer not null,
        CO_TIPO_HISTORICO_TAREFA integer not null,
        primary key (CO_HISTORICO_ALOCACAO)
    ); 

    create table DBSINGULAR.TB_HISTORICO_VERSAO_FORMULARIO (
        CO_VERSAO_FORMULARIO bigint not null,
        CO_HISTORICO bigint not null,
        ST_FORM_PRINCIPAL varchar(1) not null,
        primary key (CO_VERSAO_FORMULARIO, CO_HISTORICO)
    ); 

    create table DBSINGULAR.TB_INSTANCIA_PAPEL (
        CO_INSTANCIA_PAPEL integer generated by default as identity,
        DT_CRIACAO timestamp not null,
        CO_ATOR_ALOCADOR integer,
        CO_INSTANCIA_PROCESSO integer not null,
        CO_DEFINICAO_PAPEL integer not null,
        CO_ATOR integer not null,
        primary key (CO_INSTANCIA_PAPEL)
    ); 

    create table DBSINGULAR.TB_INSTANCIA_PROCESSO (
        CO_INSTANCIA_PROCESSO integer generated by default as identity,
        DT_INICIO timestamp not null,
        DS_INSTANCIA_PROCESSO varchar(300),
        DT_FIM timestamp,
        CO_VERSAO_PROCESSO integer not null,
        CO_INSTANCIA_TAREFA_PAI integer,
        CO_ATOR_CRIADOR integer,
        primary key (CO_INSTANCIA_PROCESSO)
    ); 

    create table DBSINGULAR.TB_INSTANCIA_TAREFA (
        CO_INSTANCIA_TAREFA integer generated by default as identity,
        DT_INICIO timestamp not null,
        TP_CURRENT_INSTANCE varchar(1) default 'X' not null,
        DT_FIM timestamp,
        DT_ESPERADA_FIM timestamp,
        NU_VERSAO integer,
        CO_ATOR_ALOCADO integer,
        CO_VERSAO_TRANSICAO_EXECUTADA integer,
        CO_INSTANCIA_PROCESSO integer not null,
        CO_ATOR_CONCLUSAO integer,
        CO_VERSAO_TAREFA integer not null,
        primary key (CO_INSTANCIA_TAREFA),
        check (TP_CURRENT_INSTANCE IN ('S', 'N', 'X'))
    ); 

    create table DBSINGULAR.TB_MODULO (
        CO_MODULO varchar(30) not null,
        URL_CONEXAO varchar(300) not null,
        NO_MODULO varchar(100) not null,
        primary key (CO_MODULO)
    ); 

    create table DBSINGULAR.TB_PARAMETRO (
        CO_PARAMETRO bigint generated by default as identity,
        NO_PARAMETRO varchar(100) not null,
        VL_PARAMETRO varchar(1000) not null,
        CO_MODULO varchar(30) not null,
        primary key (CO_PARAMETRO)
    ); 

    create table DBSINGULAR.TB_RASCUNHO (
        CO_RASCUNHO bigint generated by default as identity,
        DT_EDICAO timestamp not null,
        DT_INICIO timestamp not null,
        CO_FORMULARIO bigint not null,
        primary key (CO_RASCUNHO)
    ); 

    create table DBSINGULAR.TB_REQUISICAO (
        CO_REQUISICAO bigint generated by default as identity,
        DS_REQUISICAO varchar(200),
        CO_REQUISITANTE bigint,
        CO_DEFINICAO_PROCESSO integer,
        CO_INSTANCIA_PROCESSO integer,
        CO_REQUISICAO_PAI bigint,
        CO_DEFINICAO_REQUISICAO bigint not null,
        CO_REQUISICAO_RAIZ bigint,
        primary key (CO_REQUISICAO)
    ); 

    create table DBSINGULAR.TB_REQUISITANTE (
        CO_REQUISITANTE bigint generated by default as identity,
        NU_CPF_CNPJ varchar(14),
        ID_PESSOA varchar(200) not null,
        DS_NOME varchar(200) not null,
        TP_PESSOA varchar(1) default 'J' not null,
        primary key (CO_REQUISITANTE),
        check (TP_PESSOA IN ('J','F'))
    ); 

    create table DBSINGULAR.TB_TIPO_FORMULARIO (
        CO_TIPO_FORMULARIO bigint generated by default as identity,
        SG_TIPO_FORMULARIO varchar(200) not null,
        NU_VERSAO_CACHE bigint not null,
        NO_LABEL_FORMULARIO varchar(200),
        primary key (CO_TIPO_FORMULARIO)
    ); 

    create table DBSINGULAR.TB_TIPO_HISTORICO_TAREFA (
        CO_TIPO_HISTORICO_TAREFA integer generated by default as identity,
        DS_TIPO_HISTORICO_TAREFA varchar(100) not null,
        primary key (CO_TIPO_HISTORICO_TAREFA)
    ); 

    create table DBSINGULAR.TB_TIPO_VARIAVEL (
        CO_TIPO_VARIAVEL integer generated by default as identity,
        DS_TIPO_VARIAVEL varchar(100) not null,
        NO_CLASSE_JAVA varchar(300) not null,
        primary key (CO_TIPO_VARIAVEL)
    ); 

    create table DBSINGULAR.TB_VARIAVEL (
        CO_VARIAVEL integer generated by default as identity,
        NO_VARIAVEL varchar(100) not null,
        VL_VARIAVEL clob,
        CO_INSTANCIA_PROCESSO integer not null,
        CO_TIPO_VARIAVEL integer not null,
        primary key (CO_VARIAVEL)
    ); 

    create table DBSINGULAR.TB_VARIAVEL_EXECUCAO_TRANSICAO (
        CO_VARIAVEL_EXECUCAO_TRANSICAO integer generated by default as identity,
        DT_HISTORICO timestamp not null,
        NO_VARIAVEL varchar(100) not null,
        VL_NOVO varchar(8000),
        CO_INSTANCIA_TAREFA_DESTINO integer not null,
        CO_INSTANCIA_PROCESSO integer not null,
        CO_INSTANCIA_TAREFA_ORIGEM integer not null,
        CO_TIPO_VARIAVEL integer not null,
        CO_VARIAVEL integer,
        primary key (CO_VARIAVEL_EXECUCAO_TRANSICAO)
    ); 

    create table DBSINGULAR.TB_VERSAO_ANOTACAO_FORMULARIO (
        CO_VERSAO_ANOTACAO bigint generated by default as identity,
        CO_AUTOR_INCLUSAO integer,
        DT_INCLUSAO timestamp not null,
        XML_ANOTACAO clob not null,
        CO_CHAVE_ANOTACAO varchar(200) not null,
        CO_VERSAO_FORMULARIO bigint not null,
        primary key (CO_VERSAO_ANOTACAO)
    ); 

    create table DBSINGULAR.TB_VERSAO_FORMULARIO (
        CO_VERSAO_FORMULARIO bigint generated by default as identity,
        NU_VERSAO_CACHE bigint,
        CO_AUTOR_INCLUSAO integer,
        DT_INCLUSAO timestamp not null,
        ST_INDEXADO char(255),
        XML_CONTEUDO clob not null,
        CO_FORMULARIO bigint not null,
        primary key (CO_VERSAO_FORMULARIO)
    ); 

    create table DBSINGULAR.TB_VERSAO_PROCESSO (
        CO_VERSAO_PROCESSO integer generated by default as identity,
        DT_VERSAO timestamp not null,
        CO_DEFINICAO_PROCESSO integer not null,
        primary key (CO_VERSAO_PROCESSO)
    ); 

    create table DBSINGULAR.TB_VERSAO_TAREFA (
        CO_VERSAO_TAREFA integer generated by default as identity,
        NO_TAREFA varchar(300) not null,
        CO_TIPO_TAREFA integer not null,
        CO_VERSAO_PROCESSO integer not null,
        CO_DEFINICAO_TAREFA integer not null,
        primary key (CO_VERSAO_TAREFA)
    ); 

    create table DBSINGULAR.TB_VERSAO_TRANSICAO (
        CO_VERSAO_TRANSICAO integer generated by default as identity,
        SG_TRANSICAO varchar(100) not null,
        NO_TRANSICAO varchar(300) not null,
        TP_TRANSICAO varchar(1) default 'E' not null,
        CO_VERSAO_TAREFA_DESTINO integer not null,
        CO_VERSAO_TAREFA_ORIGEM integer not null,
        primary key (CO_VERSAO_TRANSICAO)
    ); 

    alter table DBSINGULAR.RL_HIST_CONT_REQ_VER_ANOTACAO 
        add constraint UK_HIST_CONT_REQ_VER_ANOT unique (CO_VERSAO_ANOTACAO, CO_HISTORICO); 

    create index IX_CLASSE_DEFINICAO on DBSINGULAR.TB_DEFINICAO_PROCESSO (NO_CLASSE_JAVA asc); 

    create index TB_DEFINICAO_REQUISICAO on DBSINGULAR.TB_DEFINICAO_REQUISICAO (CO_MODULO asc, NO_DEFINICAO_REQUISICAO asc); 

    alter table DBSINGULAR.TB_EMAIL_ARQUIVO 
        add constraint UK_EMAIL_ARQUIVO unique (CO_ARQUIVO); 

    create index IX_FORMULARIO_PRINCIPAL on DBSINGULAR.TB_FORMULARIO_REQUISICAO (ST_FORM_PRINCIPAL asc, CO_REQUISICAO asc); 

    create index IX_HISTORICO_INSTANCIA_TAREFA on DBSINGULAR.TB_HISTORICO_INSTANCIA_TAREFA (CO_INSTANCIA_TAREFA asc, DT_INICIO_ALOCACAO asc); 

    create index IX_INSTANCIA_PROCESSO on DBSINGULAR.TB_INSTANCIA_PROCESSO (CO_VERSAO_PROCESSO asc, DT_INICIO asc); 

    create index IX_GRUPO_NOME on DBSINGULAR.TB_MODULO (NO_MODULO asc); 

    create index IX_GRUPO_CONEXAO on DBSINGULAR.TB_MODULO (URL_CONEXAO asc); 

    create index IX_PARAMETRO on DBSINGULAR.TB_PARAMETRO (CO_MODULO asc, NO_PARAMETRO asc); 

    create index IX_TIPO_FORMULARIO on DBSINGULAR.TB_TIPO_FORMULARIO (SG_TIPO_FORMULARIO asc); 

    create index IX_PROCESSO on DBSINGULAR.TB_VERSAO_PROCESSO (CO_DEFINICAO_PROCESSO asc, DT_VERSAO asc); 

    alter table DBSINGULAR.RL_HIST_CONT_REQ_VER_ANOTACAO 
        add constraint FK_VER_ANOTACAO_HIST_CONT_REQ 
        foreign key (CO_VERSAO_ANOTACAO) 
        references DBSINGULAR.TB_VERSAO_ANOTACAO_FORMULARIO; 

    alter table DBSINGULAR.RL_HIST_CONT_REQ_VER_ANOTACAO 
        add constraint FK_HIST_CONT_REQ_VER_ANOTACAO 
        foreign key (CO_HISTORICO) 
        references DBSINGULAR.TB_HISTORICO_CONTEUDO_REQUISIC; 

    alter table DBSINGULAR.RL_PAPEL_TAREFA 
        add constraint FK_PPL_TAR_DEFINICAO_PAPEL 
        foreign key (CO_DEFINICAO_PAPEL) 
        references DBSINGULAR.TB_DEFINICAO_PAPEL; 

    alter table DBSINGULAR.RL_PAPEL_TAREFA 
        add constraint FK_PPL_TAR_DEFINICAO_TAREFA 
        foreign key (CO_DEFINICAO_TAREFA) 
        references DBSINGULAR.TB_DEFINICAO_TAREFA; 

    alter table DBSINGULAR.RL_PERMISSAO_PROCESSO 
        add constraint FK_PERM_PROCES_DEFI_PROCES 
        foreign key (CO_DEFINICAO_PROCESSO) 
        references DBSINGULAR.TB_DEFINICAO_PROCESSO; 

    alter table DBSINGULAR.RL_PERMISSAO_TAREFA 
        add constraint FK_PERM_TAR_DEFINICAO_TAREFA 
        foreign key (CO_DEFINICAO_TAREFA) 
        references DBSINGULAR.TB_DEFINICAO_TAREFA; 

    alter table DBSINGULAR.TB_ANEXO_FORMULARIO 
        add constraint FK_ANX_FORM_CO_ARQUIVO 
        foreign key (CO_ARQUIVO) 
        references DBSINGULAR.TB_ARQUIVO; 

    alter table DBSINGULAR.TB_ANEXO_FORMULARIO 
        add constraint FK_ANX_FORM_VERSAO_FORMULARIO 
        foreign key (CO_VERSAO_FORMULARIO) 
        references DBSINGULAR.TB_VERSAO_FORMULARIO; 

    alter table DBSINGULAR.TB_ANOTACAO_FORMULARIO 
        add constraint FK_ANOT_FORM_VERSAO_FORMULARIO 
        foreign key (CO_VERSAO_FORMULARIO) 
        references DBSINGULAR.TB_VERSAO_FORMULARIO; 

    alter table DBSINGULAR.TB_ANOTACAO_FORMULARIO 
        add constraint FK_ANOT_FORM_VER_ANOT_ATUAL 
        foreign key (CO_VERSAO_ANOTACAO_ATUAL) 
        references DBSINGULAR.TB_VERSAO_ANOTACAO_FORMULARIO; 

    alter table DBSINGULAR.TB_CACHE_CAMPO 
        add constraint FK_CACHE_CAMPO_TIPO_FORMULARIO 
        foreign key (CO_TIPO_FORMULARIO) 
        references DBSINGULAR.TB_TIPO_FORMULARIO; 

    alter table DBSINGULAR.TB_CACHE_VALOR 
        add constraint FK_CACHE_VALOR_CACHE_CAMPO 
        foreign key (CO_CACHE_CAMPO) 
        references DBSINGULAR.TB_CACHE_CAMPO; 

    alter table DBSINGULAR.TB_CACHE_VALOR 
        add constraint FK_CACHE_VAL_VERSAO_FORMULARIO 
        foreign key (CO_VERSAO_FORMULARIO) 
        references DBSINGULAR.TB_VERSAO_FORMULARIO; 

    alter table DBSINGULAR.TB_CACHE_VALOR 
        add constraint FK_CACHE_VALOR_CO_PARENT 
        foreign key (CO_PARENT) 
        references DBSINGULAR.TB_CACHE_VALOR; 

    alter table DBSINGULAR.TB_CAIXA 
        add constraint FK_CAIXA_CO_MODULO 
        foreign key (CO_MODULO) 
        references DBSINGULAR.TB_MODULO; 

    alter table DBSINGULAR.TB_DEFINICAO_PAPEL 
        add constraint FK_DEFI_PPL_DEFINICAO_PROCESSO 
        foreign key (CO_DEFINICAO_PROCESSO) 
        references DBSINGULAR.TB_DEFINICAO_PROCESSO; 

    alter table DBSINGULAR.TB_DEFINICAO_PROCESSO 
        add constraint FK_DEFIN_PROCES_CATEGORIA 
        foreign key (CO_CATEGORIA) 
        references DBSINGULAR.TB_CATEGORIA; 

    alter table DBSINGULAR.TB_DEFINICAO_PROCESSO 
        add constraint FK_DEFIN_PROCES_MODULO 
        foreign key (CO_MODULO) 
        references DBSINGULAR.TB_MODULO; 

    alter table DBSINGULAR.TB_DEFINICAO_REQUISICAO 
        add constraint FK_DEFI_REQ_TIPO_FORMULARIO 
        foreign key (CO_TIPO_FORMULARIO) 
        references DBSINGULAR.TB_TIPO_FORMULARIO; 

    alter table DBSINGULAR.TB_DEFINICAO_REQUISICAO 
        add constraint FK_DEFI_REQ_MODULO 
        foreign key (CO_MODULO) 
        references DBSINGULAR.TB_MODULO; 

    alter table DBSINGULAR.TB_DEFINICAO_TAREFA 
        add constraint FK_DEFI_TAR_DEFINICAO_PROCESSO 
        foreign key (CO_DEFINICAO_PROCESSO) 
        references DBSINGULAR.TB_DEFINICAO_PROCESSO; 

    alter table DBSINGULAR.TB_DESTINATARIO_EMAIL 
        add constraint FK_DESTINATARIO_EMAIL_CO_EMAIL 
        foreign key (CO_EMAIL) 
        references DBSINGULAR.TB_EMAIL; 

    alter table DBSINGULAR.TB_EMAIL_ARQUIVO 
        add constraint FK_EMAIL_ARQUIVO_ARQUIVO 
        foreign key (CO_ARQUIVO) 
        references DBSINGULAR.TB_ARQUIVO; 

    alter table DBSINGULAR.TB_EMAIL_ARQUIVO 
        add constraint FK_EMAIL_ARQUIVO_EMAIL 
        foreign key (CO_EMAIL) 
        references DBSINGULAR.TB_EMAIL; 

    alter table DBSINGULAR.TB_FORMULARIO 
        add constraint FK_FORMULARIO_VERSAO_ATUAL 
        foreign key (CO_VERSAO_ATUAL) 
        references DBSINGULAR.TB_VERSAO_FORMULARIO; 

    alter table DBSINGULAR.TB_FORMULARIO 
        add constraint FK_FORMULARIO_TIPO_FORMULARIO 
        foreign key (CO_TIPO_FORMULARIO) 
        references DBSINGULAR.TB_TIPO_FORMULARIO; 

    alter table DBSINGULAR.TB_FORMULARIO_REQUISICAO 
        add constraint FK_FORM_REQ_RASCUNHO_ATUAL 
        foreign key (CO_RASCUNHO_ATUAL) 
        references DBSINGULAR.TB_RASCUNHO; 

    alter table DBSINGULAR.TB_FORMULARIO_REQUISICAO 
        add constraint FK_FORM_REQ_FORMULARIO 
        foreign key (CO_FORMULARIO) 
        references DBSINGULAR.TB_FORMULARIO; 

    alter table DBSINGULAR.TB_FORMULARIO_REQUISICAO 
        add constraint FK_FORMO_REQ_REQUISICAO 
        foreign key (CO_REQUISICAO) 
        references DBSINGULAR.TB_REQUISICAO; 

    alter table DBSINGULAR.TB_FORMULARIO_REQUISICAO 
        add constraint FK_FORM_REQ_DEFINICAO_TAREFA 
        foreign key (CO_DEFINICAO_TAREFA) 
        references DBSINGULAR.TB_DEFINICAO_TAREFA; 

    alter table DBSINGULAR.TB_HISTORICO_CONTEUDO_REQUISIC 
        add constraint FK_HIST_CTD_REQ_REQUISITANTE 
        foreign key (CO_REQUISITANTE) 
        references DBSINGULAR.TB_REQUISITANTE; 

    alter table DBSINGULAR.TB_HISTORICO_CONTEUDO_REQUISIC 
        add constraint FK_HIST_CTD_REQ_REQ 
        foreign key (CO_REQUISICAO) 
        references DBSINGULAR.TB_REQUISICAO; 

    alter table DBSINGULAR.TB_HISTORICO_CONTEUDO_REQUISIC 
        add constraint FK_HIST_CTD_REQ_INSTANCIA_TRF 
        foreign key (CO_INSTANCIA_TAREFA) 
        references DBSINGULAR.TB_INSTANCIA_TAREFA; 

    alter table DBSINGULAR.TB_HISTORICO_INSTANCIA_TAREFA 
        add constraint FK_HIST_INST_TAR_INST_TAR 
        foreign key (CO_INSTANCIA_TAREFA) 
        references DBSINGULAR.TB_INSTANCIA_TAREFA; 

    alter table DBSINGULAR.TB_HISTORICO_INSTANCIA_TAREFA 
        add constraint FK_HIST_INST_TAR_TP_HIST_TAR 
        foreign key (CO_TIPO_HISTORICO_TAREFA) 
        references DBSINGULAR.TB_TIPO_HISTORICO_TAREFA; 

    alter table DBSINGULAR.TB_HISTORICO_VERSAO_FORMULARIO 
        add constraint FK_HIST_VER_FORM_VER_FORM 
        foreign key (CO_VERSAO_FORMULARIO) 
        references DBSINGULAR.TB_VERSAO_FORMULARIO; 

    alter table DBSINGULAR.TB_HISTORICO_VERSAO_FORMULARIO 
        add constraint FK_HIST_VER_FORM_HISTORICO 
        foreign key (CO_HISTORICO) 
        references DBSINGULAR.TB_HISTORICO_CONTEUDO_REQUISIC; 

    alter table DBSINGULAR.TB_INSTANCIA_PAPEL 
        add constraint FK_INST_PPL_INSTANCIA_PROCESSO 
        foreign key (CO_INSTANCIA_PROCESSO) 
        references DBSINGULAR.TB_INSTANCIA_PROCESSO; 

    alter table DBSINGULAR.TB_INSTANCIA_PAPEL 
        add constraint FK_INST_PPL_DEFINICAO_PAPEL 
        foreign key (CO_DEFINICAO_PAPEL) 
        references DBSINGULAR.TB_DEFINICAO_PAPEL; 

    alter table DBSINGULAR.TB_INSTANCIA_PROCESSO 
        add constraint FK_INST_PROCES_VERSAO_PROCESSO 
        foreign key (CO_VERSAO_PROCESSO) 
        references DBSINGULAR.TB_VERSAO_PROCESSO; 

    alter table DBSINGULAR.TB_INSTANCIA_PROCESSO 
        add constraint FK_INST_PROCES_INST_TAR_PAI 
        foreign key (CO_INSTANCIA_TAREFA_PAI) 
        references DBSINGULAR.TB_INSTANCIA_TAREFA; 

    alter table DBSINGULAR.TB_INSTANCIA_TAREFA 
        add constraint FK_INST_TAR_VER_TRAN_EXEC 
        foreign key (CO_VERSAO_TRANSICAO_EXECUTADA) 
        references DBSINGULAR.TB_VERSAO_TRANSICAO; 

    alter table DBSINGULAR.TB_INSTANCIA_TAREFA 
        add constraint FK_INST_TAR_PROCES_ATOR_CRIDR 
        foreign key (CO_INSTANCIA_PROCESSO) 
        references DBSINGULAR.TB_INSTANCIA_PROCESSO; 

    alter table DBSINGULAR.TB_INSTANCIA_TAREFA 
        add constraint FK_INST_TAR_VERSAO_TAREFA 
        foreign key (CO_VERSAO_TAREFA) 
        references DBSINGULAR.TB_VERSAO_TAREFA; 

    alter table DBSINGULAR.TB_PARAMETRO 
        add constraint FK_PARAMETRO_MODULO 
        foreign key (CO_MODULO) 
        references DBSINGULAR.TB_MODULO; 

    alter table DBSINGULAR.TB_RASCUNHO 
        add constraint FK_RASCUNHO_FORMULARIO 
        foreign key (CO_FORMULARIO) 
        references DBSINGULAR.TB_FORMULARIO; 

    alter table DBSINGULAR.TB_REQUISICAO 
        add constraint FK_REQ_REQUISITANTE 
        foreign key (CO_REQUISITANTE) 
        references DBSINGULAR.TB_REQUISITANTE; 

    alter table DBSINGULAR.TB_REQUISICAO 
        add constraint FK_REQ_DEFINICAO_PROCESSO 
        foreign key (CO_DEFINICAO_PROCESSO) 
        references DBSINGULAR.TB_DEFINICAO_PROCESSO; 

    alter table DBSINGULAR.TB_REQUISICAO 
        add constraint FK_REQ_INSTANCIA_PROCESSO 
        foreign key (CO_INSTANCIA_PROCESSO) 
        references DBSINGULAR.TB_INSTANCIA_PROCESSO; 

    alter table DBSINGULAR.TB_REQUISICAO 
        add constraint FK_REQ_REQUISICAO_PAI 
        foreign key (CO_REQUISICAO_PAI) 
        references DBSINGULAR.TB_REQUISICAO; 

    alter table DBSINGULAR.TB_REQUISICAO 
        add constraint FK_REQ_DEFINICAO_REQUISICAO 
        foreign key (CO_DEFINICAO_REQUISICAO) 
        references DBSINGULAR.TB_DEFINICAO_REQUISICAO; 

    alter table DBSINGULAR.TB_REQUISICAO 
        add constraint FK_REQ_REQUISICAO_RAIZ 
        foreign key (CO_REQUISICAO_RAIZ) 
        references DBSINGULAR.TB_REQUISICAO; 

    alter table DBSINGULAR.TB_VARIAVEL 
        add constraint FK_VARIAVEL_INSTANCIA_PROCESSO 
        foreign key (CO_INSTANCIA_PROCESSO) 
        references DBSINGULAR.TB_INSTANCIA_PROCESSO; 

    alter table DBSINGULAR.TB_VARIAVEL 
        add constraint FK_VARIAVEL_TIPO_VARIAVEL 
        foreign key (CO_TIPO_VARIAVEL) 
        references DBSINGULAR.TB_TIPO_VARIAVEL; 

    alter table DBSINGULAR.TB_VARIAVEL_EXECUCAO_TRANSICAO 
        add constraint FK_VAR_EXEC_TRANS_DEST 
        foreign key (CO_INSTANCIA_TAREFA_DESTINO) 
        references DBSINGULAR.TB_INSTANCIA_TAREFA; 

    alter table DBSINGULAR.TB_VARIAVEL_EXECUCAO_TRANSICAO 
        add constraint FK_VAR_EXEC_TRANS_INST_PROCES 
        foreign key (CO_INSTANCIA_PROCESSO) 
        references DBSINGULAR.TB_INSTANCIA_PROCESSO; 

    alter table DBSINGULAR.TB_VARIAVEL_EXECUCAO_TRANSICAO 
        add constraint FK_VAR_EXEC_TRANS_TAR_ORIGEM 
        foreign key (CO_INSTANCIA_TAREFA_ORIGEM) 
        references DBSINGULAR.TB_INSTANCIA_TAREFA; 

    alter table DBSINGULAR.TB_VARIAVEL_EXECUCAO_TRANSICAO 
        add constraint FK_VAR_EXEC_TRANS_TP_VAR 
        foreign key (CO_TIPO_VARIAVEL) 
        references DBSINGULAR.TB_TIPO_VARIAVEL; 

    alter table DBSINGULAR.TB_VARIAVEL_EXECUCAO_TRANSICAO 
        add constraint FK_VAR_EXEC_TRANS_VAR 
        foreign key (CO_VARIAVEL) 
        references DBSINGULAR.TB_VARIAVEL; 

    alter table DBSINGULAR.TB_VERSAO_ANOTACAO_FORMULARIO 
        add constraint FK_VER_ANOT_FORM_CHV_ANOT 
        foreign key (CO_CHAVE_ANOTACAO, CO_VERSAO_FORMULARIO) 
        references DBSINGULAR.TB_ANOTACAO_FORMULARIO; 

    alter table DBSINGULAR.TB_VERSAO_FORMULARIO 
        add constraint FK_VER_FORM_FORMULARIO 
        foreign key (CO_FORMULARIO) 
        references DBSINGULAR.TB_FORMULARIO; 

    alter table DBSINGULAR.TB_VERSAO_PROCESSO 
        add constraint FK_VER_PROCES_DEFI_PROCES 
        foreign key (CO_DEFINICAO_PROCESSO) 
        references DBSINGULAR.TB_DEFINICAO_PROCESSO; 

    alter table DBSINGULAR.TB_VERSAO_TAREFA 
        add constraint FK_VER_TAR_VERSAO_PROCESSO 
        foreign key (CO_VERSAO_PROCESSO) 
        references DBSINGULAR.TB_VERSAO_PROCESSO; 

    alter table DBSINGULAR.TB_VERSAO_TAREFA 
        add constraint FK_VER_TAR_DEFINICAO_TAREFA 
        foreign key (CO_DEFINICAO_TAREFA) 
        references DBSINGULAR.TB_DEFINICAO_TAREFA; 

    alter table DBSINGULAR.TB_VERSAO_TRANSICAO 
        add constraint FK_VER_TRANS_VER_TAR_DEST 
        foreign key (CO_VERSAO_TAREFA_DESTINO) 
        references DBSINGULAR.TB_VERSAO_TAREFA; 

    alter table DBSINGULAR.TB_VERSAO_TRANSICAO 
        add constraint FK_VER_TRANS_VER_TAR_ORIG 
        foreign key (CO_VERSAO_TAREFA_ORIGEM) 
        references DBSINGULAR.TB_VERSAO_TAREFA; 
CREATE ALIAS dateDiffInDays FOR "org.opensingular.lib.support.persistence.util.H2Functions.dateDiffInDays";
INSERT INTO DBSINGULAR.TB_MODULO (CO_MODULO, NO_MODULO, URL_CONEXAO) VALUES ('SAMPLE', 'SAMPLE','https://localhost:8443/');


insert into dbsingular.tb_parametro (CO_MODULO, NO_PARAMETRO, VL_PARAMETRO) values ('SAMPLE','ADMIN_HASH_PASSWORD','0aca995b93addee9348dcef9016c0f9624dfae3a');
insert into dbsingular.tb_parametro (CO_MODULO, NO_PARAMETRO, VL_PARAMETRO) values ('SAMPLE','ADMIN_USERNAME','singular');
/*Esse Script é um default, provavelmente deverá ser alterado para suportar o ator especifico do cliente.*/

/*==============================================================*/
/* Table: TB_ATOR                                               */
/*==============================================================*/
CREATE TABLE DBSINGULAR.TB_ATOR (
   CO_ATOR  INTEGER NOT NULL IDENTITY,
   CO_USUARIO           VARCHAR(60)          NOT NULL,
  CONSTRAINT PK_ATOR PRIMARY KEY (CO_ATOR)
);

/*==============================================================*/
/* View: VW_ATOR                                    */
/*==============================================================*/
create view DBSINGULAR.VW_ATOR AS
SELECT A.CO_ATOR, A.CO_USUARIO as CO_USUARIO, A.CO_USUARIO as NO_ATOR, ' ' as DS_EMAIL
FROM DBSINGULAR.TB_ATOR A;
-- Thanks to Amir Kibbar and Peter Rietzler for contributing the schema for H2 database,
-- and verifying that it works with Quartz's StdJDBCDelegate
--
-- Note, Quartz depends on row-level locking which means you must use the MVCC=TRUE
-- setting on your H2 database, or you will experience dead-locks
--
--
-- In your Quartz properties file, you'll need to set
-- org.quartz.jobStore.driverDelegateClass = org.quartz.impl.jdbcjobstore.StdJDBCDelegate

CREATE TABLE QRTZ_CALENDARS (
  SCHED_NAME VARCHAR(120) NOT NULL,
  CALENDAR_NAME VARCHAR (200)  NOT NULL ,
  CALENDAR IMAGE NOT NULL
);

CREATE TABLE QRTZ_CRON_TRIGGERS (
  SCHED_NAME VARCHAR(120) NOT NULL,
  TRIGGER_NAME VARCHAR (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR (200)  NOT NULL ,
  CRON_EXPRESSION VARCHAR (120)  NOT NULL ,
  TIME_ZONE_ID VARCHAR (80)
);

CREATE TABLE QRTZ_FIRED_TRIGGERS (
  SCHED_NAME VARCHAR(120) NOT NULL,
  ENTRY_ID VARCHAR (95)  NOT NULL ,
  TRIGGER_NAME VARCHAR (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR (200)  NOT NULL ,
  INSTANCE_NAME VARCHAR (200)  NOT NULL ,
  FIRED_TIME BIGINT NOT NULL ,
  SCHED_TIME BIGINT NOT NULL ,
  PRIORITY INTEGER NOT NULL ,
  STATE VARCHAR (16)  NOT NULL,
  JOB_NAME VARCHAR (200)  NULL ,
  JOB_GROUP VARCHAR (200)  NULL ,
  IS_NONCONCURRENT BOOLEAN  NULL ,
  REQUESTS_RECOVERY BOOLEAN  NULL
);

CREATE TABLE QRTZ_PAUSED_TRIGGER_GRPS (
  SCHED_NAME VARCHAR(120) NOT NULL,
  TRIGGER_GROUP VARCHAR (200)  NOT NULL
);

CREATE TABLE QRTZ_SCHEDULER_STATE (
  SCHED_NAME VARCHAR(120) NOT NULL,
  INSTANCE_NAME VARCHAR (200)  NOT NULL ,
  LAST_CHECKIN_TIME BIGINT NOT NULL ,
  CHECKIN_INTERVAL BIGINT NOT NULL
);

CREATE TABLE QRTZ_LOCKS (
  SCHED_NAME VARCHAR(120) NOT NULL,
  LOCK_NAME VARCHAR (40)  NOT NULL
);

CREATE TABLE QRTZ_JOB_DETAILS (
  SCHED_NAME VARCHAR(120) NOT NULL,
  JOB_NAME VARCHAR (200)  NOT NULL ,
  JOB_GROUP VARCHAR (200)  NOT NULL ,
  DESCRIPTION VARCHAR (250) NULL ,
  JOB_CLASS_NAME VARCHAR (250)  NOT NULL ,
  IS_DURABLE BOOLEAN  NOT NULL ,
  IS_NONCONCURRENT BOOLEAN  NOT NULL ,
  IS_UPDATE_DATA BOOLEAN  NOT NULL ,
  REQUESTS_RECOVERY BOOLEAN  NOT NULL ,
  JOB_DATA IMAGE NULL
);

CREATE TABLE QRTZ_SIMPLE_TRIGGERS (
  SCHED_NAME VARCHAR(120) NOT NULL,
  TRIGGER_NAME VARCHAR (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR (200)  NOT NULL ,
  REPEAT_COUNT BIGINT NOT NULL ,
  REPEAT_INTERVAL BIGINT NOT NULL ,
  TIMES_TRIGGERED BIGINT NOT NULL
);

CREATE TABLE qrtz_simprop_triggers
  (
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    STR_PROP_1 VARCHAR(512) NULL,
    STR_PROP_2 VARCHAR(512) NULL,
    STR_PROP_3 VARCHAR(512) NULL,
    INT_PROP_1 INTEGER NULL,
    INT_PROP_2 INTEGER NULL,
    LONG_PROP_1 BIGINT NULL,
    LONG_PROP_2 BIGINT NULL,
    DEC_PROP_1 NUMERIC(13,4) NULL,
    DEC_PROP_2 NUMERIC(13,4) NULL,
    BOOL_PROP_1 BOOLEAN NULL,
    BOOL_PROP_2 BOOLEAN NULL,
);

CREATE TABLE QRTZ_BLOB_TRIGGERS (
  SCHED_NAME VARCHAR(120) NOT NULL,
  TRIGGER_NAME VARCHAR (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR (200)  NOT NULL ,
  BLOB_DATA IMAGE NULL
);

CREATE TABLE QRTZ_TRIGGERS (
  SCHED_NAME VARCHAR(120) NOT NULL,
  TRIGGER_NAME VARCHAR (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR (200)  NOT NULL ,
  JOB_NAME VARCHAR (200)  NOT NULL ,
  JOB_GROUP VARCHAR (200)  NOT NULL ,
  DESCRIPTION VARCHAR (250) NULL ,
  NEXT_FIRE_TIME BIGINT NULL ,
  PREV_FIRE_TIME BIGINT NULL ,
  PRIORITY INTEGER NULL ,
  TRIGGER_STATE VARCHAR (16)  NOT NULL ,
  TRIGGER_TYPE VARCHAR (8)  NOT NULL ,
  START_TIME BIGINT NOT NULL ,
  END_TIME BIGINT NULL ,
  CALENDAR_NAME VARCHAR (200)  NULL ,
  MISFIRE_INSTR SMALLINT NULL ,
  JOB_DATA IMAGE NULL
);

ALTER TABLE QRTZ_CALENDARS  ADD
  CONSTRAINT PK_QRTZ_CALENDARS PRIMARY KEY
  (
    SCHED_NAME,
    CALENDAR_NAME
  );

ALTER TABLE QRTZ_CRON_TRIGGERS  ADD
  CONSTRAINT PK_QRTZ_CRON_TRIGGERS PRIMARY KEY
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  );

ALTER TABLE QRTZ_FIRED_TRIGGERS  ADD
  CONSTRAINT PK_QRTZ_FIRED_TRIGGERS PRIMARY KEY
  (
    SCHED_NAME,
    ENTRY_ID
  );

ALTER TABLE QRTZ_PAUSED_TRIGGER_GRPS  ADD
  CONSTRAINT PK_QRTZ_PAUSED_TRIGGER_GRPS PRIMARY KEY
  (
    SCHED_NAME,
    TRIGGER_GROUP
  );

ALTER TABLE QRTZ_SCHEDULER_STATE  ADD
  CONSTRAINT PK_QRTZ_SCHEDULER_STATE PRIMARY KEY
  (
    SCHED_NAME,
    INSTANCE_NAME
  );

ALTER TABLE QRTZ_LOCKS  ADD
  CONSTRAINT PK_QRTZ_LOCKS PRIMARY KEY
  (
    SCHED_NAME,
    LOCK_NAME
  );

ALTER TABLE QRTZ_JOB_DETAILS  ADD
  CONSTRAINT PK_QRTZ_JOB_DETAILS PRIMARY KEY
  (
    SCHED_NAME,
    JOB_NAME,
    JOB_GROUP
  );

ALTER TABLE QRTZ_SIMPLE_TRIGGERS  ADD
  CONSTRAINT PK_QRTZ_SIMPLE_TRIGGERS PRIMARY KEY
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  );

ALTER TABLE QRTZ_SIMPROP_TRIGGERS  ADD
  CONSTRAINT PK_QRTZ_SIMPROP_TRIGGERS PRIMARY KEY
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  );

ALTER TABLE QRTZ_TRIGGERS  ADD
  CONSTRAINT PK_QRTZ_TRIGGERS PRIMARY KEY
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  );

ALTER TABLE QRTZ_CRON_TRIGGERS ADD
  CONSTRAINT FK_QRTZ_CRON_TRIGGERS_QRTZ_TRIGGERS FOREIGN KEY
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  ) REFERENCES QRTZ_TRIGGERS (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  ) ON DELETE CASCADE;


ALTER TABLE QRTZ_SIMPLE_TRIGGERS ADD
  CONSTRAINT FK_QRTZ_SIMPLE_TRIGGERS_QRTZ_TRIGGERS FOREIGN KEY
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  ) REFERENCES QRTZ_TRIGGERS (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  ) ON DELETE CASCADE;

ALTER TABLE QRTZ_SIMPROP_TRIGGERS ADD
  CONSTRAINT FK_QRTZ_SIMPROP_TRIGGERS_QRTZ_TRIGGERS FOREIGN KEY
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  ) REFERENCES QRTZ_TRIGGERS (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  ) ON DELETE CASCADE;


ALTER TABLE QRTZ_TRIGGERS ADD
  CONSTRAINT FK_QRTZ_TRIGGERS_QRTZ_JOB_DETAILS FOREIGN KEY
  (
    SCHED_NAME,
    JOB_NAME,
    JOB_GROUP
  ) REFERENCES QRTZ_JOB_DETAILS (
    SCHED_NAME,
    JOB_NAME,
    JOB_GROUP
  );

COMMIT;

