/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.requirement.connector.sei31.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class EncodeUtil {
    private EncodeUtil() {
        throw new UnsupportedOperationException("No " + EncodeUtil.class.getSimpleName() + " instances for you!");
    }

    public static String encodeToBase64(File file) throws IOException {
        return EncodeUtil.encodeToBase64(new FileInputStream(file), (int)file.length());
    }

    public static String encodeToBase64(InputStream fis, int size) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)fis);
        fis.close();
        return new String(Base64.encodeBase64((byte[])bytes), StandardCharsets.UTF_8);
    }

    public static String encodeToBase64(String value) {
        return StringUtils.isNotEmpty((CharSequence)value) ? Base64.encodeBase64String((byte[])value.getBytes(StandardCharsets.UTF_8)) : null;
    }

    public static String decodeFromBase64(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            byte[] decodedBytes = Base64.decodeBase64((String)value);
            return new String(decodedBytes, StandardCharsets.UTF_8);
        }
        return "";
    }

    public static String decodeFromBase64Iso(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            byte[] decodedBytes = Base64.decodeBase64((String)value);
            return new String(decodedBytes, StandardCharsets.ISO_8859_1);
        }
        return "";
    }
}

