/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.requirement.connector.sei31.builder;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.activation.DataHandler;
import javax.annotation.Nullable;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.commons.util.TempFileUtils;
import org.opensingular.requirement.connector.sei31.model.NivelAcesso;
import org.opensingular.requirement.connector.sei31.model.Serie;
import org.opensingular.requirement.connector.sei31.model.SerieEnum;
import org.opensingular.requirement.connector.sei31.model.TipoDocumento;
import org.opensingular.requirement.connector.sei31.util.EncodeUtil;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfDestinatario;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfInteressado;
import org.opensingular.requirement.connector.sei31.ws.Destinatario;
import org.opensingular.requirement.connector.sei31.ws.Documento;
import org.opensingular.requirement.connector.sei31.ws.Interessado;
import org.opensingular.requirement.connector.sei31.ws.Remetente;

public class DocumentoBuilder
implements Serializable,
Loggable {
    private static final String ERRO_CARREGAR_ARQUIVO = "Erro ao carregar arquivo";
    private transient Documento documento;

    public DocumentoBuilder() {
        this.documento = new Documento();
    }

    public DocumentoBuilder(Documento documento) {
        this.documento = documento;
    }

    public DocumentoBuilder setTipo(TipoDocumento tipoDocumento) {
        this.documento.setTipo(tipoDocumento.getCodigo());
        return this;
    }

    public DocumentoBuilder setIdProcedimento(String value) {
        this.documento.setIdProcedimento(value);
        return this;
    }

    public DocumentoBuilder setSerie(SerieEnum value) {
        this.documento.setIdSerie(value.getId());
        return this;
    }

    public DocumentoBuilder setSerie(Serie serie) {
        this.documento.setIdSerie(serie.getId());
        return this;
    }

    public DocumentoBuilder setSerie(String serieId) {
        this.documento.setIdSerie(serieId);
        return this;
    }

    public DocumentoBuilder setNumero(String value) {
        this.documento.setNumero(value);
        return this;
    }

    @Deprecated
    public DocumentoBuilder setData(String value) {
        this.documento.setData(value);
        return this;
    }

    public DocumentoBuilder setData(Date value) {
        this.documento.setData(new SimpleDateFormat("dd/MM/yyyy").format(value));
        return this;
    }

    public DocumentoBuilder setDescricao(String value) {
        this.documento.setDescricao(value);
        return this;
    }

    public DocumentoBuilder setRemetente(String value) {
        Remetente rementente = new Remetente();
        rementente.setNome(value);
        this.documento.setRemetente(rementente);
        return this;
    }

    public DocumentoBuilder setInteressados(String ... interessados) {
        ArrayOfInteressado arrayOfInteressado = new ArrayOfInteressado();
        this.documento.setInteressados(arrayOfInteressado);
        if (interessados != null) {
            for (String nome : interessados) {
                this.addInteressado(nome);
            }
        }
        return this;
    }

    public DocumentoBuilder addInteressado(String interessado) {
        if (this.documento.getInteressados() == null) {
            this.documento.setInteressados(new ArrayOfInteressado());
        }
        Interessado e = new Interessado();
        e.setNome(interessado);
        this.documento.getInteressados().getItem().add(e);
        return this;
    }

    public DocumentoBuilder setDestinatarios(List<Destinatario> destinatarios) {
        ArrayOfDestinatario arrayOfDestinatario = new ArrayOfDestinatario();
        this.documento.setDestinatarios(arrayOfDestinatario);
        this.documento.getDestinatarios().getItem().addAll(destinatarios);
        return this;
    }

    public DocumentoBuilder addDestinatario(String sigla, String nome) {
        if (this.documento.getDestinatarios() == null) {
            this.documento.setDestinatarios(new ArrayOfDestinatario());
        }
        Destinatario destinatario = new Destinatario();
        destinatario.setNome(nome);
        destinatario.setSigla(sigla);
        this.documento.getDestinatarios().getItem().add(destinatario);
        return this;
    }

    public DocumentoBuilder setObservacao(String value) {
        this.documento.setObservacao(value);
        return this;
    }

    public DocumentoBuilder setNomeArquivo(String value) {
        this.documento.setNomeArquivo(value);
        return this;
    }

    public DocumentoBuilder setConteudo(String value) {
        try {
            this.documento.setConteudoMTOM(new DataHandler(TempFileUtils.transferToTempFile((String)value).toURI().toURL()));
        }
        catch (Exception e) {
            this.getLogger().error(ERRO_CARREGAR_ARQUIVO, (Throwable)e);
            throw SingularException.rethrow((String)ERRO_CARREGAR_ARQUIVO, (Throwable)e);
        }
        return this;
    }

    public DocumentoBuilder setConteudoString(String value) {
        this.documento.setConteudo(value);
        return this;
    }

    public DocumentoBuilder setConteudo(File arquivo) {
        try {
            this.documento.setConteudoMTOM(new DataHandler(arquivo.toURI().toURL()));
        }
        catch (Exception e) {
            this.getLogger().error(ERRO_CARREGAR_ARQUIVO, (Throwable)e);
            throw SingularException.rethrow((String)ERRO_CARREGAR_ARQUIVO, (Throwable)e);
        }
        return this;
    }

    public DocumentoBuilder setConteudo(InputStream arquivo) {
        try {
            this.documento.setConteudoMTOM(new DataHandler(TempFileUtils.stream2file((InputStream)arquivo).toURI().toURL()));
        }
        catch (Exception e) {
            this.getLogger().error(ERRO_CARREGAR_ARQUIVO, (Throwable)e);
            throw SingularException.rethrow((String)ERRO_CARREGAR_ARQUIVO, (Throwable)e);
        }
        return this;
    }

    public DocumentoBuilder setConteudoBinario(byte[] binaryData) {
        try {
            this.documento.setConteudoMTOM(new DataHandler(TempFileUtils.createTempFile((byte[])binaryData).toURI().toURL()));
        }
        catch (Exception e) {
            this.getLogger().error(ERRO_CARREGAR_ARQUIVO, (Throwable)e);
            throw SingularException.rethrow((String)ERRO_CARREGAR_ARQUIVO, (Throwable)e);
        }
        return this;
    }

    public DocumentoBuilder setConteudoTextual(byte[] binaryData) {
        try {
            this.documento.setConteudoMTOM(new DataHandler(TempFileUtils.decodeToTempFile((String)new String(binaryData, Charset.forName("UTF-8"))).toURI().toURL()));
        }
        catch (Exception e) {
            this.getLogger().error(ERRO_CARREGAR_ARQUIVO, (Throwable)e);
            throw SingularException.rethrow((String)ERRO_CARREGAR_ARQUIVO, (Throwable)e);
        }
        return this;
    }

    public DocumentoBuilder setConteudo(DataHandler value) {
        this.documento.setConteudoMTOM(value);
        return this;
    }

    public DocumentoBuilder setNivelAcesso(@Nullable NivelAcesso nivelAcesso) {
        if (nivelAcesso != null) {
            this.documento.setNivelAcesso(nivelAcesso.getCodigo());
        }
        return this;
    }

    public DocumentoBuilder setIdArquivo(String idArquivo) {
        this.documento.setIdArquivo(idArquivo);
        return this;
    }

    public DocumentoBuilder setIdTipoConferencia(String idTipoConferencia) {
        this.documento.setIdTipoConferencia(idTipoConferencia);
        return this;
    }

    public DocumentoBuilder setSinBloqueado(String sinBloqueado) {
        this.documento.setSinBloqueado(sinBloqueado);
        return this;
    }

    public DocumentoBuilder setProtocoloProcedimento(String protocoloProcedimento) {
        this.documento.setProtocoloProcedimento(protocoloProcedimento);
        return this;
    }

    public Documento createDocumento() {
        this.definirValoresDefault();
        return this.documento;
    }

    private void definirValoresDefault() {
        if (this.documento.getDestinatarios() == null) {
            this.documento.setDestinatarios(new ArrayOfDestinatario());
        }
        if (this.documento.getInteressados() == null) {
            this.documento.setInteressados(new ArrayOfInteressado());
        }
        if (this.documento.getNivelAcesso() == null) {
            this.documento.setNivelAcesso(NivelAcesso.PUBLICO.getCodigo());
        }
        if (this.documento.getObservacao() == null) {
            this.documento.setObservacao("");
        }
    }

    public DocumentoBuilder setConteudoBase64(String conteudo) {
        this.documento.setConteudo(EncodeUtil.encodeToBase64(conteudo));
        return this;
    }

    public DocumentoBuilder setIdHipoteseLegal(String idHipoteseLegal) {
        this.documento.setIdHipoteseLegal(idHipoteseLegal);
        return this;
    }
}

